/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzaps;
import com.google.android.gms.internal.ads.zzapt;
import javax.annotation.concurrent.GuardedBy;

@zzadh
final class zzapr
implements SensorEventListener {
    private final SensorManager zzcyn;
    private final Object zzcyo;
    private final Display zzcyp;
    private final float[] zzcyq;
    private final float[] zzcyr;
    @GuardedBy(value="mSensorThreadLock")
    private float[] zzcys;
    private Handler zzcyt;
    private zzapt zzcyu;

    zzapr(Context context) {
        this.zzcyn = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzcyp = windowManager.getDefaultDisplay();
        this.zzcyq = new float[9];
        this.zzcyr = new float[9];
        this.zzcyo = new Object();
    }

    final void start() {
        if (this.zzcyt != null) {
            return;
        }
        Sensor sensor = this.zzcyn.getDefaultSensor(11);
        if (sensor == null) {
            zzakb.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzcyt = new Handler(handlerThread.getLooper());
        if (!this.zzcyn.registerListener((SensorEventListener)this, sensor, 0, this.zzcyt)) {
            zzakb.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzcyt == null) {
            return;
        }
        this.zzcyn.unregisterListener((SensorEventListener)this);
        this.zzcyt.post((Runnable)new zzaps(this));
        this.zzcyt = null;
    }

    final void zza(zzapt zzapt2) {
        this.zzcyu = zzapt2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzapr zzapr2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzapr2.zzcyo;
            synchronized (object) {
                if (zzapr2.zzcys == null) {
                    zzapr2.zzcys = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzapr2.zzcyq, (float[])fArray);
            switch (zzapr2.zzcyp.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzapr2.zzcyq, (int)2, (int)129, (float[])zzapr2.zzcyr);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzapr2.zzcyq, (int)129, (int)130, (float[])zzapr2.zzcyr);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzapr2.zzcyq, (int)130, (int)1, (float[])zzapr2.zzcyr);
                    break;
                }
                default: {
                    System.arraycopy(zzapr2.zzcyq, 0, zzapr2.zzcyr, 0, 9);
                }
            }
            zzapr2.zzg(1, 3);
            zzapr2.zzg(2, 6);
            zzapr2.zzg(5, 7);
            Object object2 = zzapr2.zzcyo;
            synchronized (object2) {
                System.arraycopy(zzapr2.zzcyr, 0, zzapr2.zzcys, 0, 9);
            }
            if (zzapr2.zzcyu != null) {
                zzapr2.zzcyu.zznn();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzcyo;
        synchronized (object) {
            if (this.zzcys == null) {
                return false;
            }
            System.arraycopy(this.zzcys, 0, fArray, 0, this.zzcys.length);
            return true;
        }
    }

    private final void zzg(int n, int n2) {
        float f = this.zzcyr[n];
        this.zzcyr[n] = this.zzcyr[n2];
        this.zzcyr[n2] = f;
    }
}

