/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzapf;
import com.google.android.gms.internal.ads.zzapg;
import com.google.android.gms.internal.ads.zzapj;
import com.google.android.gms.internal.ads.zzapk;
import com.google.android.gms.internal.ads.zzapl;
import com.google.android.gms.internal.ads.zzapm;
import com.google.android.gms.internal.ads.zzapv;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzapy;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznx;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzapi
extends FrameLayout
implements zzapf {
    private final zzapw zzcxm;
    private final FrameLayout zzcxn;
    private final zznx zzcxo;
    private final zzapy zzcxp;
    private final long zzcxq;
    @Nullable
    private zzapg zzcxr;
    private boolean zzcxs;
    private boolean zzcxt;
    private boolean zzcxu;
    private boolean zzcxv;
    private long zzcxw;
    private long zzcxx;
    private String zzcxy;
    private Bitmap zzcxz;
    private ImageView zzcya;
    private boolean zzcyb;

    public static void zza(zzapw zzapw2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzapw2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzapw zzapw2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzapw2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzapw zzapw2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzapw2.zza("onVideoEvent", hashMap);
    }

    public zzapi(Context context, zzapw zzapw2, int n, boolean bl, zznx zznx2, zzapv zzapv2) {
        super(context);
        zzna zzna2;
        this.zzcxm = zzapw2;
        this.zzcxo = zznx2;
        this.zzcxn = new FrameLayout(context);
        this.addView((View)this.zzcxn, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Asserts.checkNotNull((Object)zzapw2.zzbi());
        this.zzcxr = zzapw2.zzbi().zzwz.zza(context, zzapw2, n, bl, zznx2, zzapv2);
        if (this.zzcxr != null) {
            this.zzcxn.addView((View)this.zzcxr, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzna2 = zznk.zzavg;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                this.zztd();
            }
        }
        this.zzcya = new ImageView(context);
        zzna2 = zznk.zzavk;
        this.zzcxq = (Long)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzavi;
        this.zzcxv = (Boolean)zzkb.zzik().zzd(zzna2);
        if (this.zzcxo != null) {
            this.zzcxo.zze("spinner_used", this.zzcxv ? "1" : "0");
        }
        this.zzcxp = new zzapy(this);
        if (this.zzcxr != null) {
            this.zzcxr.zza(this);
        }
        if (this.zzcxr == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzcxn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzdn(String string2) {
        this.zzcxy = string2;
    }

    public final void zza(float f, float f2) {
        if (this.zzcxr != null) {
            this.zzcxr.zza(f, f2);
        }
    }

    public final void zzta() {
        if (this.zzcxr == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzcxy)) {
            this.zzcxr.setVideoPath(this.zzcxy);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzcxr == null) {
            return;
        }
        this.zzcxr.pause();
    }

    public final void play() {
        if (this.zzcxr == null) {
            return;
        }
        this.zzcxr.play();
    }

    public final void seekTo(int n) {
        if (this.zzcxr == null) {
            return;
        }
        this.zzcxr.seekTo(n);
    }

    public final void zztb() {
        if (this.zzcxr == null) {
            return;
        }
        zzapg zzapg2 = this.zzcxr;
        zzapg2.zzcxl.setMuted(true);
        zzapg2.zzst();
    }

    public final void zztc() {
        if (this.zzcxr == null) {
            return;
        }
        zzapg zzapg2 = this.zzcxr;
        zzapg2.zzcxl.setMuted(false);
        zzapg2.zzst();
    }

    public final void setVolume(float f) {
        if (this.zzcxr == null) {
            return;
        }
        float f2 = f;
        zzapg zzapg2 = this.zzcxr;
        zzapg2.zzcxl.setVolume(f2);
        zzapg2.zzst();
    }

    @TargetApi(value=14)
    public final void zzf(MotionEvent motionEvent) {
        if (this.zzcxr == null) {
            return;
        }
        this.zzcxr.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zztd() {
        if (this.zzcxr == null) {
            return;
        }
        Context context = this.zzcxr.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzcxr.zzsp());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzcxn.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzcxn.bringChildToFront((View)textView);
    }

    @Override
    public final void zzsu() {
        this.zzcxp.resume();
        zzakk.zzcrm.post((Runnable)new zzapk(this));
    }

    @Override
    public final void zzsv() {
        if (this.zzcxr == null) {
            return;
        }
        if (this.zzcxx == 0L) {
            float f = (float)this.zzcxr.getDuration() / 1000.0f;
            int n = this.zzcxr.getVideoWidth();
            int n2 = this.zzcxr.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzsw() {
        zzapi zzapi2 = this;
        if (zzapi2.zzcxm.zzto() != null && !zzapi2.zzcxt) {
            WindowManager.LayoutParams layoutParams = zzapi2.zzcxm.zzto().getWindow().getAttributes();
            boolean bl = zzapi2.zzcxu = (layoutParams.flags & 0x80) != 0;
            if (!zzapi2.zzcxu) {
                zzapi2.zzcxm.zzto().getWindow().addFlags(128);
                zzapi2.zzcxt = true;
            }
        }
        this.zzcxs = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zztg();
        this.zzcxs = false;
    }

    @Override
    public final void zzsx() {
        this.zza("ended", new String[0]);
        this.zztg();
    }

    @Override
    public final void zzg(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzsy() {
        zzapi zzapi2 = this;
        if (zzapi2.zzcyb && zzapi2.zzcxz != null && !zzapi2.zztf()) {
            zzapi2.zzcya.setImageBitmap(zzapi2.zzcxz);
            zzapi2.zzcya.invalidate();
            zzapi2.zzcxn.addView((View)zzapi2.zzcya, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzapi2.zzcxn.bringChildToFront((View)zzapi2.zzcya);
        }
        this.zzcxp.pause();
        this.zzcxx = this.zzcxw;
        zzakk.zzcrm.post((Runnable)new zzapl(this));
    }

    public final void destroy() {
        this.zzcxp.pause();
        if (this.zzcxr != null) {
            this.zzcxr.stop();
        }
        this.zztg();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzcxp.pause();
            if (this.zzcxr != null) {
                zzapg zzapg2;
                zzapg zzapg3 = zzapg2 = this.zzcxr;
                zzapg3.getClass();
                zzaoe.zzcvy.execute(zzapj.zza(zzapg3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzte() {
        if (this.zzcxr == null) {
            return;
        }
        long l = this.zzcxr.getCurrentPosition();
        if (this.zzcxw != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzcxw = l;
        }
    }

    @Override
    public final void zzsz() {
        zzapi zzapi2;
        if (this.zzcxs && (zzapi2 = this).zztf()) {
            zzapi2.zzcxn.removeView((View)zzapi2.zzcya);
        }
        zzapi2 = this;
        if (zzapi2.zzcxz != null) {
            long l = zzbv.zzer().elapsedRealtime();
            if (zzapi2.zzcxr.getBitmap(zzapi2.zzcxz) != null) {
                zzapi2.zzcyb = true;
            }
            long l2 = zzbv.zzer().elapsedRealtime() - l;
            if (zzakb.zzqp()) {
                zzakb.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzapi2.zzcxq) {
                zzakb.zzdk((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzapi2.zzcxv = false;
                zzapi2.zzcxz = null;
                if (zzapi2.zzcxo != null) {
                    zzapi2.zzcxo.zze("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzf(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzapi zzapi2 = this;
        if (zzapi2.zzcxv) {
            zzna zzna2 = zznk.zzavj;
            n4 = Math.max(n4 / (Integer)zzkb.zzik().zzd(zzna2), 1);
            zzna2 = zznk.zzavj;
            n3 = Math.max(n3 / (Integer)zzkb.zzik().zzd(zzna2), 1);
            if (zzapi2.zzcxz == null || zzapi2.zzcxz.getWidth() != n4 || zzapi2.zzcxz.getHeight() != n3) {
                zzapi2.zzcxz = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzapi2.zzcyb = false;
            }
        }
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        if (n == 0) {
            this.zzcxp.resume();
            bl = true;
        } else {
            this.zzcxp.pause();
            this.zzcxx = this.zzcxw;
            bl = false;
        }
        zzakk.zzcrm.post((Runnable)new zzapm(this, bl));
    }

    private final boolean zztf() {
        return this.zzcya.getParent() != null;
    }

    private final void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzcxm.zza("onVideoEvent", hashMap);
    }

    private final void zztg() {
        if (this.zzcxm.zzto() == null) {
            return;
        }
        if (this.zzcxt && !this.zzcxu) {
            this.zzcxm.zzto().getWindow().clearFlags(128);
            this.zzcxt = false;
        }
    }

    static /* synthetic */ void zza(zzapi zzapi2, String string2, String[] stringArray) {
        zzapi2.zza(string2, stringArray);
    }
}

