/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzaow;
import com.google.android.gms.internal.ads.zzaox;
import com.google.android.gms.internal.ads.zzaoy;
import com.google.android.gms.internal.ads.zzaoz;
import com.google.android.gms.internal.ads.zzapa;
import com.google.android.gms.internal.ads.zzapb;
import com.google.android.gms.internal.ads.zzapc;
import com.google.android.gms.internal.ads.zzapd;
import com.google.android.gms.internal.ads.zzape;
import com.google.android.gms.internal.ads.zzapf;
import com.google.android.gms.internal.ads.zzapg;
import com.google.android.gms.internal.ads.zzapu;
import com.google.android.gms.internal.ads.zzapv;
import com.google.android.gms.internal.ads.zzapx;
import com.google.android.gms.internal.ads.zzhl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzadh
@TargetApi(value=14)
public final class zzaov
extends zzapg
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzcwo = new HashMap<Integer, String>();
    private final zzapx zzcwp;
    private final boolean zzcwq;
    private int zzcwr = 0;
    private int zzcws = 0;
    private MediaPlayer zzcwt;
    private Uri zzcwu;
    private int zzcwv;
    private int zzcww;
    private int zzcwx;
    private int zzcwy;
    private int zzcwz;
    private zzapu zzcxa;
    private boolean zzcxb;
    private int zzcxc;
    private zzapf zzcxd;

    public zzaov(Context context, boolean bl, boolean bl2, zzapv zzapv2, zzapx zzapx2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzcwp = zzapx2;
        this.zzcxb = bl;
        this.zzcwq = bl2;
        this.zzcwp.zzb(this);
    }

    @Override
    public final String zzsp() {
        String string2 = String.valueOf(this.zzcxb ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzapf zzapf2) {
        this.zzcxd = zzapf2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzaov zzaov2 = this;
        zzhl zzhl2 = zzhl.zzd(uri);
        zzaov2.zzcwu = zzhl2 == null ? uri : Uri.parse((String)zzhl2.url);
        zzaov2.zzcxc = 0;
        zzaov2.zzsq();
        zzaov2.requestLayout();
        zzaov2.invalidate();
    }

    @Override
    public final void stop() {
        zzakb.v("AdMediaPlayerView stop");
        if (this.zzcwt != null) {
            this.zzcwt.stop();
            this.zzcwt.release();
            this.zzcwt = null;
            this.zzag(0);
            this.zzcws = 0;
        }
        this.zzcwp.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzakb.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzcwv = mediaPlayer.getVideoWidth();
        this.zzcww = mediaPlayer.getVideoHeight();
        if (this.zzcwv != 0 && this.zzcww != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzakb.v("AdMediaPlayerView prepared");
        this.zzag(2);
        this.zzcwp.zzsv();
        zzakk.zzcrm.post((Runnable)new zzaox(this));
        this.zzcwv = mediaPlayer.getVideoWidth();
        this.zzcww = mediaPlayer.getVideoHeight();
        if (this.zzcxc != 0) {
            ((zzapg)this).seekTo(this.zzcxc);
        }
        this.zzsr();
        int n = this.zzcwv;
        int n2 = this.zzcww;
        zzakb.zzdj((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzcws == 3) {
            ((zzapg)this).play();
        }
        ((zzapg)this).zzst();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzakb.v("AdMediaPlayerView completion");
        this.zzag(5);
        this.zzcws = 5;
        zzakk.zzcrm.post((Runnable)new zzaoy(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzcwo.get(n);
        String string3 = zzcwo.get(n2);
        zzakb.v(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzcwo.get(n);
        String string3 = zzcwo.get(n2);
        zzakb.zzdk((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzag(-1);
        this.zzcws = -1;
        zzakk.zzcrm.post((Runnable)new zzaoz(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzcwx = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzakb.v("AdMediaPlayerView surface created");
        this.zzsq();
        zzakk.zzcrm.post((Runnable)new zzapa(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzakb.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzcws == 3;
        boolean bl3 = bl = this.zzcwv == n && this.zzcww == n2;
        if (this.zzcwt != null && bl2 && bl) {
            if (this.zzcxc != 0) {
                ((zzapg)this).seekTo(this.zzcxc);
            }
            ((zzapg)this).play();
        }
        if (this.zzcxa != null) {
            this.zzcxa.zzh(n, n2);
        }
        zzakk.zzcrm.post((Runnable)new zzapb(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzakb.v("AdMediaPlayerView surface destroyed");
        if (this.zzcwt != null && this.zzcxc == 0) {
            this.zzcxc = this.zzcwt.getCurrentPosition();
        }
        if (this.zzcxa != null) {
            this.zzcxa.zzti();
        }
        zzakk.zzcrm.post((Runnable)new zzapc(this));
        this.zzag(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzcwp.zzc(this);
        this.zzcxk.zza(surfaceTexture, this.zzcxd);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzakb.v(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzakk.zzcrm.post((Runnable)new zzaow(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzaov.getDefaultSize((int)this.zzcwv, (int)n);
        int n4 = zzaov.getDefaultSize((int)this.zzcww, (int)n2);
        if (this.zzcwv > 0 && this.zzcww > 0 && this.zzcxa == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzcwv * n4 < n3 * this.zzcww) {
                    n3 = n4 * this.zzcwv / this.zzcww;
                } else if (this.zzcwv * n4 > n3 * this.zzcww) {
                    n4 = n3 * this.zzcww / this.zzcwv;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzcww / this.zzcwv;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzcwv / this.zzcww;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzcwv;
                n4 = this.zzcww;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzcwv / this.zzcww;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzcww / this.zzcwv;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzcxa != null) {
            this.zzcxa.zzh(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzcwy > 0 && this.zzcwy != n3 || this.zzcwz > 0 && this.zzcwz != n4) {
                this.zzsr();
            }
            this.zzcwy = n3;
            this.zzcwz = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzsq() {
        zzakb.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzcwu == null || surfaceTexture == null) {
            return;
        }
        this.zzag(false);
        try {
            Surface surface;
            zzbv.zzfb();
            this.zzcwt = new MediaPlayer();
            this.zzcwt.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzcwt.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzcwt.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzcwt.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzcwt.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzcwt.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzcwx = 0;
            if (this.zzcxb) {
                this.zzcxa = new zzapu(this.getContext());
                this.zzcxa.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzcxa.start();
                surface = this.zzcxa.zztj();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzcxa.zzti();
                    this.zzcxa = null;
                }
            }
            this.zzcwt.setDataSource(this.getContext(), this.zzcwu);
            zzbv.zzfc();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzcwt.setSurface(surface);
            this.zzcwt.setAudioStreamType(3);
            this.zzcwt.setScreenOnWhilePlaying(true);
            this.zzcwt.prepareAsync();
            this.zzag(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzcwu);
            zzakb.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzcwt, 1, 0);
            return;
        }
    }

    private final void zzsr() {
        if (!this.zzcwq) {
            return;
        }
        if (this.zzss() && this.zzcwt.getCurrentPosition() > 0 && this.zzcws != 3) {
            zzakb.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzcwt.start();
            int n = this.zzcwt.getCurrentPosition();
            long l = zzbv.zzer().currentTimeMillis();
            while (this.zzss() && this.zzcwt.getCurrentPosition() == n && zzbv.zzer().currentTimeMillis() - l <= 250L) {
            }
            this.zzcwt.pause();
            ((zzapg)this).zzst();
        }
    }

    private final void zzag(boolean bl) {
        zzakb.v("AdMediaPlayerView release");
        if (this.zzcxa != null) {
            this.zzcxa.zzti();
            this.zzcxa = null;
        }
        if (this.zzcwt != null) {
            this.zzcwt.reset();
            this.zzcwt.release();
            this.zzcwt = null;
            this.zzag(0);
            if (bl) {
                this.zzcws = 0;
                this.zzcws = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzakb.v("AdMediaPlayerView play");
        if (this.zzss()) {
            this.zzcwt.start();
            this.zzag(3);
            this.zzcxk.zzsw();
            zzakk.zzcrm.post((Runnable)new zzapd(this));
        }
        this.zzcws = 3;
    }

    @Override
    public final void pause() {
        zzakb.v("AdMediaPlayerView pause");
        if (this.zzss() && this.zzcwt.isPlaying()) {
            this.zzcwt.pause();
            this.zzag(4);
            zzakk.zzcrm.post((Runnable)new zzape(this));
        }
        this.zzcws = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzss()) {
            return this.zzcwt.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzss()) {
            return this.zzcwt.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzakb.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzss()) {
            this.zzcwt.seekTo(n);
            this.zzcxc = 0;
            return;
        }
        this.zzcxc = n;
    }

    private final boolean zzss() {
        return this.zzcwt != null && this.zzcwr != -1 && this.zzcwr != 0 && this.zzcwr != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzcxa != null) {
            this.zzcxa.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzcwt != null) {
            return this.zzcwt.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzcwt != null) {
            return this.zzcwt.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzst() {
        this.zza(this.zzcxl.getVolume());
    }

    private final void zza(float f) {
        if (this.zzcwt != null) {
            try {
                this.zzcwt.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzakb.zzdk((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzag(int n) {
        if (n == 3) {
            this.zzcwp.zztt();
            this.zzcxl.zztt();
        } else if (this.zzcwr == 3) {
            this.zzcwp.zztu();
            this.zzcxl.zztu();
        }
        this.zzcwr = n;
    }

    final /* synthetic */ void zzah(int n) {
        if (this.zzcxd != null) {
            this.zzcxd.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzapf zza(zzaov zzaov2) {
        return zzaov2.zzcxd;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzcwo.put(-1004, "MEDIA_ERROR_IO");
            zzcwo.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzcwo.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzcwo.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzcwo.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzcwo.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzcwo.put(1, "MEDIA_ERROR_UNKNOWN");
        zzcwo.put(1, "MEDIA_INFO_UNKNOWN");
        zzcwo.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzcwo.put(701, "MEDIA_INFO_BUFFERING_START");
        zzcwo.put(702, "MEDIA_INFO_BUFFERING_END");
        zzcwo.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzcwo.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzcwo.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzcwo.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzcwo.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

