/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzaoa;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzadh
@ParametersAreNonnullByDefault
public class zzaoj<T>
implements zzanz<T> {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private T mValue;
    @GuardedBy(value="mLock")
    private Throwable zzcwf;
    @GuardedBy(value="mLock")
    private boolean zzcwg;
    @GuardedBy(value="mLock")
    private boolean zzbuf;
    private final zzaoa zzcwh = new zzaoa();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzcwh.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbuf) {
                return;
            }
            if (this.zzso()) {
                zzbv.zzeo().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzcwg = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzcwh.zzsm();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbuf) {
                return;
            }
            if (this.zzso()) {
                zzbv.zzeo().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzcwf = throwable;
            this.mLock.notifyAll();
            this.zzcwh.zzsm();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzso()) {
                this.mLock.wait();
            }
            if (this.zzcwf != null) {
                throw new ExecutionException(this.zzcwf);
            }
            if (this.zzbuf) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzso()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzcwf != null) {
                throw new ExecutionException(this.zzcwf);
            }
            if (!this.zzcwg) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzbuf) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzso()) {
                return false;
            }
            this.zzbuf = true;
            this.zzcwg = true;
            this.mLock.notifyAll();
            this.zzcwh.zzsm();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbuf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzso();
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zzso() {
        return this.zzcwf != null || this.zzcwg;
    }
}

