/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.ads.zzaf;
import com.google.android.gms.internal.ads.zzan;
import com.google.android.gms.internal.ads.zzao;
import com.google.android.gms.internal.ads.zzb;
import com.google.android.gms.internal.ads.zzc;
import com.google.android.gms.internal.ads.zzl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class zzam
implements zzb {
    private final Map<String, zzan> zzbw = new LinkedHashMap<String, zzan>(16, 0.75f, true);
    private long zzbx = 0L;
    private final File zzby;
    private final int zzbz;

    private zzam(File file, int n) {
        this.zzby = file;
        this.zzbz = 0x500000;
    }

    public zzam(File file) {
        this(file, 0x500000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized zzc zza(String string2) {
        zzan zzan2 = this.zzbw.get(string2);
        if (zzan2 == null) {
            return null;
        }
        File file = this.zze(string2);
        try (zzao zzao2 = new zzao(new BufferedInputStream(zzam.zza(file)), file.length());){
            byte[] byArray;
            zzan zzan3 = zzan.zzc(zzao2);
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)zzan3.zzcb)) {
                zzaf.d("%s: key=%s, found=%s", file.getAbsolutePath(), string2, zzan3.zzcb);
                this.removeEntry(string2);
                return null;
            }
            byte[] byArray2 = byArray = zzam.zza(zzao2, zzao2.zzo());
            zzan zzan4 = zzan2;
            zzc zzc2 = new zzc();
            new zzc().data = byArray2;
            zzc2.zza = zzan4.zza;
            zzc2.zzb = zzan4.zzb;
            zzc2.zzc = zzan4.zzc;
            zzc2.zzd = zzan4.zzd;
            zzc2.zze = zzan4.zze;
            List<zzl> list = zzan4.zzg;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (zzl zzl2 : list) {
                treeMap.put(zzl2.getName(), zzl2.getValue());
            }
            zzc2.zzf = treeMap;
            zzc2.zzg = Collections.unmodifiableList(zzan4.zzg);
            zzc zzc3 = zzc2;
            return zzc3;
        }
        catch (IOException iOException) {
            zzaf.d("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            return null;
        }
    }

    @Override
    public final synchronized void zza() {
        if (!this.zzby.exists()) {
            if (!this.zzby.mkdirs()) {
                zzaf.e("Unable to create cache dir %s", this.zzby.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzby.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            try {
                long l = file.length();
                try (zzao zzao2 = new zzao(new BufferedInputStream(zzam.zza(file)), l);){
                    zzan zzan2 = zzan.zzc(zzao2);
                    zzan.zzc(zzao2).zzca = l;
                    this.zza(zzan2.zzcb, zzan2);
                    continue;
                }
            }
            catch (IOException iOException) {
                file.delete();
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzc zzc2) {
        int n = zzc2.data.length;
        Object object = this;
        if (((zzam)object).zzbx + (long)n >= (long)((zzam)object).zzbz) {
            if (zzaf.DEBUG) {
                zzaf.v("Pruning old cache entries.", new Object[0]);
            }
            long l = ((zzam)object).zzbx;
            int n2 = 0;
            long l2 = SystemClock.elapsedRealtime();
            Iterator<Map.Entry<String, zzan>> iterator = ((zzam)object).zzbw.entrySet().iterator();
            while (iterator.hasNext()) {
                zzan zzan2 = iterator.next().getValue();
                if (super.zze(zzan2.zzcb).delete()) {
                    ((zzam)object).zzbx -= zzan2.zzca;
                } else {
                    zzaf.d("Could not delete cache entry for key=%s, filename=%s", zzan2.zzcb, zzam.zzd(zzan2.zzcb));
                }
                iterator.remove();
                ++n2;
                if (!((float)(((zzam)object).zzbx + (long)n) < (float)((zzam)object).zzbz * 0.9f)) continue;
            }
            if (zzaf.DEBUG) {
                zzaf.v("pruned %d files, %d bytes, %d ms", n2, ((zzam)object).zzbx - l, SystemClock.elapsedRealtime() - l2);
            }
        }
        File file = this.zze(string2);
        try {
            object = file;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            zzan zzan3 = new zzan(string2, zzc2);
            if (!zzan3.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzaf.d("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzc2.data);
            bufferedOutputStream.close();
            this.zza(string2, zzan3);
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzaf.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzaf.d("Could not delete cache entry for key=%s, filename=%s", string2, zzam.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzby, zzam.zzd(string2));
    }

    private final void zza(String string2, zzan zzan2) {
        if (!this.zzbw.containsKey(string2)) {
            this.zzbx += zzan2.zzca;
        } else {
            zzan zzan3 = this.zzbw.get(string2);
            this.zzbx += zzan2.zzca - zzan3.zzca;
        }
        this.zzbw.put(string2, zzan2);
    }

    private final void removeEntry(String string2) {
        zzan zzan2 = this.zzbw.remove(string2);
        if (zzan2 != null) {
            this.zzbx -= zzan2.zzca;
        }
    }

    private static byte[] zza(zzao zzao2, long l) throws IOException {
        long l2 = zzao2.zzo();
        if (l < 0L || l > l2 || (long)((int)l) != l) {
            throw new IOException(new StringBuilder(73).append("streamToBytes length=").append(l).append(", maxLength=").append(l2).toString());
        }
        byte[] byArray = new byte[(int)l];
        new DataInputStream(zzao2).readFully(byArray);
        return byArray;
    }

    private static InputStream zza(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzam.zza(inputStream) | zzam.zza(inputStream) << 8 | zzam.zza(inputStream) << 16 | zzam.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzam.zza(inputStream) & 0xFFL | ((long)zzam.zza(inputStream) & 0xFFL) << 8 | ((long)zzam.zza(inputStream) & 0xFFL) << 16 | ((long)zzam.zza(inputStream) & 0xFFL) << 24 | ((long)zzam.zza(inputStream) & 0xFFL) << 32 | ((long)zzam.zza(inputStream) & 0xFFL) << 40 | ((long)zzam.zza(inputStream) & 0xFFL) << 48 | ((long)zzam.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzam.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zza(zzao zzao2) throws IOException {
        long l = zzam.zzc(zzao2);
        byte[] byArray = zzam.zza(zzao2, l);
        return new String(byArray, "UTF-8");
    }

    static List<zzl> zzb(zzao zzao2) throws IOException {
        int n = zzam.zzb((InputStream)zzao2);
        ArrayList<zzl> arrayList = n == 0 ? Collections.emptyList() : new ArrayList<zzl>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzam.zza(zzao2).intern();
            String string3 = zzam.zza(zzao2).intern();
            arrayList.add(new zzl(string2, string3));
        }
        return arrayList;
    }
}

