/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzalt;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
public final class zzalk {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private String zzcsm = "";
    @GuardedBy(value="mLock")
    private String zzcsn = "";
    @GuardedBy(value="mLock")
    private boolean zzcso = false;
    @VisibleForTesting
    private String zzcsp = "";

    public final void zzg(Context context, String string2, String string3) {
        if (!this.zzh(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzcsp)) {
            zzakb.zzck((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
            return;
        }
        if ("1".equals(this.zzcsp)) {
            zzakb.zzck((String)"The app is not linked for creative preview.");
            this.zzk(context, string2, string3);
            return;
        }
        if ("0".equals(this.zzcsp)) {
            zzakb.zzck((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public final void zza(Context context, String string2, String string3, @Nullable String string4) {
        boolean bl = this.zzrx();
        if (this.zzi(context, string2, string3)) {
            if (!bl && !TextUtils.isEmpty((CharSequence)string4)) {
                this.zzb(context, string3, string4, string2);
            }
            zzakb.zzck((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzk(context, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzh(Context context, String string2, String string3) {
        String string4;
        Object object = zznk.zzbeg;
        String string5 = zzalk.zzj(context, this.zzc(context, (String)zzkb.zzik().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzakb.zzck((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzcsp = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        String string6 = string4;
        object = this;
        Object object2 = object.mLock;
        synchronized (object2) {
            object.zzcsn = string6;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzi(Context context, String string2, String string3) {
        String string4;
        Object object = zznk.zzbeh;
        String string5 = zzalk.zzj(context, this.zzc(context, (String)zzkb.zzik().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzakb.zzck((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            string4 = new JSONObject(string5).optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        object = this;
        Object object2 = object.mLock;
        synchronized (object2) {
            object.zzcso = bl;
        }
        return bl;
    }

    @VisibleForTesting
    private static String zzj(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzbv.zzek().zzm(context, string3));
        zzanz<String> zzanz2 = new zzalt(context).zzc(string2, hashMap);
        try {
            zzna zzna2 = zznk.zzbej;
            return (String)zzanz2.get(((Integer)zzkb.zzik().zzd(zzna2)).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzakb.zzb((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzanz2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzakb.zzb((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzanz2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzakb.zzb((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private final void zzk(Context context, String string2, String string3) {
        zzbv.zzek();
        zzna zzna2 = zznk.zzbef;
        zzakk.zza(context, this.zzc(context, (String)zzkb.zzik().zzd(zzna2), string2, string3));
    }

    public final void zzb(Context context, String string2, String string3, String string4) {
        zzna zzna2 = zznk.zzbei;
        Uri.Builder builder = this.zzc(context, (String)zzkb.zzik().zzd(zzna2), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzbv.zzek();
        zzakk.zzd(context, string2, builder.build().toString());
    }

    private final Uri zzc(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzaz(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzaz(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzcsm)) {
                zzbv.zzek();
                this.zzcsm = zzakk.zzn(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzcsm)) {
                    zzbv.zzek();
                    this.zzcsm = zzakk.zzrh();
                    zzbv.zzek();
                    zzakk.zze(context, "debug_signals_id.txt", this.zzcsm);
                }
            }
            return this.zzcsm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzrw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcsn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzrx() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcso;
        }
    }

    @VisibleForTesting
    private final void zza(Context context, String string2, boolean bl, boolean bl2) {
        if (!(context instanceof Activity)) {
            zzakb.zzdj((String)"Can not create dialog without Activity Context");
            return;
        }
        zzakk.zzcrm.post((Runnable)new zzall(this, context, string2, bl, bl2));
    }
}

