/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakc;
import com.google.android.gms.internal.ads.zzaki;
import com.google.android.gms.internal.ads.zzakl;
import com.google.android.gms.internal.ads.zzakm;
import com.google.android.gms.internal.ads.zzakn;
import com.google.android.gms.internal.ads.zzako;
import com.google.android.gms.internal.ads.zzakp;
import com.google.android.gms.internal.ads.zzalt;
import com.google.android.gms.internal.ads.zzami;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzamx;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzge;
import com.google.android.gms.internal.ads.zzgk;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzmw;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzoh;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
public final class zzakk {
    public static final Handler zzcrm = new zzakc(Looper.getMainLooper());
    private final Object mLock = new Object();
    private boolean zzcrn = true;
    @GuardedBy(value="mLock")
    private String zzcpq;
    private boolean zzcro = false;
    private boolean zzcrp = false;
    @GuardedBy(value="this")
    private Pattern zzcrq;
    @GuardedBy(value="this")
    private Pattern zzcrr;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzakk zzakk2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzakk2.zzm(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzaj(Context context) {
        ResolveInfo resolveInfo;
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        try {
            resolveInfo = packageManager.resolveActivity(intent, 65536);
        }
        catch (Exception exception) {
            zzakb.zzc((String)"Could not verify that com.google.android.gms.ads.AdActivity is declared in AndroidManifest.xml", (Throwable)exception);
            zzbv.zzeo().zza(exception, "AdUtil.hasAdActivity");
            return false;
        }
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzakb.zzdk((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzakb.zzdk((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzakb.zzdk((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzakb.zzdk((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzakb.zzdk((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzakb.zzdk((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzakb.zzdk((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzakb.zzdk((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzl(Context context, String string2) {
        String string3 = string2;
        String string4 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string3, string4) == 0;
    }

    public static void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzami(context, string2, string3).zznt();
        }
    }

    public static void zzd(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        zzakk.zza(context, string2, arrayList);
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzbfw.zzbn((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzakb.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzoh.zzh(context)) {
            zzakb.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zzoh zzoh2 = new zzoh();
        zzakl zzakl2 = new zzakl(this, list, zzoh2, context);
        zzoh2.zza(zzakl2);
        zzoh2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzak(Context context) {
        if (this.zzcro) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzakp(this, null), intentFilter);
        this.zzcro = true;
        return true;
    }

    public final boolean zzal(Context context) {
        if (this.zzcrp) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzako(this, null), intentFilter);
        this.zzcrp = true;
        return true;
    }

    public final void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzm(context, string2));
    }

    private static String zzrg() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzm(Context context, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcpq != null) {
                return this.zzcpq;
            }
            if (string2 == null) {
                return zzakk.zzrg();
            }
            try {
                this.zzcpq = zzbv.zzem().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzcpq)) {
                zzkb.zzif();
                if (!zzamu.zzsh()) {
                    this.zzcpq = null;
                    zzcrm.post((Runnable)new zzakm(this, context));
                    while (this.zzcpq == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzcpq = zzakk.zzrg();
                            String string3 = String.valueOf(this.zzcpq);
                            zzakb.zzdk((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzcpq = zzakk.zzam(context);
                }
            }
            String string4 = String.valueOf(this.zzcpq);
            this.zzcpq = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (Wrappers.packageManager((Context)context).isCallerInstantApp()) {
                    this.zzcpq = String.valueOf(this.zzcpq).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbv.zzeo().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzcpq = String.valueOf(this.zzcpq).concat(")");
            return this.zzcpq;
        }
    }

    @VisibleForTesting
    protected static String zzam(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzakk.zzrg();
        }
    }

    public static boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String zzcu(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzn(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zzf(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzakb.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zzf(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzf((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzn(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzakk zzakk2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzakk2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzf((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzn(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static Map<String, String> zzg(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : zzbv.zzem().zzh(uri)) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public static String zzrh() {
        return UUID.randomUUID().toString();
    }

    public static int zzcv(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzakb.zzdk((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzri() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzrj() {
        return new int[]{0, 0};
    }

    public static int[] zzf(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzakk.zzrj();
    }

    public final int[] zzg(Activity activity) {
        int[] nArray = zzakk.zzf(activity);
        int[] nArray2 = new int[2];
        zzkb.zzif();
        nArray2[0] = zzamu.zzb((Context)activity, (int)nArray[0]);
        zzkb.zzif();
        nArray2[1] = zzamu.zzb((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzh(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzakk.zzrj();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzkb.zzif();
        nArray4[0] = zzamu.zzb((Context)activity, (int)nArray3[0]);
        zzkb.zzif();
        nArray4[1] = zzamu.zzb((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzcw(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzan(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzmw zzao(Context context) {
        return new zzmw(context);
    }

    public static Bitmap zzs(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzap(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zzjn zzjn2) {
        zzna zzna2 = zznk.zzaxi;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzjn2.width);
            jSONObject2.put("height", zzjn2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzakk.zzap(context));
            if (!zzjn2.zzarc) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static boolean zzaq(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            zzbv.zzek();
            bundle.putString("device", zzakk.zzri());
            bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zznk.zzjb()));
        }
        zzkb.zzif();
        zzamu.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)bl, (zzamx)new zzakn(this, context, string2));
    }

    public final void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        zzna zzna2 = zznk.zzazx;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public static void zzd(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzaki.zzb(runnable);
    }

    public static Bitmap zzt(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzakk.zzv(view);
        if (bitmap == null) {
            bitmap = zzakk.zzu(view);
        }
        return bitmap;
    }

    private static Bitmap zzu(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzakb.zzdk((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzakb.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzv(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzakb.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzar(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            zzna zzna2 = zznk.zzbbh;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    bitmap = zzakk.zzv(window.getDecorView().getRootView());
                }
            } else {
                bitmap = zzakk.zzu(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzakb.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static int zzas(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzakk.zzat(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzat(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean zza(View var1_1, PowerManager var2_2, KeyguardManager var3_3) {
        if (zzbv.zzek().zzcrn || !((var5_4 = var3_3) == null ? false : var5_4.inKeyguardRestrictedInputMode())) ** GOTO lbl-1000
        var5_4 = zznk.zzazu;
        if (((Boolean)zzkb.zzik().zzd((zzna)var5_4)).booleanValue() && zzakk.zzw(var1_1)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var4_5 = false;
        }
        if (var1_1.getVisibility() == 0 && var1_1.isShown() && ((var5_4 = var2_2) == null || var5_4.isScreenOn() != false) && var4_5) {
            var5_4 = zznk.zzazs;
            if (!((Boolean)zzkb.zzik().zzd((zzna)var5_4)).booleanValue() || var1_1.getLocalVisibleRect(new Rect()) || var1_1.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzw(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzau(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        KeyguardManager keyguardManager = zzakk.zzat(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzx(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzav(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzakb.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbv.zzeo().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzrk() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            zzna zzna2 = zznk.zzavm;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            zzna2 = zznk.zzavn;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
            bundle.putInt("web_view_count", zzbv.zzeo().zzqg());
        }
        catch (Exception exception) {
            zzakb.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzna zzna2 = zznk.zzbdy;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                zzakk.zzb(context, intent);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzakb.zzck((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzakb.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zze(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzn(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(IOUtils.readInputStreamFully((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzakb.zzck((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zzkb.zzif();
        int n = zzamu.zza((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzamu.zza((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzakk.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zzna zzna2 = zznk.zzbek;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * (Integer)zzkb.zzik().zzd(zzna2);
        return zzakk.zzb(n3, n + n5, n7) && zzakk.zzb(n4, n2, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcx(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzakk zzakk2 = this;
            synchronized (zzakk2) {
                block10: {
                    zzna zzna2;
                    block9: {
                        if (this.zzcrq == null) break block9;
                        zzna2 = zznk.zzaxo;
                        if (((String)zzkb.zzik().zzd(zzna2)).equals(this.zzcrq.pattern())) break block10;
                    }
                    zzna2 = zznk.zzaxo;
                    this.zzcrq = Pattern.compile((String)zzkb.zzik().zzd(zzna2));
                }
                return this.zzcrq.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcy(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzakk zzakk2 = this;
            synchronized (zzakk2) {
                block10: {
                    zzna zzna2;
                    block9: {
                        if (this.zzcrr == null) break block9;
                        zzna2 = zznk.zzaxp;
                        if (((String)zzkb.zzik().zzd(zzna2)).equals(this.zzcrr.pattern())) break block10;
                    }
                    zzna2 = zznk.zzaxp;
                    this.zzcrr = Pattern.compile((String)zzkb.zzik().zzd(zzna2));
                }
                return this.zzcrr.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @VisibleForTesting
    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    @VisibleForTesting
    public static Bundle zza(zzgk zzgk2) {
        String string2;
        String string3;
        if (zzgk2 == null) {
            return null;
        }
        zzna zzna2 = zznk.zzawq;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            zzna2 = zznk.zzaws;
            if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                return null;
            }
        }
        if (zzbv.zzeo().zzqh().zzqu() && zzbv.zzeo().zzqh().zzqw()) {
            return null;
        }
        if (zzgk2.zzha()) {
            zzgk2.wakeup();
        }
        zzge zzge2 = zzgk2.zzgy();
        String string4 = null;
        if (zzge2 != null) {
            string3 = zzge2.getSignature();
            string4 = zzge2.zzgo();
            string2 = zzge2.zzgp();
            if (string3 != null) {
                zzbv.zzeo().zzqh().zzcn(string3);
            }
            if (string2 != null) {
                zzbv.zzeo().zzqh().zzco(string2);
            }
        } else {
            string3 = zzbv.zzeo().zzqh().zzqv();
            string2 = zzbv.zzeo().zzqh().zzqx();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null) {
            zzna2 = zznk.zzaws;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && !zzbv.zzeo().zzqh().zzqw()) {
                bundle.putString("v_fp_vertical", string2);
            }
        }
        if (string3 != null) {
            zzna2 = zznk.zzawq;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && !zzbv.zzeo().zzqh().zzqu()) {
                bundle.putString("fingerprint", string3);
                if (!string3.equals(string4)) {
                    bundle.putString("v_fp", string4);
                }
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    @Nullable
    public static WebResourceResponse zzf(Context context, String string2, String string3) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("User-Agent", zzbv.zzek().zzm(context, string2));
            hashMap.put("Cache-Control", "max-stale=3600");
            String string4 = (String)new zzalt(context).zzc(string3, hashMap).get(60L, TimeUnit.SECONDS);
            if (string4 != null) {
                return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(string4.getBytes("UTF-8")));
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzakb.zzc((String)"Could not fetch MRAID JS.", (Throwable)exception);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WebResourceResponse zzb(HttpURLConnection httpURLConnection) throws IOException {
        String string2;
        String string3;
        Object object2;
        block4: {
            Object object;
            zzbv.zzek();
            object2 = httpURLConnection.getContentType();
            string3 = TextUtils.isEmpty((CharSequence)object2) ? "" : ((String)object2).split(";")[0].trim();
            zzbv.zzek();
            object2 = httpURLConnection.getContentType();
            if (!TextUtils.isEmpty((CharSequence)object2) && ((String[])(object = ((String)object2).split(";"))).length != 1) {
                void entry;
                boolean i = true;
                while (entry < ((String[])object).length) {
                    String[] stringArray;
                    if (object[entry].trim().startsWith("charset") && (stringArray = ((String)object[entry]).trim().split("=")).length > 1) {
                        string2 = stringArray[1].trim();
                        break block4;
                    }
                    ++entry;
                }
            }
            string2 = "";
        }
        String string4 = string2;
        object2 = httpURLConnection.getHeaderFields();
        HashMap<String, String> hashMap = new HashMap<String, String>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            hashMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        HashMap<String, String> hashMap2 = hashMap;
        return zzbv.zzem().zza(string3, string4, httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage(), hashMap2, httpURLConnection.getInputStream());
    }

    public static void zza(Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        boolean bl = false;
        try {
            zzna zzna2 = zznk.zzaui;
            bl = (Boolean)zzkb.zzik().zzd(zzna2);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bl) {
            Throwable throwable2 = throwable;
            CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable2);
        }
    }

    static /* synthetic */ boolean zza(zzakk zzakk2, boolean bl) {
        zzakk2.zzcrn = bl;
        return zzakk2.zzcrn;
    }

    static /* synthetic */ Object zza(zzakk zzakk2) {
        return zzakk2.mLock;
    }

    static /* synthetic */ String zza(zzakk zzakk2, String string2) {
        zzakk2.zzcpq = string2;
        return zzakk2.zzcpq;
    }
}

