/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.security.NetworkSecurityPolicy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzajl;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzake;
import com.google.android.gms.internal.ads.zzakf;
import com.google.android.gms.internal.ads.zzakh;
import com.google.android.gms.internal.ads.zzanz;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
public final class zzakd {
    private final Object mLock = new Object();
    private zzanz<?> zzcqu;
    private CopyOnWriteArraySet<zzakh> zzcqv = new CopyOnWriteArraySet();
    @Nullable
    @GuardedBy(value="mLock")
    private SharedPreferences zzatw;
    @Nullable
    @GuardedBy(value="mLock")
    SharedPreferences.Editor zzcqw;
    @GuardedBy(value="mLock")
    private boolean zzcqx = false;
    @GuardedBy(value="mLock")
    private boolean zzcik = true;
    @Nullable
    @GuardedBy(value="mLock")
    private String zzcqy;
    @Nullable
    @GuardedBy(value="mLock")
    private String zzcqz;
    @GuardedBy(value="mLock")
    private boolean zzcit = false;
    @GuardedBy(value="mLock")
    private String zzcpj = "";
    @GuardedBy(value="mLock")
    private long zzcra = 0L;
    @GuardedBy(value="mLock")
    private long zzcrb = 0L;
    @GuardedBy(value="mLock")
    private long zzcrc = 0L;
    @GuardedBy(value="mLock")
    private int zzcqg = -1;
    @GuardedBy(value="mLock")
    private int zzcrd = 0;
    @GuardedBy(value="mLock")
    private Set<String> zzcre = Collections.emptySet();
    @GuardedBy(value="mLock")
    private JSONObject zzcrf = new JSONObject();
    @GuardedBy(value="mLock")
    private boolean zzcil = true;
    @GuardedBy(value="mLock")
    private boolean zzcim = true;

    @TargetApi(value=23)
    private static boolean zzqq() {
        return PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
    }

    public final void initialize(Context context) {
        Context context2 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        this.zzcqu = (zzanz)new zzake(this, context2).zznt();
    }

    private final void zzqr() {
        if (this.zzcqu == null) {
            return;
        }
        if (this.zzcqu.isDone()) {
            return;
        }
        try {
            this.zzcqu.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzakb.zzc((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzakb.zzb((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzqs() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.mLock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzcik);
            bundle.putBoolean("content_url_opted_out", this.zzcil);
            bundle.putBoolean("content_vertical_opted_out", this.zzcim);
            bundle.putBoolean("auto_collect_location", this.zzcit);
            bundle.putInt("version_code", this.zzcrd);
            bundle.putStringArray("never_pool_slots", this.zzcre.toArray(new String[this.zzcre.size()]));
            bundle.putString("app_settings_json", this.zzcpj);
            bundle.putLong("app_settings_last_update_ms", this.zzcra);
            bundle.putLong("app_last_background_time_ms", this.zzcrb);
            bundle.putInt("request_in_session_count", this.zzcqg);
            bundle.putLong("first_ad_req_time_ms", this.zzcrc);
            bundle.putString("native_advanced_settings", this.zzcrf.toString());
            if (this.zzcqy != null) {
                bundle.putString("content_url_hashes", this.zzcqy);
            }
            if (this.zzcqz != null) {
                bundle.putString("content_vertical_hashes", this.zzcqz);
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzakh zzakh2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcqu != null && this.zzcqu.isDone()) {
                zzakh2.zzd(this.zzqs());
            }
            this.zzcqv.add(zzakh2);
            return;
        }
    }

    private final void zze(Bundle bundle) {
        new zzakf(this, bundle).zznt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzab(boolean bl) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcik == bl) {
                return;
            }
            this.zzcik = bl;
            if (this.zzcqw != null) {
                this.zzcqw.putBoolean("use_https", bl);
                this.zzcqw.apply();
            }
            if (!this.zzcqx) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("use_https", bl);
                this.zze(bundle);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqt() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcik || this.zzcqx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzac(boolean bl) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcil == bl) {
                return;
            }
            this.zzcil = bl;
            if (this.zzcqw != null) {
                this.zzcqw.putBoolean("content_url_opted_out", bl);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzcil);
            bundle.putBoolean("content_vertical_opted_out", this.zzcim);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqu() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcn(@Nullable String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzcqy)) {
                return;
            }
            this.zzcqy = string2;
            if (this.zzcqw != null) {
                this.zzcqw.putString("content_url_hashes", string2);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzqv() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcqy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzad(boolean bl) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcim == bl) {
                return;
            }
            this.zzcim = bl;
            if (this.zzcqw != null) {
                this.zzcqw.putBoolean("content_vertical_opted_out", bl);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzcil);
            bundle.putBoolean("content_vertical_opted_out", this.zzcim);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqw() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzco(@Nullable String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzcqz)) {
                return;
            }
            this.zzcqz = string2;
            if (this.zzcqw != null) {
                this.zzcqw.putString("content_vertical_hashes", string2);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzqx() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcqz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzae(boolean bl) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcit == bl) {
                return;
            }
            this.zzcit = bl;
            if (this.zzcqw != null) {
                this.zzcqw.putBoolean("auto_collect_location", bl);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqy() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzae(int n) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcrd == n) {
                return;
            }
            this.zzcrd = n;
            if (this.zzcqw != null) {
                this.zzcqw.putInt("version_code", n);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzqz() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcrd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcp(String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcre.contains(string2)) {
                return;
            }
            this.zzcre.add(string2);
            if (this.zzcqw != null) {
                this.zzcqw.putStringSet("never_pool_slots", this.zzcre);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzcre.toArray(new String[this.zzcre.size()]));
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcq(String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzcre.contains(string2)) {
                return;
            }
            this.zzcre.remove(string2);
            if (this.zzcqw != null) {
                this.zzcqw.putStringSet("never_pool_slots", this.zzcre);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzcre.toArray(new String[this.zzcre.size()]));
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcr(String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcre.contains(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcs(String string2) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            long l;
            this.zzcra = l = zzbv.zzer().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzcpj)) {
                return;
            }
            this.zzcpj = string2;
            if (this.zzcqw != null) {
                this.zzcqw.putString("app_settings_json", string2);
                this.zzcqw.putLong("app_settings_last_update_ms", l);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzajl zzra() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return new zzajl(this.zzcpj, this.zzcra);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzj(long l) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcrb == l) {
                return;
            }
            this.zzcrb = l;
            if (this.zzcqw != null) {
                this.zzcqw.putLong("app_last_background_time_ms", l);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzrb() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcrb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzaf(int n) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcqg == n) {
                return;
            }
            this.zzcqg = n;
            if (this.zzcqw != null) {
                this.zzcqw.putInt("request_in_session_count", n);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzrc() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcqg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(long l) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcrc == l) {
                return;
            }
            this.zzcrc = l;
            if (this.zzcqw != null) {
                this.zzcqw.putLong("first_ad_req_time_ms", l);
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zze(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzrd() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, String string3, boolean bl) {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzcrf.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false) == bl) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzbv.zzer().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzcrf.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzakb.zzc((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzcqw != null) {
                this.zzcqw.putString("native_advanced_settings", this.zzcrf.toString());
                this.zzcqw.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzcrf.toString());
            this.zze((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONObject zzre() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcrf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzrf() {
        this.zzqr();
        Object object = this.mLock;
        synchronized (object) {
            this.zzcrf = new JSONObject();
            if (this.zzcqw != null) {
                this.zzcqw.remove("native_advanced_settings");
                this.zzcqw.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zze(bundle);
            return;
        }
    }

    static /* synthetic */ Object zza(zzakd zzakd2) {
        return zzakd2.mLock;
    }

    static /* synthetic */ SharedPreferences zza(zzakd zzakd2, SharedPreferences sharedPreferences) {
        zzakd2.zzatw = sharedPreferences;
        return zzakd2.zzatw;
    }

    static /* synthetic */ boolean zza(zzakd zzakd2, boolean bl) {
        zzakd2.zzcqx = bl;
        return zzakd2.zzcqx;
    }

    static /* synthetic */ boolean zzb(zzakd zzakd2) {
        return zzakd.zzqq();
    }

    static /* synthetic */ boolean zzb(zzakd zzakd2, boolean bl) {
        zzakd2.zzcik = bl;
        return zzakd2.zzcik;
    }

    static /* synthetic */ boolean zzc(zzakd zzakd2) {
        return zzakd2.zzcik;
    }

    static /* synthetic */ SharedPreferences zzd(zzakd zzakd2) {
        return zzakd2.zzatw;
    }

    static /* synthetic */ boolean zzc(zzakd zzakd2, boolean bl) {
        zzakd2.zzcil = bl;
        return zzakd2.zzcil;
    }

    static /* synthetic */ boolean zze(zzakd zzakd2) {
        return zzakd2.zzcil;
    }

    static /* synthetic */ String zza(zzakd zzakd2, String string2) {
        zzakd2.zzcqy = string2;
        return zzakd2.zzcqy;
    }

    static /* synthetic */ String zzf(zzakd zzakd2) {
        return zzakd2.zzcqy;
    }

    static /* synthetic */ boolean zzd(zzakd zzakd2, boolean bl) {
        zzakd2.zzcit = bl;
        return zzakd2.zzcit;
    }

    static /* synthetic */ boolean zzg(zzakd zzakd2) {
        return zzakd2.zzcit;
    }

    static /* synthetic */ boolean zze(zzakd zzakd2, boolean bl) {
        zzakd2.zzcim = bl;
        return zzakd2.zzcim;
    }

    static /* synthetic */ boolean zzh(zzakd zzakd2) {
        return zzakd2.zzcim;
    }

    static /* synthetic */ String zzb(zzakd zzakd2, String string2) {
        zzakd2.zzcqz = string2;
        return zzakd2.zzcqz;
    }

    static /* synthetic */ String zzi(zzakd zzakd2) {
        return zzakd2.zzcqz;
    }

    static /* synthetic */ int zza(zzakd zzakd2, int n) {
        zzakd2.zzcrd = n;
        return zzakd2.zzcrd;
    }

    static /* synthetic */ int zzj(zzakd zzakd2) {
        return zzakd2.zzcrd;
    }

    static /* synthetic */ String zzc(zzakd zzakd2, String string2) {
        zzakd2.zzcpj = string2;
        return zzakd2.zzcpj;
    }

    static /* synthetic */ String zzk(zzakd zzakd2) {
        return zzakd2.zzcpj;
    }

    static /* synthetic */ long zza(zzakd zzakd2, long l) {
        zzakd2.zzcra = l;
        return zzakd2.zzcra;
    }

    static /* synthetic */ long zzl(zzakd zzakd2) {
        return zzakd2.zzcra;
    }

    static /* synthetic */ long zzb(zzakd zzakd2, long l) {
        zzakd2.zzcrb = l;
        return zzakd2.zzcrb;
    }

    static /* synthetic */ long zzm(zzakd zzakd2) {
        return zzakd2.zzcrb;
    }

    static /* synthetic */ int zzb(zzakd zzakd2, int n) {
        zzakd2.zzcqg = n;
        return zzakd2.zzcqg;
    }

    static /* synthetic */ int zzn(zzakd zzakd2) {
        return zzakd2.zzcqg;
    }

    static /* synthetic */ long zzc(zzakd zzakd2, long l) {
        zzakd2.zzcrc = l;
        return zzakd2.zzcrc;
    }

    static /* synthetic */ long zzo(zzakd zzakd2) {
        return zzakd2.zzcrc;
    }

    static /* synthetic */ Set zza(zzakd zzakd2, Set set) {
        zzakd2.zzcre = set;
        return zzakd2.zzcre;
    }

    static /* synthetic */ Set zzp(zzakd zzakd2) {
        return zzakd2.zzcre;
    }

    static /* synthetic */ JSONObject zza(zzakd zzakd2, JSONObject jSONObject) {
        zzakd2.zzcrf = jSONObject;
        return zzakd2.zzcrf;
    }

    static /* synthetic */ Bundle zzq(zzakd zzakd2) {
        return zzakd2.zzqs();
    }

    static /* synthetic */ void zza(zzakd zzakd2, Bundle bundle) {
        zzakd2.zze(bundle);
    }

    static /* synthetic */ CopyOnWriteArraySet zzr(zzakd zzakd2) {
        return zzakd2.zzcqv;
    }
}

