/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.GuardedBy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.ads.zzadb;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzajn;
import com.google.android.gms.internal.ads.zzajo;
import com.google.android.gms.internal.ads.zzajp;
import com.google.android.gms.internal.ads.zzajt;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakd;
import com.google.android.gms.internal.ads.zzakh;
import com.google.android.gms.internal.ads.zzaki;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzanm;
import com.google.android.gms.internal.ads.zzano;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzes;
import com.google.android.gms.internal.ads.zzgf;
import com.google.android.gms.internal.ads.zzgk;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznn;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzajm
implements zzakh {
    private final Object mLock = new Object();
    private zzes zzvy;
    private final zzajt zzcpl = new zzajt();
    private final zzakd zzcpm = new zzakd();
    private boolean zzzv = false;
    private Context mContext;
    private zzang zzyf;
    @Nullable
    private zznn zzcpn = null;
    @Nullable
    private zzgk zzcpo = null;
    @Nullable
    private zzgf zzahz = null;
    @Nullable
    private Boolean zzcpp = null;
    private String zzcpq;
    private final AtomicInteger zzcpr = new AtomicInteger(0);
    private final zzajp zzcps = new zzajp(null);
    private final Object zzcpt = new Object();
    @GuardedBy(value="mGrantedPermissionLock")
    private zzanz<ArrayList<String>> zzcpu;

    @Nullable
    public final zzgk zzaf(@Nullable Context context) {
        return this.zza(context, this.zzcpm.zzqu(), this.zzcpm.zzqw());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzgk zza(@Nullable Context context, boolean bl, boolean bl2) {
        zzna zzna2 = zznk.zzawk;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return null;
        }
        if (!PlatformVersion.isAtLeastIceCreamSandwich()) {
            return null;
        }
        zzna2 = zznk.zzaws;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            zzna2 = zznk.zzawq;
            if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                return null;
            }
        }
        if (bl && bl2) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (Looper.getMainLooper() == null || context == null) {
                return null;
            }
            if (this.zzahz == null) {
                this.zzahz = new zzgf();
            }
            if (this.zzcpo == null) {
                this.zzcpo = new zzgk(this.zzahz, zzadb.zzc((Context)context, (zzang)this.zzyf));
            }
            this.zzcpo.zzgw();
            zzakb.zzdj((String)"start fetching content...");
            return this.zzcpo;
        }
    }

    public final zzajt zzpx() {
        return this.zzcpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final zznn zzpy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcpn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcpp = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Boolean zzpz() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcpp;
        }
    }

    public final void zzaa(boolean bl) {
        this.zzcps.zzaa(bl);
    }

    public final boolean zzqa() {
        return this.zzcps.zzqa();
    }

    public final boolean zzqb() {
        return this.zzcps.zzqb();
    }

    public final void zzqc() {
        this.zzcps.zzqc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=23)
    public final void zzd(Context context, zzang zzang2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzzv) {
                zznn zznn2;
                this.mContext = context.getApplicationContext();
                this.zzyf = zzang2;
                zzbv.zzen().zza(zzbv.zzep());
                this.zzcpm.initialize(this.mContext);
                this.zzcpm.zza(this);
                zzajm zzajm2 = this;
                zzadb.zzc((Context)zzajm2.mContext, (zzang)zzajm2.zzyf);
                this.zzcpq = zzbv.zzek().zzm(context, zzang2.zzcw);
                this.zzvy = new zzes(context.getApplicationContext(), this.zzyf);
                zzajm2 = this;
                zzbv.zzet();
                zzna zzna2 = zznk.zzawh;
                if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                    zzakb.v("CsiReporterFactory: CSI is not enabled. No CSI reporter created.");
                    zznn2 = null;
                } else {
                    zznn2 = new zznn();
                }
                this.zzcpn = zznn2;
                zzanm.zza((zzanz)new zzajo(zzajm2).zznt(), "AppState.registerCsiReporter");
                this.zzzv = true;
                this.zzqi();
            }
            return;
        }
    }

    public final zzes zzqd() {
        return this.zzvy;
    }

    @Nullable
    public final Resources getResources() {
        if (this.zzyf.zzcvg) {
            return this.mContext.getResources();
        }
        try {
            DynamiteModule dynamiteModule = DynamiteModule.load((Context)this.mContext, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.ads.dynamite");
            if (dynamiteModule != null) {
                return dynamiteModule.getModuleContext().getResources();
            }
        }
        catch (DynamiteModule.LoadingException loadingException) {
            zzakb.zzc((String)"Cannot load resource from dynamite apk or local jar", (Throwable)loadingException);
            return null;
        }
        return null;
    }

    public final void zza(Throwable throwable, String string2) {
        zzadb.zzc((Context)this.mContext, (zzang)this.zzyf).zza(throwable, string2);
    }

    public final void zzb(Throwable throwable, String string2) {
        zzna zzna2 = zznk.zzaul;
        zzadb.zzc((Context)this.mContext, (zzang)this.zzyf).zza(throwable, string2, ((Float)zzkb.zzik().zzd(zzna2)).floatValue());
    }

    @Override
    public final void zzd(Bundle bundle) {
        if (bundle.containsKey("content_url_opted_out") && bundle.containsKey("content_vertical_opted_out")) {
            this.zza(this.mContext, bundle.getBoolean("content_url_opted_out"), bundle.getBoolean("content_vertical_opted_out"));
        }
    }

    public final void zzqe() {
        this.zzcpr.incrementAndGet();
    }

    public final void zzqf() {
        this.zzcpr.decrementAndGet();
    }

    public final int zzqg() {
        return this.zzcpr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzakd zzqh() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcpm;
        }
    }

    @Nullable
    public final Context getApplicationContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzanz<ArrayList<String>> zzqi() {
        block8: {
            block7: {
                if (this.mContext == null || !PlatformVersion.isAtLeastJellyBean()) break block7;
                zzna zzna2 = zznk.zzbau;
                if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) break block8;
            }
            return zzano.zzi(new ArrayList());
        }
        Object object = this.zzcpt;
        synchronized (object) {
            if (this.zzcpu != null) {
                return this.zzcpu;
            }
            this.zzcpu = zzaki.zza(new zzajn(this));
            return this.zzcpu;
        }
    }

    @TargetApi(value=16)
    private static ArrayList<String> zzag(Context context) {
        PackageInfo packageInfo;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(context.getApplicationInfo().packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return arrayList;
        }
        if (packageInfo.requestedPermissions == null || packageInfo.requestedPermissionsFlags == null) {
            return arrayList;
        }
        for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
            if ((packageInfo.requestedPermissionsFlags[i] & 2) == 0) continue;
            arrayList.add(packageInfo.requestedPermissions[i]);
        }
        return arrayList;
    }

    final /* synthetic */ ArrayList zzqj() throws Exception {
        return zzajm.zzag(this.mContext);
    }

    static /* synthetic */ Context zza(zzajm zzajm2) {
        return zzajm2.mContext;
    }

    static /* synthetic */ zzang zzb(zzajm zzajm2) {
        return zzajm2.zzyf;
    }

    static /* synthetic */ Object zzc(zzajm zzajm2) {
        return zzajm2.mLock;
    }

    static /* synthetic */ zznn zzd(zzajm zzajm2) {
        return zzajm2.zzcpn;
    }
}

