/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzaiz;
import com.google.android.gms.internal.ads.zzaja;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

@zzadh
public final class zzaiy {
    private final AtomicReference<ThreadPoolExecutor> zzcnp = new AtomicReference<Object>(null);
    private final Object zzcnq = new Object();
    @GuardedBy(value="mGmpAppIdLock")
    @Nullable
    private String zzcnr = null;
    @VisibleForTesting
    private final AtomicBoolean zzcns = new AtomicBoolean(false);
    @VisibleForTesting
    private final AtomicInteger zzcnt = new AtomicInteger(-1);
    private final AtomicReference<Object> zzcnu = new AtomicReference<Object>(null);
    private final AtomicReference<Object> zzcnv = new AtomicReference<Object>(null);
    private ConcurrentMap<String, Method> zzcnw = new ConcurrentHashMap<String, Method>(9);

    /*
     * Unable to fully structure code
     */
    public final boolean zzs(Context var1_1) {
        block3: {
            var2_2 = zznk.zzaxj;
            if (!((Boolean)zzkb.zzik().zzd(var2_2)).booleanValue() || this.zzcns.get()) {
                return false;
            }
            if (this.zzcnt.get() != -1) break block3;
            zzkb.zzif();
            if (zzamu.zzbe((Context)var1_1)) ** GOTO lbl-1000
            zzkb.zzif();
            if (zzamu.zzbh((Context)var1_1)) {
                zzakb.zzdk((String)"Google Play Service is out of date, the Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires updated Google Play Service.");
                this.zzcnt.set(0);
            } else lbl-1000:
            // 2 sources

            {
                this.zzcnt.set(1);
            }
        }
        return this.zzcnt.get() == 1;
    }

    public final boolean zzt(Context context) {
        zzna zzna2 = zznk.zzaxk;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzs(context);
    }

    public final boolean zzu(Context context) {
        zzna zzna2 = zznk.zzaxl;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzs(context);
    }

    public final boolean zzv(Context context) {
        zzna zzna2 = zznk.zzaxm;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzs(context);
    }

    public final boolean zzw(Context context) {
        zzna zzna2 = zznk.zzaxn;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzs(context);
    }

    public final boolean zzx(Context context) {
        zzna zzna2 = zznk.zzaxq;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzs(context);
    }

    public final void zzb(Context context, String string2) {
        if (!this.zzs(context)) {
            return;
        }
        this.zzb(context, string2, "beginAdUnitExposure");
    }

    public final void zzc(Context context, String string2) {
        if (!this.zzs(context)) {
            return;
        }
        this.zzb(context, string2, "endAdUnitExposure");
    }

    public final String zzy(Context context) {
        if (!this.zzs(context)) {
            return "";
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcnu, true)) {
            return "";
        }
        try {
            String string2 = (String)this.zzi(context, "getCurrentScreenName").invoke(this.zzcnu.get(), new Object[0]);
            if (string2 == null) {
                string2 = (String)this.zzi(context, "getCurrentScreenClass").invoke(this.zzcnu.get(), new Object[0]);
            }
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            this.zza(exception, "getCurrentScreenName", false);
            return "";
        }
    }

    public final void zzd(Context context, String string2) {
        if (!this.zzs(context)) {
            return;
        }
        if (!(context instanceof Activity)) {
            return;
        }
        if (!this.zza(context, "com.google.firebase.analytics.FirebaseAnalytics", this.zzcnv, false)) {
            return;
        }
        Method method = this.zzj(context, "setCurrentScreen");
        try {
            Activity activity = (Activity)context;
            method.invoke(this.zzcnv.get(), activity, string2, context.getPackageName());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "setCurrentScreen", false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzz(Context context) {
        if (!this.zzs(context)) {
            return null;
        }
        Object object = this.zzcnq;
        synchronized (object) {
            if (this.zzcnr != null) {
                return this.zzcnr;
            }
            this.zzcnr = (String)this.zza("getGmpAppId", context);
            return this.zzcnr;
        }
    }

    @Nullable
    public final String zzaa(Context context) {
        if (!this.zzs(context)) {
            return null;
        }
        Object object = zznk.zzaxt;
        long l = (Long)zzkb.zzik().zzd(object);
        if (l < 0L) {
            return (String)this.zza("getAppInstanceId", context);
        }
        Context context2 = context;
        object = this;
        if (object.zzcnp.get() == null) {
            zzna zzna2 = zznk.zzaxu;
            int n = (Integer)zzkb.zzik().zzd(zzna2);
            zzna2 = zznk.zzaxu;
            int n2 = (Integer)zzkb.zzik().zzd(zzna2);
            zzna2 = object;
            object.zzcnp.compareAndSet(null, new ThreadPoolExecutor(n, n2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new zzaja((zzaiy)zzna2)));
        }
        Future future = object.zzcnp.get().submit(new zzaiz((zzaiy)object, context2));
        try {
            return (String)future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            future.cancel(true);
            if (exception instanceof TimeoutException) {
                return "TIME_OUT";
            }
            return null;
        }
    }

    @Nullable
    public final String zzab(Context context) {
        if (!this.zzs(context)) {
            return null;
        }
        Object object = this.zza("generateEventId", context);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public final void zze(Context context, String string2) {
        this.zza(context, "_ac", string2);
    }

    public final void zzf(Context context, String string2) {
        this.zza(context, "_ai", string2);
    }

    public final void zzg(Context context, String string2) {
        this.zza(context, "_aq", string2);
    }

    public final void zza(Context context, String string2, String string3, String string4, int n) {
        if (!this.zzs(context)) {
            return;
        }
        Bundle bundle = zzaiy.zza(context, string2, false);
        bundle.putString("_ai", string3);
        bundle.putString("type", string4);
        bundle.putInt("value", n);
        this.zza(context, "_ar", bundle);
        zzakb.v(new StringBuilder(75 + String.valueOf(string4).length()).append("Log a Firebase reward video event, reward type: ").append(string4).append(", reward value: ").append(n).toString());
    }

    public final void zza(Context context, String string2, String string3) {
        if (!this.zzs(context)) {
            return;
        }
        Bundle bundle = zzaiy.zza(context, string3, "_ac".equals(string2));
        this.zza(context, string2, bundle);
    }

    private final void zza(Context context, String string2, Bundle bundle) {
        if (!this.zzs(context) || !this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcnu, true)) {
            return;
        }
        Method method = this.zzac(context);
        try {
            method.invoke(this.zzcnu.get(), "am", string2, bundle);
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return;
        }
    }

    private static Bundle zza(Context context, String string2, boolean bl) {
        Bundle bundle = new Bundle();
        try {
            bundle.putLong("_aeid", Long.parseLong(string2));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String string3 = String.valueOf(string2);
            zzakb.zzb((String)(string3.length() != 0 ? "Invalid event ID: ".concat(string3) : new String("Invalid event ID: ")), (Throwable)runtimeException);
        }
        if (bl) {
            bundle.putInt("_r", 1);
        }
        return bundle;
    }

    private final Method zzac(Context context) {
        Method method = (Method)this.zzcnw.get("logEventInternal");
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod("logEventInternal", String.class, String.class, Bundle.class);
            this.zzcnw.put("logEventInternal", method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return null;
        }
    }

    private final Method zzh(Context context, String string2) {
        Method method = (Method)this.zzcnw.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, String.class);
            this.zzcnw.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzi(Context context, String string2) {
        Method method = (Method)this.zzcnw.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, new Class[0]);
            this.zzcnw.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzj(Context context, String string2) {
        Method method = (Method)this.zzcnw.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics").getDeclaredMethod(string2, Activity.class, String.class, String.class);
            this.zzcnw.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final void zzb(Context context, String string2, String string3) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcnu, true)) {
            return;
        }
        Method method = this.zzh(context, string3);
        try {
            method.invoke(this.zzcnu.get(), string2);
            zzakb.v(new StringBuilder(37 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string3).append(", Ad Unit Id: ").append(string2).toString());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, string3, false);
            return;
        }
    }

    private final Object zza(String string2, Context context) {
        Object object = null;
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcnu, true)) {
            return null;
        }
        Method method = this.zzi(context, string2);
        try {
            object = method.invoke(this.zzcnu.get(), new Object[0]);
        }
        catch (Exception exception) {
            this.zza(exception, string2, true);
        }
        return object;
    }

    private final void zza(Exception exception, String string2, boolean bl) {
        if (!this.zzcns.get()) {
            zzakb.zzdk((String)new StringBuilder(30 + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string2).append(" error.").toString());
            if (bl) {
                zzakb.zzdk((String)"The Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires the latest Firebase SDK jar, but Firebase SDK is either missing or out of date");
                this.zzcns.set(true);
            }
        }
    }

    private final boolean zza(Context context, String string2, AtomicReference<Object> atomicReference, boolean bl) {
        if (atomicReference.get() == null) {
            try {
                Method method = context.getClassLoader().loadClass(string2).getDeclaredMethod("getInstance", Context.class);
                atomicReference.compareAndSet(null, method.invoke(null, context));
            }
            catch (Exception exception) {
                this.zza(exception, "getInstance", bl);
                return false;
            }
        }
        return true;
    }

    final /* synthetic */ String zzad(Context context) throws Exception {
        return (String)this.zza("getAppInstanceId", context);
    }
}

