/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzaij;
import com.google.android.gms.internal.ads.zzaik;
import com.google.android.gms.internal.ads.zzail;
import com.google.android.gms.internal.ads.zzaim;
import com.google.android.gms.internal.ads.zzain;
import com.google.android.gms.internal.ads.zzaiq;
import com.google.android.gms.internal.ads.zzais;
import com.google.android.gms.internal.ads.zzait;
import com.google.android.gms.internal.ads.zzaiv;
import com.google.android.gms.internal.ads.zzaiw;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzaki;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzalt;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzano;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbfm;
import com.google.android.gms.internal.ads.zzbfn;
import com.google.android.gms.internal.ads.zzbfo;
import com.google.android.gms.internal.ads.zzbfp;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbfv;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
public final class zzaii
implements zzait {
    private static List<Future<Void>> zzcml = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService zzcmm = Executors.newSingleThreadScheduledExecutor();
    @GuardedBy(value="mLock")
    private final zzbfm zzcmn;
    @GuardedBy(value="mLock")
    private final LinkedHashMap<String, zzbfu> zzcmo;
    @GuardedBy(value="mLock")
    private final List<String> zzcmp = new ArrayList<String>();
    @GuardedBy(value="mLock")
    private final List<String> zzcmq = new ArrayList<String>();
    private final Context mContext;
    private final zzaiv zzcmr;
    @VisibleForTesting
    private boolean zzcms;
    private final zzaiq zzciy;
    private final zzaiw zzcmt;
    private final Object mLock = new Object();
    private HashSet<String> zzcmu = new HashSet();
    private boolean zzcmv = false;
    private boolean zzcmw = false;
    private boolean zzcmx = false;

    public zzaii(Context context, zzang zzang2, zzaiq zzaiq2, String string2, zzaiv zzaiv2) {
        Preconditions.checkNotNull((Object)((Object)zzaiq2), (Object)"SafeBrowsing config is not present.");
        this.mContext = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzcmo = new LinkedHashMap();
        this.zzcmr = zzaiv2;
        this.zzciy = zzaiq2;
        for (String string3 : this.zzciy.zzcnh) {
            this.zzcmu.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzcmu.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzang zzang3 = zzang2;
        zzaii zzaii2 = this;
        zzbfm zzbfm2 = new zzbfm();
        new zzbfm().zzamf = 8;
        zzbfm2.url = string4;
        zzbfm2.zzech = string4;
        zzbfm2.zzecj = new zzbfn();
        zzbfm2.zzecj.zzcnd = zzaii2.zzciy.zzcnd;
        zzbfv zzbfv2 = new zzbfv();
        new zzbfv().zzedv = zzang3.zzcw;
        zzbfv2.zzedx = Wrappers.packageManager((Context)zzaii2.mContext).isCallerInstantApp();
        long l = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzaii2.mContext);
        if (l > 0L) {
            zzbfv2.zzedw = l;
        }
        zzbfm2.zzect = zzbfv2;
        this.zzcmn = zzbfm2;
        this.zzcmt = new zzaiw(this.mContext, this.zzciy.zzcnk, this);
    }

    @Override
    public final zzaiq zzpg() {
        return this.zzciy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcf(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcmn.zzecl = string2;
            return;
        }
    }

    @Override
    public final boolean zzph() {
        return PlatformVersion.isAtLeastKitKat() && this.zzciy.zzcnf && !this.zzcmw;
    }

    @Override
    public final void zzr(View view) {
        if (!this.zzciy.zzcnf) {
            return;
        }
        if (this.zzcmw) {
            return;
        }
        zzbv.zzek();
        Bitmap bitmap = zzakk.zzt(view);
        if (bitmap == null) {
            zzais.zzck("Failed to capture the webview bitmap.");
            return;
        }
        this.zzcmw = true;
        zzakk.zzd(new zzail(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (n == 3) {
                this.zzcmx = true;
            }
            if (this.zzcmo.containsKey(string2)) {
                if (n == 3) {
                    this.zzcmo.get((Object)string2).zzedt = n;
                }
                return;
            }
            zzbfu zzbfu2 = new zzbfu();
            new zzbfu().zzedt = n;
            zzbfu2.zzedn = this.zzcmo.size();
            zzbfu2.url = string2;
            zzbfu2.zzedo = new zzbfp();
            if (this.zzcmu.size() > 0 && map != null) {
                ArrayList<zzbfo> arrayList = new ArrayList<zzbfo>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    try {
                        String string3 = entry.getKey() != null ? entry.getKey() : "";
                        String string4 = entry.getValue() != null ? entry.getValue() : "";
                        String string5 = string3.toLowerCase(Locale.ENGLISH);
                        if (!this.zzcmu.contains(string5)) continue;
                        zzbfo zzbfo2 = new zzbfo();
                        new zzbfo().zzecx = string3.getBytes("UTF-8");
                        zzbfo2.zzecy = string4.getBytes("UTF-8");
                        arrayList.add(zzbfo2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        zzais.zzck("Cannot convert string to bytes, skip header.");
                    }
                }
                zzbfo[] zzbfoArray = new zzbfo[arrayList.size()];
                arrayList.toArray(zzbfoArray);
                zzbfu2.zzedo.zzeda = zzbfoArray;
            }
            this.zzcmo.put(string2, zzbfu2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzcg(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcmp.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzch(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcmq.add(string2);
            return;
        }
    }

    @Override
    public final String[] zzb(String[] stringArray) {
        return this.zzcmt.zzc(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zzpi() {
        this.zzcmv = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzbfu zzci(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcmo.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzpj() {
        Object object = this.mLock;
        synchronized (object) {
            zzanz zzanz2 = zzano.zza(this.zzcmr.zza(this.mContext, this.zzcmo.keySet()), new zzaij(this), zzaoe.zzcvz);
            zzanz zzanz3 = zzano.zza(zzanz2, 10L, TimeUnit.SECONDS, zzcmm);
            zzano.zza(zzanz2, new zzaim(this, zzanz3), zzaoe.zzcvz);
            zzcml.add(zzanz3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzanz<Void> zzpk() {
        if (!(this.zzcms && this.zzciy.zzcnj || this.zzcmx && this.zzciy.zzcni || !this.zzcms && this.zzciy.zzcng)) {
            return zzano.zzi(null);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.zzcmn.zzeck = new zzbfu[this.zzcmo.size()];
            this.zzcmo.values().toArray(this.zzcmn.zzeck);
            this.zzcmn.zzecu = this.zzcmp.toArray(new String[0]);
            this.zzcmn.zzecv = this.zzcmq.toArray(new String[0]);
            if (zzais.isEnabled()) {
                zzbfu[] zzbfuArray = this.zzcmn.url;
                String string2 = this.zzcmn.zzecl;
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(zzbfuArray).length() + String.valueOf(string2).length()).append("Sending SB report\n  url: ").append((String)zzbfuArray).append("\n  clickUrl: ").append(string2).append("\n  resources: \n").toString());
                zzbfuArray = this.zzcmn.zzeck;
                int n = this.zzcmn.zzeck.length;
                for (int i = 0; i < n; ++i) {
                    zzbfu zzbfu2 = zzbfuArray[i];
                    stringBuilder.append("    [");
                    stringBuilder.append(zzbfu2.zzedu.length);
                    stringBuilder.append("] ");
                    stringBuilder.append(zzbfu2.url);
                }
                zzais.zzck(stringBuilder.toString());
            }
            String string3 = this.zzciy.zzcne;
            byte[] byArray = zzbfi.zzb((zzbfi)this.zzcmn);
            zzaii zzaii2 = this;
            zzanz<String> zzanz2 = new zzalt(zzaii2.mContext).zza(1, string3, null, byArray);
            if (zzais.isEnabled()) {
                zzanz2.zza(new zzain(zzaii2), zzaki.zzcrj);
            }
            return zzano.zza(zzanz2, zzaik.zzcmz, zzaoe.zzcvz);
        }
    }

    static final /* synthetic */ Void zzcj(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzanz zzm(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzaii zzaii2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzaii2.mLock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzbfu zzbfu2 = zzaii2.zzci(string2);
                        if (zzbfu2 == null) {
                            String string4 = String.valueOf(string2);
                            zzais.zzck(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        zzbfu2.zzedu = new String[n];
                        for (int i = 0; i < n; ++i) {
                            zzbfu2.zzedu[i] = jSONArray.getJSONObject(i).getString("threat_type");
                        }
                        zzaii2.zzcms = zzaii2.zzcms | n > 0;
                    }
                }
            }
            if (this.zzcms) {
                Object object = this.mLock;
                synchronized (object) {
                    this.zzcmn.zzamf = 9;
                }
            }
            return this.zzpk();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            zzna zzna2 = zznk.zzbdi;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                zzakb.zza((String)string5, (Throwable)jSONException2);
            }
            return zzano.zzd(new Exception("Safebrowsing report transmission failed."));
        }
    }

    static /* synthetic */ Object zza(zzaii zzaii2) {
        return zzaii2.mLock;
    }

    static /* synthetic */ zzbfm zzb(zzaii zzaii2) {
        return zzaii2.zzcmn;
    }

    static /* synthetic */ List zzpl() {
        return zzcml;
    }
}

