/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzoh;
import java.util.Locale;

public final class zzagb {
    private int zzcjk;
    private boolean zzcjr;
    private boolean zzcjs;
    private int zzcjw;
    private int zzcka;
    private int zzckb;
    private String zzcjn;
    private int zzcjx;
    private int zzcjy;
    private int zzcjz;
    private boolean zzcke;
    private int zzckf;
    private double zzckc;
    private boolean zzckd;
    private String zzckg;
    private String zzckh;
    private boolean zzcjl;
    private boolean zzcjm;
    private String zzcjo;
    private boolean zzcjp;
    private boolean zzcjq;
    private String zzcjt;
    private String zzcju;
    private float zzagu;
    private int zzcde;
    private int zzcdf;
    private String zzcjv;
    private boolean zzcki;

    public zzagb(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzn(context);
        this.zzo(context);
        this.zzp(context);
        Locale locale = Locale.getDefault();
        this.zzcjl = zzagb.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcjm = zzagb.zza(packageManager, "http://www.google.com") != null;
        this.zzcjo = locale.getCountry();
        zzkb.zzif();
        this.zzcjp = zzamu.zzsg();
        this.zzcjq = DeviceProperties.isSidewinder((Context)context);
        this.zzcjt = locale.getLanguage();
        this.zzcju = zzagb.zzb(context, packageManager);
        this.zzcjv = zzagb.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzagu = displayMetrics.density;
        this.zzcde = displayMetrics.widthPixels;
        this.zzcdf = displayMetrics.heightPixels;
    }

    public zzagb(Context context, zzaga zzaga2) {
        context.getPackageManager();
        this.zzn(context);
        this.zzo(context);
        this.zzp(context);
        Context context2 = context;
        zzagb zzagb2 = this;
        this.zzckg = Build.FINGERPRINT;
        zzagb2.zzckh = Build.DEVICE;
        zzagb2.zzcki = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzoh.zzh(context2);
        this.zzcjl = zzaga2.zzcjl;
        this.zzcjm = zzaga2.zzcjm;
        this.zzcjo = zzaga2.zzcjo;
        this.zzcjp = zzaga2.zzcjp;
        this.zzcjq = zzaga2.zzcjq;
        this.zzcjt = zzaga2.zzcjt;
        this.zzcju = zzaga2.zzcju;
        this.zzcjv = zzaga2.zzcjv;
        this.zzagu = zzaga2.zzagu;
        this.zzcde = zzaga2.zzcde;
        this.zzcdf = zzaga2.zzcdf;
    }

    private final void zzn(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzcjk = audioManager.getMode();
                this.zzcjr = audioManager.isMusicActive();
                this.zzcjs = audioManager.isSpeakerphoneOn();
                this.zzcjw = audioManager.getStreamVolume(3);
                this.zzcka = audioManager.getRingerMode();
                this.zzckb = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbv.zzeo().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcjk = -2;
        this.zzcjr = false;
        this.zzcjs = false;
        this.zzcjw = 0;
        this.zzcka = 0;
        this.zzckb = 0;
    }

    @TargetApi(value=16)
    private final void zzo(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcjn = telephonyManager.getNetworkOperator();
        this.zzcjy = telephonyManager.getNetworkType();
        this.zzcjz = telephonyManager.getPhoneType();
        this.zzcjx = -2;
        this.zzcke = false;
        this.zzckf = -1;
        zzbv.zzek();
        if (zzakk.zzl(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcjx = networkInfo.getType();
                this.zzckf = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcjx = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcke = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzp(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzckc = (float)n2 / (float)n3;
            this.zzckd = n == 2 || n == 5;
            return;
        }
        this.zzckc = -1.0;
        this.zzckd = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzagb.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbv.zzeo().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaga zzoo() {
        return new zzaga(this.zzcjk, this.zzcjl, this.zzcjm, this.zzcjn, this.zzcjo, this.zzcjp, this.zzcjq, this.zzcjr, this.zzcjs, this.zzcjt, this.zzcju, this.zzcjv, this.zzcjw, this.zzcjx, this.zzcjy, this.zzcjz, this.zzcka, this.zzckb, this.zzagu, this.zzcde, this.zzcdf, this.zzckc, this.zzckd, this.zzcke, this.zzckf, this.zzckg, this.zzcki, this.zzckh);
    }
}

