/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.gmsg.HttpClient;
import com.google.android.gms.ads.internal.gmsg.zzaa;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzadj;
import com.google.android.gms.internal.ads.zzaef;
import com.google.android.gms.internal.ads.zzaeg;
import com.google.android.gms.internal.ads.zzaej;
import com.google.android.gms.internal.ads.zzafb;
import com.google.android.gms.internal.ads.zzafc;
import com.google.android.gms.internal.ads.zzaff;
import com.google.android.gms.internal.ads.zzafg;
import com.google.android.gms.internal.ads.zzafh;
import com.google.android.gms.internal.ads.zzafi;
import com.google.android.gms.internal.ads.zzafl;
import com.google.android.gms.internal.ads.zzafs;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzaji;
import com.google.android.gms.internal.ads.zzajx;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzhx;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzvf;
import com.google.android.gms.internal.ads.zzvs;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
public final class zzafa
extends zzajx {
    @VisibleForTesting
    private static final long zzcgc = TimeUnit.SECONDS.toMillis(10L);
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    @VisibleForTesting
    private static boolean zzcgd = false;
    private static zzvf zzcge = null;
    private static HttpClient zzcgf = null;
    private static zzaa zzcgg = null;
    private static zzv<Object> zzcgh = null;
    private final zzadj zzccf;
    private final zzaeg zzccg;
    private final Object zzbzh = new Object();
    private final Context mContext;
    private zzvs zzcgi;
    private zzhx zzcci;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzafa(Context context, zzaeg zzaeg2, zzadj zzadj2, zzhx zzhx2) {
        super(true);
        this.zzccf = zzadj2;
        this.mContext = context;
        this.zzccg = zzaeg2;
        this.zzcci = zzhx2;
        Object object = sLock;
        synchronized (object) {
            if (!zzcgd) {
                zzcgg = new zzaa();
                zzcgf = new HttpClient(context.getApplicationContext(), zzaeg2.zzacr);
                zzcgh = new zzafi();
                zzna zzna2 = zznk.zzaub;
                zzcge = new zzvf(this.mContext.getApplicationContext(), this.zzccg.zzacr, (String)zzkb.zzik().zzd(zzna2), new zzafh(), new zzafg());
                zzcgd = true;
            }
            return;
        }
    }

    protected static void zzb(zzuu zzuu2) {
        zzuu2.zza("/loadAd", zzcgg);
        zzuu2.zza("/fetchHttpRequest", zzcgf);
        zzuu2.zza("/invalidRequest", zzcgh);
    }

    protected static void zzc(zzuu zzuu2) {
        zzuu2.zzb("/loadAd", zzcgg);
        zzuu2.zzb("/fetchHttpRequest", zzcgf);
        zzuu2.zzb("/invalidRequest", zzcgh);
    }

    @Override
    public final void zzdn() {
        zzakb.zzck((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzbv.zzfh().zzab(this.mContext);
        zzaef zzaef2 = new zzaef(this.zzccg, -1L, zzbv.zzfh().zzz(this.mContext), zzbv.zzfh().zzaa(this.mContext), string2);
        zzbv.zzfh().zzg(this.mContext, string2);
        zzaej zzaej2 = this.zzc(zzaef2);
        long l = zzbv.zzer().elapsedRealtime();
        zzaji zzaji2 = new zzaji(zzaef2, zzaej2, null, null, zzaej2.errorCode, l, zzaej2.zzceu, null, this.zzcci);
        zzamu.zzsy.post((Runnable)new zzafb(this, zzaji2));
    }

    private final zzaej zzc(zzaef zzaef2) {
        JSONObject jSONObject;
        zzbv.zzek();
        String string2 = zzakk.zzrh();
        JSONObject jSONObject2 = this.zza(zzaef2, string2);
        if (jSONObject2 == null) {
            return new zzaej(0);
        }
        long l = zzbv.zzer().elapsedRealtime();
        Future<JSONObject> future = zzcgg.zzas(string2);
        zzamu.zzsy.post((Runnable)new zzafc(this, jSONObject2, string2));
        long l2 = zzcgc - (zzbv.zzer().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzaej(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzaej(2);
        }
        catch (ExecutionException executionException) {
            return new zzaej(0);
        }
        if (jSONObject == null) {
            return new zzaej(-1);
        }
        zzaej zzaej2 = zzafs.zza(this.mContext, zzaef2, jSONObject.toString());
        if (zzaej2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzaej2.zzceo)) {
            return new zzaej(3);
        }
        return zzaej2;
    }

    private final JSONObject zza(zzaef zzaef2, String string2) {
        Bundle bundle = zzaef2.zzccv.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzaga zzaga2 = null;
        try {
            zzaga2 = zzbv.zzev().zzq(this.mContext).get();
        }
        catch (Exception exception) {
            zzakb.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        Object object = zzaef2;
        zzafl zzafl2 = new zzafl();
        new zzafl().zzcgs = object;
        object = zzaga2;
        v0.zzcgt = object;
        JSONObject jSONObject = zzafs.zza(this.mContext, zzafl2);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzakb.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzbv.zzek().zzn(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzbzh;
        synchronized (object) {
            zzamu.zzsy.post((Runnable)new zzaff(this));
            return;
        }
    }

    static /* synthetic */ zzaa zzod() {
        return zzcgg;
    }

    static /* synthetic */ zzadj zza(zzafa zzafa2) {
        return zzafa2.zzccf;
    }

    static /* synthetic */ zzvs zzb(zzafa zzafa2) {
        return zzafa2.zzcgi;
    }

    static /* synthetic */ zzvs zza(zzafa zzafa2, zzvs zzvs2) {
        zzafa2.zzcgi = zzvs2;
        return zzafa2.zzcgi;
    }

    static /* synthetic */ zzvf zzoe() {
        return zzcge;
    }
}

