/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzaew;
import com.google.android.gms.internal.ads.zzaex;
import com.google.android.gms.internal.ads.zzakb;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzadh
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LargeParcelTeleporterCreator")
public final class zzaev
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaev> CREATOR = new zzaex();
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zzcft;
    private Parcelable zzcfu;
    private boolean zzcfv;

    @SafeParcelable.Constructor
    public zzaev(@SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcft = parcelFileDescriptor;
        this.zzcfu = null;
        this.zzcfv = true;
    }

    public zzaev(SafeParcelable safeParcelable) {
        this.zzcft = null;
        this.zzcfu = safeParcelable;
        this.zzcfv = false;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcfv) {
            byte[] byArray;
            if (this.zzcft == null) {
                zzakb.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcft));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzakb.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcfu = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcfv = false;
        }
        return (T)((SafeParcelable)this.zzcfu);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzoc();
        Parcel parcel2 = parcel;
        zzaev zzaev2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzaev2.zzcft, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzoc() {
        if (this.zzcft == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzcfu.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzcft = this.zze(byArray);
        }
        return this.zzcft;
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzaew zzaew2 = new zzaew(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzaew2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzakb.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbv.zzeo().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            IOUtils.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

