/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzaaf;
import com.google.android.gms.internal.ads.zzaag;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzaqw;
import java.util.Map;

@zzadh
public final class zzaae
extends zzaal {
    private final Map<String, String> zzbgp;
    private final Context mContext;

    public zzaae(zzaqw zzaqw2, Map<String, String> map) {
        super(zzaqw2, "storePicture");
        this.zzbgp = map;
        this.mContext = zzaqw2.zzto();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbw("Activity context is not available");
            return;
        }
        zzbv.zzek();
        if (!zzakk.zzao(this.mContext).zziy()) {
            this.zzbw("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbgp.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbw("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbw(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbv.zzek();
        if (!zzakk.zzcw(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbw(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbv.zzeo().getResources();
        zzbv.zzek();
        AlertDialog.Builder builder = zzakk.zzan(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzaaf(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzaag(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzaae zzaae2) {
        return zzaae2.mContext;
    }
}

