/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.internal.ads.zzaac;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzaam;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzkb;
import java.util.Map;
import java.util.Set;

@zzadh
public final class zzaab
extends zzaal {
    private static final Set<String> zzbvy = CollectionUtils.setOf((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbvz = "top-right";
    private boolean zzbwa = true;
    private int zzbwb = 0;
    private int zzbwc = 0;
    private int zzur = -1;
    private int zzbwd = 0;
    private int zzbwe = 0;
    private int zzuq = -1;
    private final Object mLock = new Object();
    private final zzaqw zzbnd;
    private final Activity zzbvp;
    private zzasi zzbwf;
    private ImageView zzbwg;
    private LinearLayout zzbwh;
    private zzaam zzbmy;
    private PopupWindow zzbwi;
    private RelativeLayout zzbwj;
    private ViewGroup zzbwk;

    public zzaab(zzaqw zzaqw2, zzaam zzaam2) {
        super(zzaqw2, "resize");
        this.zzbnd = zzaqw2;
        this.zzbvp = zzaqw2.zzto();
        this.zzbmy = zzaam2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzbvp == null) {
                this.zzbw("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbnd.zzud() == null) {
                this.zzbw("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbnd.zzud().zzvs()) {
                this.zzbw("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbnd.zzuj()) {
                this.zzbw("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzaab zzaab2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbv.zzek();
                zzaab2.zzuq = zzakk.zzcv(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbv.zzek();
                zzaab2.zzur = zzakk.zzcv(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbv.zzek();
                zzaab2.zzbwd = zzakk.zzcv(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbv.zzek();
                zzaab2.zzbwe = zzakk.zzcv(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzaab2.zzbwa = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzaab2.zzbvz = string2;
            }
            zzaab2 = this;
            if (!(zzaab2.zzuq >= 0 && zzaab2.zzur >= 0)) {
                this.zzbw("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbvp.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbw("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzne();
            if (nArray == null) {
                this.zzbw("Resize location out of screen or close button is not visible.");
                return;
            }
            zzkb.zzif();
            int n = zzamu.zza((Context)this.zzbvp, (int)this.zzuq);
            zzkb.zzif();
            int n2 = zzamu.zza((Context)this.zzbvp, (int)this.zzur);
            ViewParent viewParent = this.zzbnd.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbnd.getView());
                if (this.zzbwi == null) {
                    this.zzbwk = (ViewGroup)viewParent;
                    zzbv.zzek();
                    bitmap = zzakk.zzs(this.zzbnd.getView());
                    this.zzbwg = new ImageView((Context)this.zzbvp);
                    this.zzbwg.setImageBitmap(bitmap);
                    this.zzbwf = this.zzbnd.zzud();
                    this.zzbwk.addView((View)this.zzbwg);
                } else {
                    this.zzbwi.dismiss();
                }
            } else {
                this.zzbw("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbwj = new RelativeLayout((Context)this.zzbvp);
            this.zzbwj.setBackgroundColor(0);
            this.zzbwj.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbv.zzek();
            this.zzbwi = zzakk.zza((View)this.zzbwj, n, n2, false);
            this.zzbwi.setOutsideTouchable(true);
            this.zzbwi.setTouchable(true);
            this.zzbwi.setClippingEnabled(!this.zzbwa);
            this.zzbwj.addView(this.zzbnd.getView(), -1, -1);
            this.zzbwh = new LinearLayout((Context)this.zzbvp);
            zzkb.zzif();
            int n3 = zzamu.zza((Context)this.zzbvp, (int)50);
            zzkb.zzif();
            bitmap = new RelativeLayout.LayoutParams(n3, zzamu.zza((Context)this.zzbvp, (int)50));
            switch (this.zzbvz) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbwh.setOnClickListener((View.OnClickListener)new zzaac(this));
            this.zzbwh.setContentDescription((CharSequence)"Close button");
            this.zzbwj.addView((View)this.zzbwh, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzkb.zzif();
                int n4 = zzamu.zza((Context)this.zzbvp, (int)nArray[0]);
                zzkb.zzif();
                this.zzbwi.showAtLocation(view, 0, n4, zzamu.zza((Context)this.zzbvp, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbw(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzbwj.removeView(this.zzbnd.getView());
                if (this.zzbwk != null) {
                    this.zzbwk.removeView((View)this.zzbwg);
                    this.zzbwk.addView(this.zzbnd.getView());
                    this.zzbnd.zza(this.zzbwf);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzaab2 = this;
            if (zzaab2.zzbmy != null) {
                zzaab2.zzbmy.zza(n6, n5, zzaab2.zzuq, zzaab2.zzur);
            }
            this.zzbnd.zza(zzasi.zzi(n, n2));
            this.zza(nArray[0], nArray[1]);
            this.zzby("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbwi != null) {
                this.zzbwi.dismiss();
                this.zzbwj.removeView(this.zzbnd.getView());
                if (this.zzbwk != null) {
                    this.zzbwk.removeView((View)this.zzbwg);
                    this.zzbwk.addView(this.zzbnd.getView());
                    this.zzbnd.zza(this.zzbwf);
                }
                if (bl) {
                    this.zzby("default");
                    if (this.zzbmy != null) {
                        this.zzbmy.zzcq();
                    }
                }
                this.zzbwi = null;
                this.zzbwj = null;
                this.zzbwk = null;
                this.zzbwh = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzne() {
        zzaab zzaab2 = this;
        int[] nArray = zzbv.zzek().zzg(zzaab2.zzbvp);
        int[] nArray2 = zzbv.zzek().zzh(zzaab2.zzbvp);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzaab2.zzuq < 50 || zzaab2.zzuq > n) {
            zzakb.zzdk((String)"Width is too small or too large.");
            return null;
        }
        if (zzaab2.zzur < 50 || zzaab2.zzur > n2) {
            zzakb.zzdk((String)"Height is too small or too large.");
            return null;
        }
        if (zzaab2.zzur == n2 && zzaab2.zzuq == n) {
            zzakb.zzdk((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzaab2.zzbwa) {
            int n3;
            int n4;
            switch (zzaab2.zzbvz) {
                case "top-left": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe;
                    break;
                }
                case "top-center": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd + zzaab2.zzuq / 2 - 25;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe;
                    break;
                }
                case "center": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd + zzaab2.zzuq / 2 - 25;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe + zzaab2.zzur / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe + zzaab2.zzur - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd + zzaab2.zzuq / 2 - 25;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe + zzaab2.zzur - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd + zzaab2.zzuq - 50;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe + zzaab2.zzur - 50;
                    break;
                }
                default: {
                    n4 = zzaab2.zzbwb + zzaab2.zzbwd + zzaab2.zzuq - 50;
                    n3 = zzaab2.zzbwc + zzaab2.zzbwe;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzbwa) {
            return new int[]{this.zzbwb + this.zzbwd, this.zzbwc + this.zzbwe};
        }
        int[] nArray3 = zzbv.zzek().zzg(this.zzbvp);
        int[] nArray4 = zzbv.zzek().zzh(this.zzbvp);
        int n5 = nArray3[0];
        int n6 = this.zzbwb + this.zzbwd;
        int n7 = this.zzbwc + this.zzbwe;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzuq > n5) {
            n6 = n5 - this.zzuq;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzur <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzur;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbwb = n;
            this.zzbwc = n2;
            if (this.zzbwi != null && bl) {
                int[] nArray = this.zzne();
                if (nArray != null) {
                    zzkb.zzif();
                    int n3 = zzamu.zza((Context)this.zzbvp, (int)nArray[0]);
                    zzkb.zzif();
                    this.zzbwi.update(n3, zzamu.zza((Context)this.zzbvp, (int)nArray[1]), this.zzbwi.getWidth(), this.zzbwi.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzm(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbv.zzek().zzh(this.zzbvp)[0];
        this.zzb(n, n2 - n3, this.zzuq, this.zzur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zznf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbwi != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzbwb = n;
        this.zzbwc = n2;
    }
}

