/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.graphics.Rect;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzaa;
import com.google.android.gms.ads.internal.zzab;
import com.google.android.gms.ads.internal.zzac;
import com.google.android.gms.ads.internal.zzas;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzi;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.ads.internal.zzx;
import com.google.android.gms.ads.internal.zzz;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzait;
import com.google.android.gms.internal.ads.zzaix;
import com.google.android.gms.internal.ads.zzajh;
import com.google.android.gms.internal.ads.zzaji;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzaor;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzarl;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzfp;
import com.google.android.gms.internal.ads.zzhu;
import com.google.android.gms.internal.ads.zzjj;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzlo;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzxn;
import com.google.android.gms.internal.ads.zzxz;
import com.google.android.gms.internal.ads.zzyc;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzy
extends zzi
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private boolean zzvm;
    private boolean zzxf;
    private WeakReference<Object> zzxg = new WeakReference<Object>(null);

    public zzy(Context context, zzjn zzjn2, String string2, zzxn zzxn2, zzang zzang2, zzw zzw2) {
        super(context, zzjn2, string2, zzxn2, zzang2, zzw2);
    }

    @Override
    protected final zzaqw zza(zzaji zzaji2, @Nullable zzx zzx2, @Nullable zzait zzait2) throws zzarg {
        if (this.zzvw.zzacv.zzard == null && this.zzvw.zzacv.zzarf) {
            zzjn zzjn2;
            zzaji zzaji3 = zzaji2;
            zzy zzy2 = this;
            if (zzaji3.zzcos.zzarf) {
                zzjn2 = zzy2.zzvw.zzacv;
            } else {
                AdSize adSize;
                String string2 = zzaji3.zzcos.zzcet;
                if (string2 != null) {
                    String[] stringArray = string2.split("[xX]");
                    String[] stringArray2 = stringArray;
                    stringArray[0] = stringArray2[0].trim();
                    stringArray2[1] = stringArray2[1].trim();
                    int n = Integer.parseInt(stringArray2[0]);
                    int n2 = Integer.parseInt(stringArray2[1]);
                    adSize = new AdSize(n, n2);
                } else {
                    adSize = zzy2.zzvw.zzacv.zzhy();
                }
                zzjn2 = new zzjn(zzy2.zzvw.zzrt, adSize);
            }
            this.zzvw.zzacv = zzjn2;
        }
        return super.zza(zzaji2, zzx2, zzait2);
    }

    @Override
    public final boolean zzb(zzjj zzjj2) {
        zzjj zzjj3 = zzjj2;
        zzy zzy2 = this;
        return super.zzb(zzjj3.zzaqb == zzy2.zzvm ? zzjj3 : new zzjj(zzjj3.versionCode, zzjj3.zzapw, zzjj3.extras, zzjj3.zzapx, zzjj3.zzapy, zzjj3.zzapz, zzjj3.zzaqa, zzjj3.zzaqb || zzy2.zzvm, zzjj3.zzaqc, zzjj3.zzaqd, zzjj3.zzaqe, zzjj3.zzaqf, zzjj3.zzaqg, zzjj3.zzaqh, zzjj3.zzaqi, zzjj3.zzaqj, zzjj3.zzaqk, zzjj3.zzaql));
    }

    @Override
    public final boolean zza(@Nullable zzajh zzajh2, zzajh zzajh3) {
        Object object;
        zzasc zzasc2;
        Object object2;
        block23: {
            block24: {
                block22: {
                    if (!super.zza(zzajh2, zzajh3)) {
                        return false;
                    }
                    if (this.zzvw.zzfo() && !this.zzd(zzajh2, zzajh3)) {
                        if (zzajh3.zzcoq != null) {
                            zzajh3.zzcoq.zza(zzhu.zza.zzb.zzakl);
                        }
                        this.zzi(0);
                        return false;
                    }
                    this.zzb(zzajh3, false);
                    if (!zzajh3.zzcfh) break block22;
                    this.zzd(zzajh3);
                    zzbv.zzfg();
                    zzaor.zza((View)this.zzvw.zzacs, this);
                    zzbv.zzfg();
                    zzaor.zza((View)this.zzvw.zzacs, this);
                    if (!zzajh3.zzcoc) {
                        object2 = new zzab(this);
                        zzasc2 = zzajh3.zzbyo != null ? zzajh3.zzbyo.zzuf() : null;
                        if (zzasc2 != null) {
                            zzasc2.zza(new zzz(zzajh3, (Runnable)object2));
                        }
                    }
                    break block23;
                }
                if (!this.zzvw.zzfp()) break block24;
                object = zznk.zzbbo;
                if (!((Boolean)zzkb.zzik().zzd(object)).booleanValue()) break block23;
            }
            ((zzd)this).zza(zzajh3, false);
        }
        if (zzajh3.zzbyo != null) {
            object2 = zzajh3.zzbyo.zztm();
            zzasc2 = zzajh3.zzbyo.zzuf();
            if (zzasc2 != null) {
                zzasc2.zzuz();
            }
            if (this.zzvw.zzadk != null && object2 != null) {
                ((zzarl)((Object)object2)).zzb(this.zzvw.zzadk);
            }
        }
        zzajh zzajh4 = zzajh3;
        object = this;
        if (PlatformVersion.isAtLeastIceCreamSandwich()) {
            View view = null;
            if (object.zzvw.zzfo()) {
                if (zzajh4.zzbyo != null) {
                    if (zzajh4.zzcob != null) {
                        object.zzvy.zza(object.zzvw.zzacv, zzajh4);
                    }
                    view = zzajh4.zzbyo.getView();
                    zzfp zzfp2 = new zzfp(object.zzvw.zzrt, view);
                    if (zzbv.zzfh().zzt(object.zzvw.zzrt) && zzy.zza(zzajh4.zzccv) && !TextUtils.isEmpty((CharSequence)object.zzvw.zzacp)) {
                        zzfp2.zza(new zzaix(object.zzvw.zzrt, object.zzvw.zzacp));
                    }
                    if (zzajh4.zzfz()) {
                        zzfp2.zza(zzajh4.zzbyo);
                    } else {
                        zzajh4.zzbyo.zzuf().zza(new zzaa(zzfp2, zzajh4));
                    }
                }
            } else if (object.zzvw.zzadu != null && zzajh4.zzcob != null) {
                object.zzvy.zza(object.zzvw.zzacv, zzajh4, object.zzvw.zzadu);
                view = object.zzvw.zzadu;
            }
            if (!zzajh4.zzceq) {
                object.zzvw.zzj(view);
            }
        }
        return true;
    }

    private final boolean zzd(@Nullable zzajh zzajh2, zzajh zzajh3) {
        View view;
        if (zzajh3.zzceq) {
            view = zzas.zze(zzajh3);
            if (view == null) {
                zzakb.zzdk((String)"Could not get mediation view");
                return false;
            }
            View view2 = this.zzvw.zzacs.getNextView();
            if (view2 != null) {
                if (view2 instanceof zzaqw) {
                    ((zzaqw)view2).destroy();
                }
                this.zzvw.zzacs.removeView(view2);
            }
            if (!zzas.zzf(zzajh3)) {
                try {
                    if (zzbv.zzfh().zzt(this.zzvw.zzrt)) {
                        new zzfp(this.zzvw.zzrt, view).zza(new zzaix(this.zzvw.zzrt, this.zzvw.zzacp));
                    }
                    if (zzajh3.zzcof != null) {
                        this.zzvw.zzacs.setMinimumWidth(zzajh3.zzcof.widthPixels);
                        this.zzvw.zzacs.setMinimumHeight(zzajh3.zzcof.heightPixels);
                    }
                    this.zzg(view);
                }
                catch (Exception exception) {
                    zzbv.zzeo().zza(exception, "BannerAdManager.swapViews");
                    zzakb.zzc((String)"Could not add mediation view to view hierarchy.", (Throwable)exception);
                    return false;
                }
            }
        } else if (zzajh3.zzcof != null && zzajh3.zzbyo != null) {
            zzajh3.zzbyo.zza(zzasi.zzb(zzajh3.zzcof));
            this.zzvw.zzacs.removeAllViews();
            this.zzvw.zzacs.setMinimumWidth(zzajh3.zzcof.widthPixels);
            this.zzvw.zzacs.setMinimumHeight(zzajh3.zzcof.heightPixels);
            this.zzg(zzajh3.zzbyo.getView());
        }
        if (this.zzvw.zzacs.getChildCount() > 1) {
            this.zzvw.zzacs.showNext();
        }
        if (zzajh2 != null) {
            view = this.zzvw.zzacs.getNextView();
            if (view instanceof zzaqw) {
                ((zzaqw)view).destroy();
            } else if (view != null) {
                this.zzvw.zzacs.removeView(view);
            }
            this.zzvw.zzfn();
        }
        this.zzvw.zzacs.setVisibility(0);
        return true;
    }

    @Override
    protected final void zzbq() {
        zzaqw zzaqw2;
        zzaqw zzaqw3 = zzaqw2 = this.zzvw.zzacw != null ? this.zzvw.zzacw.zzbyo : null;
        if (!this.zzxf && zzaqw2 != null) {
            this.zzc(zzaqw2);
        }
        super.zzbq();
    }

    private final void zzc(zzaqw zzaqw2) {
        if (!this.zzcp()) {
            return;
        }
        WebView webView = zzaqw2.getWebView();
        if (webView == null) {
            return;
        }
        View view = zzaqw2.getView();
        if (view == null) {
            return;
        }
        if (!zzbv.zzfa().zzi(this.zzvw.zzrt)) {
            return;
        }
        int n = this.zzvw.zzacr.zzcve;
        int n2 = this.zzvw.zzacr.zzcvf;
        String string2 = new StringBuilder(23).append(n).append(".").append(n2).toString();
        this.zzwb = zzbv.zzfa().zza(string2, webView, "", "javascript", this.zzbz());
        if (this.zzwb != null) {
            zzbv.zzfa().zza(this.zzwb, view);
            zzbv.zzfa().zzm(this.zzwb);
            this.zzxf = true;
        }
    }

    @Override
    protected final boolean zzca() {
        boolean bl = true;
        zzbv.zzek();
        if (!zzakk.zzl(this.zzvw.zzrt, "android.permission.INTERNET")) {
            zzkb.zzif().zza((ViewGroup)this.zzvw.zzacs, this.zzvw.zzacv, "Missing internet permission in AndroidManifest.xml.", "Missing internet permission in AndroidManifest.xml. You must have the following declaration: <uses-permission android:name=\"android.permission.INTERNET\" />");
            bl = false;
        }
        zzbv.zzek();
        if (!zzakk.zzaj(this.zzvw.zzrt)) {
            zzkb.zzif().zza((ViewGroup)this.zzvw.zzacs, this.zzvw.zzacv, "Missing AdActivity with android:configChanges in AndroidManifest.xml.", "Missing AdActivity with android:configChanges in AndroidManifest.xml. You must have the following declaration within the <application> element: <activity android:name=\"com.google.android.gms.ads.AdActivity\" android:configChanges=\"keyboard|keyboardHidden|orientation|screenLayout|uiMode|screenSize|smallestScreenSize\" />");
            bl = false;
        }
        if (!bl && this.zzvw.zzacs != null) {
            this.zzvw.zzacs.setVisibility(0);
        }
        return bl;
    }

    @Override
    public final void setManualImpressionsEnabled(boolean bl) {
        Preconditions.checkMainThread((String)"setManualImpressionsEnabled must be called from the main thread.");
        this.zzvm = bl;
    }

    @Override
    public final void showInterstitial() {
        throw new IllegalStateException("Interstitial is NOT supported by BannerAdManager.");
    }

    public final void onGlobalLayout() {
        this.zzd(this.zzvw.zzacw);
    }

    public final void onScrollChanged() {
        this.zzd(this.zzvw.zzacw);
    }

    @Override
    protected final void zza(@Nullable zzajh zzajh2, boolean bl) {
        zzaqw zzaqw2;
        Object object = zzajh2;
        Object object2 = this;
        if (((zzi)object2).zzcp() && (zzaqw2 = object != null ? ((zzajh)object).zzbyo : null) != null) {
            if (!((zzy)object2).zzxf) {
                ((zzy)object2).zzc(zzaqw2);
            }
            if (((zzy)object2).zzwb != null) {
                zzaqw2.zza("onSdkImpression", (Map<String, ?>)new ArrayMap());
            }
        }
        super.zza(zzajh2, bl);
        if (zzas.zzf(zzajh2)) {
            object = new zzac(this);
            object2 = zzajh2;
            if (object2 != null && zzas.zzf((zzajh)object2)) {
                zzaqw2 = ((zzajh)object2).zzbyo;
                View view = zzaqw2 != null ? zzaqw2.getView() : null;
                if (view == null) {
                    zzakb.zzdk((String)"AdWebView is null");
                    return;
                }
                try {
                    zzyc zzyc2;
                    List<String> list = ((zzajh)object2).zzbtw != null ? ((zzajh)object2).zzbtw.zzbsi : null;
                    if (list == null || list.isEmpty()) {
                        zzakb.zzdk((String)"No template ids present in mediation response");
                        return;
                    }
                    zzxz zzxz2 = ((zzajh)object2).zzbtx != null ? ((zzajh)object2).zzbtx.zzmo() : null;
                    zzyc zzyc3 = zzyc2 = ((zzajh)object2).zzbtx != null ? ((zzajh)object2).zzbtx.zzmp() : null;
                    if (list.contains("2") && zzxz2 != null) {
                        zzxz2.zzk(ObjectWrapper.wrap((Object)view));
                        if (!zzxz2.getOverrideImpressionRecording()) {
                            zzxz2.recordImpression();
                        }
                        zzaqw2.zza("/nativeExpressViewClicked", zzas.zza(zzxz2, null, (zzac)object));
                        return;
                    }
                    if (list.contains("1") && zzyc2 != null) {
                        zzyc2.zzk(ObjectWrapper.wrap((Object)view));
                        if (!zzyc2.getOverrideImpressionRecording()) {
                            zzyc2.recordImpression();
                        }
                        zzaqw2.zza("/nativeExpressViewClicked", zzas.zza(null, zzyc2, (zzac)object));
                        return;
                    }
                    zzakb.zzdk((String)"No matching template id and mapper");
                    return;
                }
                catch (RemoteException remoteException) {
                    zzakb.zzc((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                }
            }
        }
    }

    @VisibleForTesting
    final void zzd(@Nullable zzajh zzajh2) {
        if (zzajh2 == null) {
            return;
        }
        if (zzajh2.zzcoc) {
            return;
        }
        if (this.zzvw.zzacs == null || !zzbv.zzek().zza((View)this.zzvw.zzacs, this.zzvw.zzrt) || !this.zzvw.zzacs.getGlobalVisibleRect(new Rect(), null)) {
            return;
        }
        if (zzajh2 != null && zzajh2.zzbyo != null && zzajh2.zzbyo.zzuf() != null) {
            zzajh2.zzbyo.zzuf().zza((zzasg)null);
        }
        ((zzd)this).zza(zzajh2, false);
        zzajh2.zzcoc = true;
    }

    @Override
    @Nullable
    public final zzlo getVideoController() {
        Preconditions.checkMainThread((String)"getVideoController must be called from the main thread.");
        if (this.zzvw.zzacw != null && this.zzvw.zzacw.zzbyo != null) {
            return this.zzvw.zzacw.zzbyo.zztm();
        }
        return null;
    }

    @Override
    public final void zzcz() {
        this.zzvv.zzdy();
    }
}

