/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzbq;
import com.google.android.gms.ads.internal.zzbr;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzbu;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaaw;
import com.google.android.gms.internal.ads.zzabc;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzahe;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzaki;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzcj;
import com.google.android.gms.internal.ads.zzjj;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzke;
import com.google.android.gms.internal.ads.zzkh;
import com.google.android.gms.internal.ads.zzkt;
import com.google.android.gms.internal.ads.zzkx;
import com.google.android.gms.internal.ads.zzla;
import com.google.android.gms.internal.ads.zzlg;
import com.google.android.gms.internal.ads.zzlo;
import com.google.android.gms.internal.ads.zzlu;
import com.google.android.gms.internal.ads.zzmu;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzod;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzbp
extends zzkt {
    private final zzang zzyf;
    private final zzjn zzaau;
    private final Future<zzci> zzaav;
    private final Context mContext;
    private final zzbu zzaaw;
    @Nullable
    private WebView zzaax;
    @Nullable
    private zzkh zzxs;
    @Nullable
    private zzci zzaay;
    private AsyncTask<Void, Void, String> zzaaz;

    public zzbp(Context context, zzjn zzjn2, String string2, zzang zzang2) {
        this.mContext = context;
        this.zzyf = zzang2;
        this.zzaau = zzjn2;
        this.zzaax = new WebView(this.mContext);
        zzbp zzbp2 = this;
        this.zzaav = zzaki.zza(new zzbs(zzbp2));
        this.zzaaw = new zzbu(string2);
        zzbp2 = this;
        zzbp2.zzk(0);
        zzbp2.zzaax.setVerticalScrollBarEnabled(false);
        zzbp2.zzaax.getSettings().setJavaScriptEnabled(true);
        zzbp2.zzaax.setWebViewClient((WebViewClient)new zzbq(zzbp2));
        zzbp2.zzaax.setOnTouchListener((View.OnTouchListener)new zzbr(zzbp2));
    }

    public final IObjectWrapper zzbj() throws RemoteException {
        Preconditions.checkMainThread((String)"getAdFrame must be called on the main UI thread.");
        return ObjectWrapper.wrap((Object)this.zzaax);
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"destroy must be called on the main UI thread.");
        this.zzaaz.cancel(true);
        this.zzaav.cancel(true);
        this.zzaax.destroy();
        this.zzaax = null;
    }

    public final boolean isReady() throws RemoteException {
        return false;
    }

    public final boolean zzb(zzjj zzjj2) throws RemoteException {
        Preconditions.checkNotNull((Object)this.zzaax, (Object)"This Search Ad has already been torn down");
        this.zzaaw.zza(zzjj2, this.zzyf);
        this.zzaaz = new zzbt(this, null).execute(new Void[0]);
        return true;
    }

    public final void pause() throws RemoteException {
        Preconditions.checkMainThread((String)"pause must be called on the main UI thread.");
    }

    public final void resume() throws RemoteException {
        Preconditions.checkMainThread((String)"resume must be called on the main UI thread.");
    }

    public final void zza(zzkh zzkh2) throws RemoteException {
        this.zzxs = zzkh2;
    }

    public final void zza(zzla zzla2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzkx zzkx2) {
        throw new IllegalStateException("Unused method");
    }

    public final Bundle zzba() {
        throw new IllegalStateException("Unused method");
    }

    public final void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void stopLoading() throws RemoteException {
    }

    public final void zzbm() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final zzjn zzbk() throws RemoteException {
        return this.zzaau;
    }

    public final void zza(zzjn zzjn2) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public final void zza(zzaaw zzaaw2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzabc zzabc2, String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    @Nullable
    public final String zzck() throws RemoteException {
        return null;
    }

    public final String getAdUnitId() {
        throw new IllegalStateException("getAdUnitId not implemented");
    }

    public final zzla zzbw() {
        throw new IllegalStateException("getIAppEventListener not implemented");
    }

    public final zzkh zzbx() {
        throw new IllegalStateException("getIAdListener not implemented");
    }

    public final void zza(zzod zzod2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzke zzke2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzlg zzlg2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public final boolean isLoading() throws RemoteException {
        return false;
    }

    public final void zza(zzahe zzahe2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setUserId(String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final zzlo getVideoController() {
        return null;
    }

    public final void zza(zzmu zzmu2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzlu zzlu2) {
        throw new IllegalStateException("Unused method");
    }

    public final void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("Unused method");
    }

    @VisibleForTesting
    final int zzu(String string2) {
        String string3 = Uri.parse((String)string2).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        try {
            zzkb.zzif();
            return zzamu.zza((Context)this.mContext, (int)Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @VisibleForTesting
    final void zzk(int n) {
        if (this.zzaax == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzaax.setLayoutParams(layoutParams);
    }

    @VisibleForTesting
    final String zzea() {
        String string22;
        Uri.Builder builder = new Uri.Builder();
        zzna zzna2 = zznk.zzbcz;
        builder.scheme("https://").appendEncodedPath((String)zzkb.zzik().zzd(zzna2));
        builder.appendQueryParameter("query", this.zzaaw.getQuery());
        builder.appendQueryParameter("pubId", this.zzaaw.zzed());
        Map<String, String> map = this.zzaaw.zzee();
        for (String string22 : map.keySet()) {
            builder.appendQueryParameter(string22, map.get(string22));
        }
        Uri uri = builder.build();
        if (this.zzaay != null) {
            try {
                uri = this.zzaay.zza(uri, this.mContext);
            }
            catch (zzcj zzcj2) {
                zzakb.zzc((String)"Unable to process ad data", (Throwable)zzcj2);
            }
        }
        string22 = this.zzeb();
        String string3 = uri.getEncodedQuery();
        return new StringBuilder(1 + String.valueOf(string22).length() + String.valueOf(string3).length()).append(string22).append("#").append(string3).toString();
    }

    @VisibleForTesting
    final String zzeb() {
        String string2 = this.zzaaw.zzec();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "www.google.com";
        }
        String string3 = string2;
        zzna zzna2 = zznk.zzbcz;
        String string4 = (String)zzkb.zzik().zzd(zzna2);
        return new StringBuilder(8 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("https://").append(string3).append(string4).toString();
    }

    private final String zzv(String string2) {
        if (this.zzaay == null) {
            return string2;
        }
        Uri uri = Uri.parse((String)string2);
        try {
            Context context = this.mContext;
            Uri uri2 = uri;
            Context context2 = context;
            Uri uri3 = uri2;
            uri = this.zzaay.zza(uri2, context2, null, null);
        }
        catch (zzcj zzcj2) {
            zzakb.zzc((String)"Unable to process ad data", (Throwable)zzcj2);
        }
        return uri.toString();
    }

    private final void zzw(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        this.mContext.startActivity(intent);
    }

    static /* synthetic */ zzkh zza(zzbp zzbp2) {
        return zzbp2.zzxs;
    }

    static /* synthetic */ String zza(zzbp zzbp2, String string2) {
        return zzbp2.zzv(string2);
    }

    static /* synthetic */ void zzb(zzbp zzbp2, String string2) {
        zzbp2.zzw(string2);
    }

    static /* synthetic */ zzci zzb(zzbp zzbp2) {
        return zzbp2.zzaay;
    }

    static /* synthetic */ zzang zzc(zzbp zzbp2) {
        return zzbp2.zzyf;
    }

    static /* synthetic */ Context zzd(zzbp zzbp2) {
        return zzbp2.mContext;
    }

    static /* synthetic */ zzci zza(zzbp zzbp2, zzci zzci2) {
        zzbp2.zzaay = zzci2;
        return zzbp2.zzaay;
    }

    static /* synthetic */ Future zze(zzbp zzbp2) {
        return zzbp2.zzaav;
    }

    static /* synthetic */ WebView zzf(zzbp zzbp2) {
        return zzbp2.zzaax;
    }
}

