/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.zzac;
import com.google.android.gms.ads.internal.zzat;
import com.google.android.gms.ads.internal.zzau;
import com.google.android.gms.ads.internal.zzav;
import com.google.android.gms.ads.internal.zzaw;
import com.google.android.gms.ads.internal.zzax;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzajh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzoo;
import com.google.android.gms.internal.ads.zzoq;
import com.google.android.gms.internal.ads.zzpw;
import com.google.android.gms.internal.ads.zzpx;
import com.google.android.gms.internal.ads.zzxe;
import com.google.android.gms.internal.ads.zzxz;
import com.google.android.gms.internal.ads.zzyc;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
public final class zzas {
    @Nullable
    public static View zze(@Nullable zzajh zzajh2) {
        if (zzajh2 == null) {
            zzakb.e((String)"AdState is null");
            return null;
        }
        if (zzas.zzf(zzajh2) && zzajh2.zzbyo != null) {
            return zzajh2.zzbyo.getView();
        }
        try {
            IObjectWrapper iObjectWrapper = zzajh2.zzbtx != null ? zzajh2.zzbtx.getView() : null;
            if (iObjectWrapper == null) {
                zzakb.zzdk((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzakb.zzc((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean zza(zzaqw var0, zzxe var1_1, CountDownLatch var2_2) {
        var3_3 = false;
        try {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            var7_4 = var2_2;
                            var6_5 = var1_1;
                            var5_6 = var0;
                            var8_7 = var5_6.getView();
                            if (var8_7 != null) break block8;
                            zzakb.zzdk((String)"AdWebView is null");
                            v0 = false;
                            break block9;
                        }
                        var8_7.setVisibility(4);
                        var9_8 = var6_5.zzbtw.zzbsi;
                        if (var9_8 != null && !var9_8.isEmpty()) break block10;
                        zzakb.zzdk((String)"No template ids present in mediation response");
                        v0 = false;
                        break block9;
                    }
                    var15_9 = var7_4;
                    var14_10 = var5_6;
                    var16_11 = var15_9;
                    var14_10.zza("/nativeExpressAssetsLoaded", new zzav((CountDownLatch)var16_11));
                    var16_11 = var15_9;
                    var14_10.zza("/nativeExpressAssetsLoadingFailed", new zzaw((CountDownLatch)var16_11));
                    var10_12 = var6_5.zzbtx.zzmo();
                    var11_13 = var6_5.zzbtx.zzmp();
                    if (!var9_8.contains("2") || var10_12 == null) break block11;
                    var14_10 = var10_12;
                    var12_14 = new zzoo(var14_10.getHeadline(), var14_10.getImages(), var14_10.getBody(), var14_10.zzjz(), var14_10.getCallToAction(), var14_10.getStarRating(), var14_10.getStore(), var14_10.getPrice(), null, var14_10.getExtras(), null, var14_10.zzmw() != null ? (View)ObjectWrapper.unwrap((IObjectWrapper)var14_10.zzmw()) : null, var14_10.zzke(), null);
                    var16_11 = var6_5.zzbtw.zzbsh;
                    var15_9 = var12_14;
                    var14_10 = var5_6;
                    var14_10.zzuf().zza(new zzat((zzoo)var15_9, (String)var16_11, var14_10));
                    ** GOTO lbl46
                }
                if (!var9_8.contains("1") || var11_13 == null) {
                    zzakb.zzdk((String)"No matching template id and mapper");
                    v0 = false;
                } else {
                    var14_10 = var11_13;
                    var12_14 = new zzoq(var14_10.getHeadline(), var14_10.getImages(), var14_10.getBody(), var14_10.zzkg(), var14_10.getCallToAction(), var14_10.getAdvertiser(), null, var14_10.getExtras(), null, var14_10.zzmw() != null ? (View)ObjectWrapper.unwrap((IObjectWrapper)var14_10.zzmw()) : null, var14_10.zzke(), null);
                    var16_11 = var6_5.zzbtw.zzbsh;
                    var15_9 = var12_14;
                    var14_10 = var5_6;
                    var14_10.zzuf().zza(new zzau((zzoq)var15_9, (String)var16_11, var14_10));
lbl46:
                    // 2 sources

                    var12_14 = var6_5.zzbtw.zzbsf;
                    var13_15 = var6_5.zzbtw.zzbsg;
                    if (var13_15 != null) {
                        var5_6.loadDataWithBaseURL(var13_15, (String)var12_14, "text/html", "UTF-8", null);
                    } else {
                        var5_6.loadData((String)var12_14, "text/html", "UTF-8");
                    }
                    v0 = true;
                }
            }
            var3_3 = v0;
        }
        catch (RemoteException var4_16) {
            zzakb.zzc((String)"Unable to invoke load assets", (Throwable)var4_16);
        }
        catch (RuntimeException var4_17) {
            var2_2.countDown();
            throw var4_17;
        }
        if (!var3_3) {
            var2_2.countDown();
        }
        return var3_3;
    }

    public static boolean zzf(@Nullable zzajh zzajh2) {
        return zzajh2 != null && zzajh2.zzceq && zzajh2.zzbtw != null && zzajh2.zzbtw.zzbsf != null;
    }

    @VisibleForTesting
    static zzv<zzaqw> zza(@Nullable zzxz zzxz2, @Nullable zzyc zzyc2, zzac zzac2) {
        return new zzax(zzxz2, zzac2, zzyc2);
    }

    private static void zzd(zzaqw zzaqw2) {
        View.OnClickListener onClickListener = zzaqw2.getOnClickListener();
        if (onClickListener != null) {
            onClickListener.onClick(zzaqw2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                Object object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzas.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzakb.zzdk((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            if (bundle.get(string3) instanceof Bitmap) {
                zzakb.zzdk((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    @VisibleForTesting
    private static String zza(@Nullable zzpw zzpw2) {
        if (zzpw2 == null) {
            zzakb.zzdk((String)"Image is null. Returning empty string");
            return "";
        }
        try {
            Uri uri = zzpw2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzdk((String)"Unable to get image uri. Trying data uri next");
        }
        return zzas.zzb(zzpw2);
    }

    private static String zzb(zzpw zzpw2) {
        Drawable drawable2;
        try {
            IObjectWrapper iObjectWrapper = zzpw2.zzjy();
            if (iObjectWrapper == null) {
                zzakb.zzdk((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzakb.zzdk((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzakb.zzdk((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        return zzas.zza(((BitmapDrawable)drawable2).getBitmap());
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzakb.zzdk((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        String string2 = Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Nullable
    private static zzpw zzd(Object object) {
        if (object instanceof IBinder) {
            return zzpx.zzh((IBinder)((IBinder)object));
        }
        return null;
    }

    static final /* synthetic */ void zza(zzoq zzoq2, String string2, zzaqw zzaqw2, boolean bl) {
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("headline", (Object)zzoq2.getHeadline());
            jSONObject2.put("body", (Object)zzoq2.getBody());
            jSONObject2.put("call_to_action", (Object)zzoq2.getCallToAction());
            jSONObject2.put("advertiser", (Object)zzoq2.getAdvertiser());
            jSONObject2.put("logo", (Object)zzas.zza(zzoq2.zzkg()));
            JSONArray jSONArray = new JSONArray();
            List list = zzoq2.getImages();
            if (list != null) {
                jSONObject = list.iterator();
                while (jSONObject.hasNext()) {
                    zzpw zzpw2 = zzas.zzd(jSONObject.next());
                    jSONArray.put((Object)zzas.zza(zzpw2));
                }
            }
            jSONObject2.put("images", (Object)jSONArray);
            jSONObject2.put("extras", (Object)zzas.zza(zzoq2.getExtras(), string2));
            jSONObject = new JSONObject();
            jSONObject.put("assets", (Object)jSONObject2);
            jSONObject.put("template_id", (Object)"1");
            zzaqw2.zzb("google.afma.nativeExpressAds.loadAssets", jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
            return;
        }
    }

    static final /* synthetic */ void zza(zzoo zzoo2, String string2, zzaqw zzaqw2, boolean bl) {
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("headline", (Object)zzoo2.getHeadline());
            jSONObject2.put("body", (Object)zzoo2.getBody());
            jSONObject2.put("call_to_action", (Object)zzoo2.getCallToAction());
            jSONObject2.put("price", (Object)zzoo2.getPrice());
            jSONObject2.put("star_rating", (Object)String.valueOf(zzoo2.getStarRating()));
            jSONObject2.put("store", (Object)zzoo2.getStore());
            jSONObject2.put("icon", (Object)zzas.zza(zzoo2.zzjz()));
            JSONArray jSONArray = new JSONArray();
            List list = zzoo2.getImages();
            if (list != null) {
                jSONObject = list.iterator();
                while (jSONObject.hasNext()) {
                    zzpw zzpw2 = zzas.zzd(jSONObject.next());
                    jSONArray.put((Object)zzas.zza(zzpw2));
                }
            }
            jSONObject2.put("images", (Object)jSONArray);
            jSONObject2.put("extras", (Object)zzas.zza(zzoo2.getExtras(), string2));
            jSONObject = new JSONObject();
            jSONObject.put("assets", (Object)jSONObject2);
            jSONObject.put("template_id", (Object)"2");
            zzaqw2.zzb("google.afma.nativeExpressAds.loadAssets", jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
            return;
        }
    }

    static /* synthetic */ void zze(zzaqw zzaqw2) {
        zzas.zzd(zzaqw2);
    }
}

