/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzai;
import com.google.android.gms.ads.internal.zzaj;
import com.google.android.gms.ads.internal.zzbc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzjj;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkh;
import com.google.android.gms.internal.ads.zzkl;
import com.google.android.gms.internal.ads.zzlg;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzpl;
import com.google.android.gms.internal.ads.zzqw;
import com.google.android.gms.internal.ads.zzqz;
import com.google.android.gms.internal.ads.zzrc;
import com.google.android.gms.internal.ads.zzrf;
import com.google.android.gms.internal.ads.zzri;
import com.google.android.gms.internal.ads.zzrl;
import com.google.android.gms.internal.ads.zzxn;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzah
extends zzkl {
    private final Context mContext;
    private final zzkh zzxs;
    private final zzxn zzwh;
    @Nullable
    private final zzqw zzxt;
    @Nullable
    private final zzrl zzxu;
    @Nullable
    private final zzqz zzxv;
    @Nullable
    private final zzri zzxw;
    @Nullable
    private final zzjn zzxx;
    @Nullable
    private final PublisherAdViewOptions zzxy;
    private final SimpleArrayMap<String, zzrf> zzxz;
    private final SimpleArrayMap<String, zzrc> zzya;
    private final zzpl zzyb;
    private final List<String> zzyc;
    private final zzlg zzyd;
    private final String zzye;
    private final zzang zzyf;
    @Nullable
    private WeakReference<zzd> zzyg;
    private final zzw zzwc;
    private final Object mLock = new Object();

    zzah(Context context, String string2, zzxn zzxn2, zzang zzang2, zzkh zzkh2, zzqw zzqw2, zzrl zzrl2, zzqz zzqz2, SimpleArrayMap<String, zzrf> simpleArrayMap, SimpleArrayMap<String, zzrc> simpleArrayMap2, zzpl zzpl2, zzlg zzlg2, zzw zzw2, zzri zzri2, zzjn zzjn2, PublisherAdViewOptions publisherAdViewOptions) {
        this.mContext = context;
        this.zzye = string2;
        this.zzwh = zzxn2;
        this.zzyf = zzang2;
        this.zzxs = zzkh2;
        this.zzxv = zzqz2;
        this.zzxt = zzqw2;
        this.zzxu = zzrl2;
        this.zzxz = simpleArrayMap;
        this.zzya = simpleArrayMap2;
        this.zzyb = zzpl2;
        this.zzyc = this.zzdg();
        this.zzyd = zzlg2;
        this.zzwc = zzw2;
        this.zzxw = zzri2;
        this.zzxx = zzjn2;
        this.zzxy = publisherAdViewOptions;
        zznk.initialize((Context)this.mContext);
    }

    public final void zzd(zzjj zzjj2) {
        zzah.runOnUiThread(new zzai(this, zzjj2));
    }

    public final void zza(zzjj zzjj2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of ads has to be more than 0");
        }
        zzah.runOnUiThread(new zzaj(this, zzjj2, n));
    }

    private final void zzi(int n) {
        if (this.zzxs != null) {
            try {
                this.zzxs.onAdFailedToLoad(0);
                return;
            }
            catch (RemoteException remoteException) {
                zzakb.zzc((String)"Failed calling onAdFailedToLoad.", (Throwable)remoteException);
            }
        }
    }

    private final void zze(zzjj zzjj2) {
        Object object = zznk.zzbcg;
        if (!((Boolean)zzkb.zzik().zzd(object)).booleanValue() && this.zzxu != null) {
            this.zzi(0);
            return;
        }
        object = this;
        zzq zzq2 = new zzq(object.mContext, object.zzwc, object.zzxx, object.zzye, object.zzwh, object.zzyf);
        this.zzyg = new WeakReference<zzq>(zzq2);
        Object object2 = this.zzxw;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnPublisherAdViewLoadedListener must be called on the main UI thread.");
        object.zzvw.zzadm = object2;
        if (this.zzxy != null) {
            if (this.zzxy.zzbg() != null) {
                zzq2.zza(this.zzxy.zzbg());
            }
            ((zza)zzq2).setManualImpressionsEnabled(this.zzxy.getManualImpressionsEnabled());
        }
        object2 = this.zzxt;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnAppInstallAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzade = object2;
        object2 = this.zzxu;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnUnifiedNativeAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzadg = object2;
        object2 = this.zzxv;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnContentAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzadf = object2;
        object2 = this.zzxz;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnCustomTemplateAdLoadedListeners must be called on the main UI thread.");
        object.zzvw.zzadi = object2;
        object2 = this.zzya;
        object = zzq2;
        Preconditions.checkMainThread((String)"setOnCustomClickListener must be called on the main UI thread.");
        object.zzvw.zzadh = object2;
        object2 = this.zzyb;
        object = zzq2;
        Preconditions.checkMainThread((String)"setNativeAdOptions must be called on the main UI thread.");
        object.zzvw.zzadj = object2;
        zzq2.zzd(this.zzdg());
        zzq2.zza(this.zzxs);
        zzq2.zza(this.zzyd);
        object = this;
        object2 = new ArrayList();
        if (super.zzdf()) {
            object2.add(1);
        }
        if (object.zzxw != null) {
            object2.add(2);
        }
        zzq2.zze((List<Integer>)object2);
        object2 = zzjj2;
        object = this;
        if (object.zzdf()) {
            ((zzjj)object2).extras.putBoolean("ina", true);
        }
        if (object.zzxw != null) {
            ((zzjj)object2).extras.putBoolean("iba", true);
        }
        ((zza)zzq2).zzb(zzjj2);
    }

    private final void zzb(zzjj zzjj2, int n) {
        Object object = zznk.zzbcg;
        if (!((Boolean)zzkb.zzik().zzd(object)).booleanValue() && this.zzxu != null) {
            this.zzi(0);
            return;
        }
        object = this;
        zzbc zzbc2 = new zzbc(object.mContext, object.zzwc, zzjn.zzf((Context)object.mContext), object.zzye, object.zzwh, object.zzyf);
        this.zzyg = new WeakReference<zzbc>(zzbc2);
        zzpl zzpl2 = this.zzxt;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setOnAppInstallAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzade = zzpl2;
        zzpl2 = this.zzxu;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setOnUnifiedNativeAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzadg = zzpl2;
        zzpl2 = this.zzxv;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setOnContentAdLoadedListener must be called on the main UI thread.");
        object.zzvw.zzadf = zzpl2;
        zzpl2 = this.zzxz;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setOnCustomTemplateAdLoadedListeners must be called on the main UI thread.");
        object.zzvw.zzadi = zzpl2;
        zzbc2.zza(this.zzxs);
        zzpl2 = this.zzya;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setOnCustomClickListener must be called on the main UI thread.");
        object.zzvw.zzadh = zzpl2;
        zzbc2.zzd(this.zzdg());
        zzpl2 = this.zzyb;
        object = zzbc2;
        Preconditions.checkMainThread((String)"setNativeAdOptions must be called on the main UI thread.");
        object.zzvw.zzadj = zzpl2;
        zzbc2.zza(this.zzyd);
        zzbc2.zzj(n);
        zzbc2.zzb(zzjj2);
    }

    private final boolean zzde() {
        zzna zzna2 = zznk.zzaym;
        return (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzxw != null;
    }

    private final boolean zzdf() {
        return this.zzxt != null || this.zzxv != null || this.zzxu != null || this.zzxz != null && this.zzxz.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getMediationAdapterClassName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzyg != null) {
                zzd zzd2 = (zzd)this.zzyg.get();
                String string2 = zzd2 != null ? zzd2.getMediationAdapterClassName() : null;
                return string2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzck() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzyg != null) {
                zzd zzd2 = (zzd)this.zzyg.get();
                String string2 = zzd2 != null ? zzd2.zzck() : null;
                return string2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLoading() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzyg != null) {
                zzd zzd2 = (zzd)this.zzyg.get();
                boolean bl = zzd2 != null ? zzd2.isLoading() : false;
                return bl;
            }
            return false;
        }
    }

    private final List<String> zzdg() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.zzxv != null) {
            arrayList.add("1");
        }
        if (this.zzxt != null) {
            arrayList.add("2");
        }
        if (this.zzxu != null) {
            arrayList.add("6");
        }
        if (this.zzxz.size() > 0) {
            arrayList.add("3");
        }
        return arrayList;
    }

    private static void runOnUiThread(Runnable runnable) {
        zzakk.zzcrm.post(runnable);
    }

    static /* synthetic */ Object zza(zzah zzah2) {
        return zzah2.mLock;
    }

    static /* synthetic */ boolean zzb(zzah zzah2) {
        return zzah2.zzde();
    }

    static /* synthetic */ void zza(zzah zzah2, zzjj zzjj2) {
        zzah2.zze(zzjj2);
    }

    static /* synthetic */ void zza(zzah zzah2, zzjj zzjj2, int n) {
        zzah2.zzb(zzjj2, n);
    }
}

