/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzae;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzajl;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzanm;
import com.google.android.gms.internal.ads.zzano;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzwf;
import com.google.android.gms.internal.ads.zzwk;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
public final class zzad {
    private final Object mLock = new Object();
    private Context mContext;
    private long zzxm = 0L;

    public final void zza(Context context, zzang zzang2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzang2, true, null, string2, null, runnable);
    }

    @VisibleForTesting
    final void zza(Context context, zzang zzang2, boolean bl, @Nullable zzajl zzajl2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzbv.zzer().elapsedRealtime() - this.zzxm < 5000L) {
            zzakb.zzdk((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzxm = zzbv.zzer().elapsedRealtime();
        zzajl zzajl3 = zzajl2;
        if (zzajl3 == null) {
            bl2 = true;
        } else {
            long l = zzajl3.zzps();
            zzna zzna2 = zznk.zzbcu;
            bl2 = zzbv.zzer().currentTimeMillis() - l > (Long)zzkb.zzik().zzd(zzna2) || !zzajl3.zzpt();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzakb.zzdk((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzakb.zzdk((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.mContext = context2 != null ? context2 : context;
        zzwf<JSONObject, JSONObject> zzwf2 = zzbv.zzey().zzb(this.mContext, zzang2).zza("google.afma.config.fetchAppSettings", zzwk.zzbrc, zzwk.zzbrc);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzanz<JSONObject> zzanz2 = zzwf2.zzf(jSONObject);
            zzanz zzanz3 = zzano.zza(zzanz2, zzae.zzxn, zzaoe.zzcvz);
            if (runnable != null) {
                zzanz2.zza(runnable, zzaoe.zzcvz);
            }
            zzanm.zza(zzanz3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

