/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzaaq;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzakq;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzarc;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.util.Collections;

@zzadh
public class zzd
extends zzaaq
implements zzw {
    @VisibleForTesting
    private static final int zzbxm = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity mActivity;
    @VisibleForTesting
    AdOverlayInfoParcel zzbxn;
    @VisibleForTesting
    zzaqw zzbnd;
    @VisibleForTesting
    private zzi zzbxo;
    @VisibleForTesting
    private zzo zzbxp;
    @VisibleForTesting
    private boolean zzbxq = false;
    @VisibleForTesting
    private FrameLayout zzbxr;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzbxs;
    @VisibleForTesting
    private boolean zzbxt = false;
    @VisibleForTesting
    private boolean zzbxu = false;
    @VisibleForTesting
    private zzh zzbxv;
    @VisibleForTesting
    private boolean zzbxw = false;
    @VisibleForTesting
    int zzbxx = 0;
    private final Object zzbxy = new Object();
    private Runnable zzbxz;
    private boolean zzbya;
    private boolean zzbyb;
    private boolean zzbyc = false;
    private boolean zzbyd = false;
    private boolean zzbye = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzbxx = 2;
        this.mActivity.finish();
    }

    public final void zznh() {
        if (this.zzbxn != null && this.zzbxq) {
            this.setRequestedOrientation(this.zzbxn.orientation);
        }
        if (this.zzbxr != null) {
            this.mActivity.setContentView((View)this.zzbxv);
            this.zzbyb = true;
            this.zzbxr.removeAllViews();
            this.zzbxr = null;
        }
        if (this.zzbxs != null) {
            this.zzbxs.onCustomViewHidden();
            this.zzbxs = null;
        }
        this.zzbxq = false;
    }

    @Override
    public final void zzni() {
        this.zzbxx = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzbxx = 0;
    }

    public final boolean zznj() {
        this.zzbxx = 0;
        if (this.zzbnd == null) {
            return true;
        }
        boolean bl = this.zzbnd.zzul();
        if (!bl) {
            this.zzbnd.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzbxt = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzbxn = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzbxn == null) {
                throw new zzg("Could not get info for ad overlay.");
            }
            if (this.zzbxn.zzacr.zzcvf > 7500000) {
                this.zzbxx = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzbye = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzbxu = this.zzbxn.zzbyw != null ? this.zzbxn.zzbyw.zzze : false;
            zzna zzna2 = zznk.zzbbg;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && this.zzbxu && this.zzbxn.zzbyw.zzzj != -1) {
                new zzj(this, null).zzqo();
            }
            if (bundle == null) {
                if (this.zzbxn.zzbyn != null && this.zzbye) {
                    this.zzbxn.zzbyn.zzcc();
                }
                if (this.zzbxn.zzbyu != 1 && this.zzbxn.zzbym != null) {
                    this.zzbxn.zzbym.onAdClicked();
                }
            }
            this.zzbxv = new zzh((Context)this.mActivity, this.zzbxn.zzbyv, this.zzbxn.zzacr.zzcw);
            this.zzbxv.setId(1000);
            switch (this.zzbxn.zzbyu) {
                case 1: {
                    this.zzt(false);
                    return;
                }
                case 2: {
                    this.zzbxo = new zzi(this.zzbxn.zzbyo);
                    this.zzt(false);
                    return;
                }
                case 3: {
                    this.zzt(true);
                    return;
                }
            }
            throw new zzg("Could not determine ad overlay type.");
        }
        catch (zzg zzg2) {
            zzakb.zzdk((String)zzg2.getMessage());
            this.zzbxx = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzna zzna2 = zznk.zzbem;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            if (this.zzbnd != null && !this.zzbnd.isDestroyed()) {
                zzbv.zzem();
                zzakq.zzj(this.zzbnd);
                return;
            }
            zzakb.zzdk((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzbxn.zzbyn != null) {
            this.zzbxn.zzbyn.onResume();
        }
        zzna zzna2 = zznk.zzbem;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            if (this.zzbnd != null && !this.zzbnd.isDestroyed()) {
                zzbv.zzem();
                zzakq.zzj(this.zzbnd);
                return;
            }
            zzakb.zzdk((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zznh();
        if (this.zzbxn.zzbyn != null) {
            this.zzbxn.zzbyn.onPause();
        }
        zzna zzna2 = zznk.zzbem;
        if (!(((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() || this.zzbnd == null || this.mActivity.isFinishing() && this.zzbxo != null)) {
            zzbv.zzem();
            zzakq.zzi(this.zzbnd);
        }
        this.zznl();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzo(IObjectWrapper iObjectWrapper) {
        zzna zzna2 = zznk.zzbel;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && PlatformVersion.isAtLeastN()) {
            Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            zzbv.zzek();
            if (zzakk.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzbxt);
    }

    public final void onStop() {
        zzna zzna2 = zznk.zzbem;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && this.zzbnd != null && (!this.mActivity.isFinishing() || this.zzbxo == null)) {
            zzbv.zzem();
            zzakq.zzi(this.zzbnd);
        }
        this.zznl();
    }

    public final void onDestroy() {
        if (this.zzbnd != null) {
            this.zzbxv.removeView(this.zzbnd.getView());
        }
        this.zznl();
    }

    private final void zzs(boolean bl) {
        zzna zzna2 = zznk.zzben;
        int n = (Integer)zzkb.zzik().zzd(zzna2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        this.zzbxp = new zzo((Context)this.mActivity, zzp2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzbxn.zzbyr);
        this.zzbxv.addView((View)this.zzbxp, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzax() {
        this.zzbyb = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzna zzna2 = zznk.zzays;
        boolean bl4 = (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzbxn != null && this.zzbxn.zzbyw != null && this.zzbxn.zzbyw.zzzl;
        zzna2 = zznk.zzayt;
        boolean bl5 = bl3 = (Boolean)zzkb.zzik().zzd(zzna2) != false && this.zzbxn != null && this.zzbxn.zzbyw != null && this.zzbxn.zzbyw.zzzm;
        if (bl && bl2 && bl4 && !bl3) {
            new zzaal(this.zzbnd, "useCustomClose").zzbw("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzbxp != null) {
            this.zzbxp.zzu(bl3 || bl2 && !bl4);
        }
    }

    public final void zznk() {
        this.zzbxv.removeView((View)this.zzbxp);
        this.zzs(true);
    }

    public final void setRequestedOrientation(int n) {
        zzna zzna2 = zznk.zzbfs;
        if (this.mActivity.getApplicationInfo().targetSdkVersion >= (Integer)zzkb.zzik().zzd(zzna2)) {
            zzna2 = zznk.zzbft;
            if (this.mActivity.getApplicationInfo().targetSdkVersion <= (Integer)zzkb.zzik().zzd(zzna2)) {
                zzna2 = zznk.zzbfu;
                if (Build.VERSION.SDK_INT >= (Integer)zzkb.zzik().zzd(zzna2)) {
                    zzna2 = zznk.zzbfv;
                    if (Build.VERSION.SDK_INT <= (Integer)zzkb.zzik().zzd(zzna2)) {
                        return;
                    }
                }
            }
        }
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzbxr = new FrameLayout((Context)this.mActivity);
        this.zzbxr.setBackgroundColor(-16777216);
        this.zzbxr.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzbxr);
        this.zzbyb = true;
        this.zzbxs = customViewCallback;
        this.zzbxq = true;
    }

    private final void zzt(boolean bl) throws zzg {
        boolean bl2;
        zzna zzna2;
        Window window;
        if (!this.zzbyb) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzg("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (PlatformVersion.isAtLeastN()) {
            zzna2 = zznk.zzbel;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                zzbv.zzek();
                bl3 = zzakk.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzbxn.zzbyw != null && this.zzbxn.zzbyw.zzzf;
        if ((!this.zzbxu || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzna2 = zznk.zzayr;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && PlatformVersion.isAtLeastKitKat() && this.zzbxn.zzbyw != null && this.zzbxn.zzbyw.zzzk) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        zzasc zzasc2 = this.zzbxn.zzbyo != null ? this.zzbxn.zzbyo.zzuf() : null;
        boolean bl5 = zzasc2 != null ? zzasc2.zzfz() : false;
        this.zzbxw = false;
        if (bl5) {
            if (this.zzbxn.orientation == zzbv.zzem().zzrl()) {
                this.zzbxw = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzbxn.orientation == zzbv.zzem().zzrm()) {
                this.zzbxw = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzbxw;
        zzakb.zzck((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzbxn.orientation);
        if (zzbv.zzem().zza(window)) {
            zzakb.zzck((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzbxu) {
            this.zzbxv.setBackgroundColor(-16777216);
        } else {
            this.zzbxv.setBackgroundColor(zzbxm);
        }
        this.mActivity.setContentView((View)this.zzbxv);
        this.zzbyb = true;
        if (bl) {
            try {
                zzbv.zzel();
                this.zzbnd = zzarc.zza((Context)this.mActivity, this.zzbxn.zzbyo != null ? this.zzbxn.zzbyo.zzud() : null, this.zzbxn.zzbyo != null ? this.zzbxn.zzbyo.zzue() : null, true, bl5, null, this.zzbxn.zzacr, null, null, this.zzbxn.zzbyo != null ? this.zzbxn.zzbyo.zzbi() : null, zzhs.zzhm());
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzg("Could not obtain webview for the overlay.");
            }
            this.zzbnd.zzuf().zza(null, this.zzbxn.zzbyx, null, this.zzbxn.zzbyp, this.zzbxn.zzbyt, true, null, this.zzbxn.zzbyo != null ? this.zzbxn.zzbyo.zzuf().zzut() : null, null, null);
            this.zzbnd.zzuf().zza(new zze(this));
            if (this.zzbxn.url != null) {
                this.zzbnd.loadUrl(this.zzbxn.url);
            } else if (this.zzbxn.zzbys != null) {
                this.zzbnd.loadDataWithBaseURL(this.zzbxn.zzbyq, this.zzbxn.zzbys, "text/html", "UTF-8", null);
            } else {
                throw new zzg("No URL or HTML to display in ad overlay.");
            }
            if (this.zzbxn.zzbyo != null) {
                this.zzbxn.zzbyo.zzb(this);
            }
        } else {
            this.zzbnd = this.zzbxn.zzbyo;
            this.zzbnd.zzbm((Context)this.mActivity);
        }
        this.zzbnd.zza(this);
        ViewParent viewParent = this.zzbnd.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbnd.getView());
        }
        if (this.zzbxu) {
            this.zzbnd.zzur();
        }
        this.zzbxv.addView(this.zzbnd.getView(), -1, -1);
        if (!bl && !this.zzbxw) {
            this.zzno();
        }
        this.zzs(bl5);
        if (this.zzbnd.zzuh()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zznl() {
        if (!this.mActivity.isFinishing() || this.zzbyc) {
            return;
        }
        this.zzbyc = true;
        if (this.zzbnd != null) {
            int n = this.zzbxx;
            this.zzbnd.zzai(n);
            Object object = this.zzbxy;
            synchronized (object) {
                if (!this.zzbya && this.zzbnd.zzun()) {
                    this.zzbxz = new zzf(this);
                    zzna zzna2 = zznk.zzayq;
                    zzakk.zzcrm.postDelayed(this.zzbxz, ((Long)zzkb.zzik().zzd(zzna2)).longValue());
                    return;
                }
            }
        }
        this.zznm();
    }

    @VisibleForTesting
    final void zznm() {
        if (this.zzbyd) {
            return;
        }
        this.zzbyd = true;
        if (this.zzbnd != null) {
            this.zzbxv.removeView(this.zzbnd.getView());
            if (this.zzbxo != null) {
                this.zzbnd.zzbm(this.zzbxo.zzrt);
                this.zzbnd.zzai(false);
                this.zzbxo.parent.addView(this.zzbnd.getView(), this.zzbxo.index, this.zzbxo.zzbyi);
                this.zzbxo = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbnd.zzbm(this.mActivity.getApplicationContext());
            }
            this.zzbnd = null;
        }
        if (this.zzbxn != null && this.zzbxn.zzbyn != null) {
            this.zzbxn.zzbyn.zzcb();
        }
    }

    public final void zznn() {
        if (this.zzbxw) {
            this.zzbxw = false;
            this.zzno();
        }
    }

    private final void zzno() {
        this.zzbnd.zzno();
    }

    public final void zznp() {
        this.zzbxv.zzbyh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zznq() {
        Object object = this.zzbxy;
        synchronized (object) {
            this.zzbya = true;
            if (this.zzbxz != null) {
                zzakk.zzcrm.removeCallbacks(this.zzbxz);
                zzakk.zzcrm.post(this.zzbxz);
            }
            return;
        }
    }
}

