/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaeb;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzuu;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzabh
@Hide
public final class zzuo {
    private final Map<zzup, zzuq> zzcdz = new HashMap<zzup, zzuq>();
    private final LinkedList<zzup> zzcea = new LinkedList();
    @Nullable
    private zztk zzceb;

    final void zza(zztk zztk2) {
        if (this.zzceb == null) {
            this.zzceb = zztk2.zzlf();
            zzuo zzuo2 = this;
            if (zzuo2.zzceb != null) {
                SharedPreferences sharedPreferences = zzuo2.zzceb.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zzuo zzuo3 = zzuo2;
                while (zzuo3.zzcea.size() > 0) {
                    zzup zzup2 = zzuo3.zzcea.remove();
                    zzuq zzuq2 = zzuo3.zzcdz.get(zzup2);
                    zzuo.zza("Flushing interstitial queue for %s.", zzup2);
                    while (zzuq2.size() > 0) {
                        zzuq2.zzl(null).zzceg.zzdk();
                    }
                    zzuo3.zzcdz.remove(zzup2);
                }
                try {
                    zzup zzup2;
                    HashMap<String, zzup> hashMap = new HashMap<String, zzup>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzuu zzuu2 = zzuu.zzba((String)stringArray.getValue());
                        zzup2 = new zzup(zzuu2.zzarx, zzuu2.zzapp, zzuu2.zzcee);
                        if (zzuo2.zzcdz.containsKey(zzup2)) continue;
                        zzuq zzuq2 = new zzuq(zzuu2.zzarx, zzuu2.zzapp, zzuu2.zzcee);
                        zzuo2.zzcdz.put(zzup2, zzuq2);
                        hashMap.put(zzup2.toString(), zzup2);
                        zzuo.zza("Restored interstitial queue for %s.", zzup2);
                    }
                    for (String string2 : zzuo.zzax(sharedPreferences.getString("PoolKeys", ""))) {
                        zzup2 = (zzup)hashMap.get(string2);
                        if (!zzuo2.zzcdz.containsKey(zzup2)) continue;
                        zzuo2.zzcea.add(zzup2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbt.zzep().zza(exception, "InterstitialAdPool.restore");
                    zzahw.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zzuo2.zzcdz.clear();
                    zzuo2.zzcea.clear();
                }
            }
        }
    }

    @Nullable
    final zzur zza(zzkk zzkk2, String string2) {
        Object object;
        Object object2;
        zzny zzny2;
        String string3;
        if (zzuo.zzay(string2)) {
            return null;
        }
        Context context = this.zzceb.getApplicationContext();
        int n = new zzaeb((Context)context).zzom().zzcyo;
        zzkk zzkk3 = zzuo.zzj(zzkk2);
        zzup zzup2 = new zzup(zzkk3, string3 = zzuo.zzaz(string2), n);
        zzuq zzuq2 = this.zzcdz.get(zzup2);
        if (zzuq2 == null) {
            zzuo.zza("Interstitial pool created at %s.", zzup2);
            zzuq2 = new zzuq(zzkk3, string3, n);
            this.zzcdz.put(zzup2, zzuq2);
        }
        this.zzcea.remove(zzup2);
        this.zzcea.add(zzup2);
        zzuq2.zzll();
        while (true) {
            zzny2 = zzoi.zzbpv;
            if (this.zzcea.size() <= (Integer)zzlc.zzio().zzd(zzny2)) break;
            object2 = this.zzcea.remove();
            object = this.zzcdz.get(object2);
            zzuo.zza("Evicting interstitial queue for %s.", (zzup)object2);
            while (((zzuq)object).size() > 0) {
                zzur zzur2 = ((zzuq)object).zzl(null);
                if (zzur2.zzcek) {
                    zzus.zzln().zzlp();
                }
                zzur2.zzceg.zzdk();
            }
            this.zzcdz.remove(object2);
        }
        while (zzuq2.size() > 0) {
            object2 = zzuq2.zzl(zzkk3);
            if (((zzur)object2).zzcek) {
                zzny2 = zzoi.zzbpx;
                if (zzbt.zzes().currentTimeMillis() - ((zzur)object2).zzcej > 1000L * (long)((Integer)zzlc.zzio().zzd(zzny2)).intValue()) {
                    zzuo.zza("Expired interstitial at %s.", zzup2);
                    zzus.zzln().zzlo();
                    continue;
                }
            }
            object = ((zzur)object2).zzceh != null ? " (inline) " : " ";
            zzuo.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zzup2);
            return object2;
        }
        return null;
    }

    final void zzb(zzkk zzkk2, String string2) {
        String string3;
        if (this.zzceb == null) {
            return;
        }
        Context context = this.zzceb.getApplicationContext();
        int n = new zzaeb((Context)context).zzom().zzcyo;
        zzkk zzkk3 = zzuo.zzj(zzkk2);
        zzup zzup2 = new zzup(zzkk3, string3 = zzuo.zzaz(string2), n);
        zzuq zzuq2 = this.zzcdz.get(zzup2);
        if (zzuq2 == null) {
            zzuo.zza("Interstitial pool created at %s.", zzup2);
            zzuq2 = new zzuq(zzkk3, string3, n);
            this.zzcdz.put(zzup2, zzuq2);
        }
        zzuq2.zza(this.zzceb, zzkk2);
        zzuq2.zzll();
        zzuo.zza("Inline entry added to the queue at %s.", zzup2);
    }

    final void zzlg() {
        zzuo zzuo2;
        if (this.zzceb == null) {
            return;
        }
        for (Map.Entry<zzup, zzuq> entry : this.zzcdz.entrySet()) {
            int n;
            zzup zzup2 = entry.getKey();
            zzuq zzuq2 = entry.getValue();
            if (zzahw.zzae((int)2)) {
                n = zzuq2.size();
                int n2 = zzuq2.zzlj();
                if (n2 < n) {
                    zzahw.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzup2));
                }
            }
            n = 0 + zzuq2.zzlk();
            while (true) {
                zzuo2 = zzoi.zzbpw;
                if (zzuq2.size() >= (Integer)zzlc.zzio().zzd((zzny)zzuo2)) break;
                zzuo.zza("Pooling and loading one new interstitial for %s.", zzup2);
                if (!zzuq2.zzb(this.zzceb)) continue;
                ++n;
            }
            zzus.zzln().zzu(n);
        }
        zzuo2 = this;
        if (zzuo2.zzceb != null) {
            SharedPreferences.Editor editor = zzuo2.zzceb.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zzup, zzuq> entry : zzuo2.zzcdz.entrySet()) {
                zzup zzup3 = entry.getKey();
                zzuq zzuq3 = entry.getValue();
                if (!zzuq3.zzlm()) continue;
                String string2 = new zzuu(zzuq3).zzlw();
                String string3 = zzup3.toString();
                editor.putString(string3, string2);
                zzuo.zza("Saved interstitial queue for %s.", zzup3);
            }
            editor.putString("PoolKeys", zzuo2.zzlh());
            editor.apply();
        }
    }

    private final String zzlh() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzcea.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzup)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzax(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzay(String string2) {
        try {
            zzny zzny2 = zzoi.zzbpy;
            return Pattern.matches((String)zzlc.zzio().zzd(zzny2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbt.zzep().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzh(zzkk zzkk2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzkk2.extras.keySet());
        Bundle bundle = zzkk2.zzbhf.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzkk zzi(zzkk zzkk2) {
        zzkk zzkk3 = zzuo.zzk(zzkk2);
        String string2 = "_skipMediation";
        zzkk zzkk4 = zzkk3;
        Bundle bundle = zzkk3.zzbhf.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzkk4.extras.putBoolean(string2, true);
        return zzkk3;
    }

    private static zzkk zzj(zzkk zzkk2) {
        zzkk zzkk3 = zzuo.zzk(zzkk2);
        zzny zzny2 = zzoi.zzbpu;
        for (String string2 : ((String)zzlc.zzio().zzd(zzny2)).split(",")) {
            zzuo.zzb(zzkk3.zzbhf, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zzuo.zzb(zzkk3.extras, string4);
        }
        return zzkk3;
    }

    private static String zzaz(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzkk zzk(zzkk zzkk2) {
        Parcel parcel = Parcel.obtain();
        zzkk2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzkk zzkk3 = (zzkk)zzkk.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzny zzny2 = zzoi.zzbpi;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            zzkk3 = zzkk3.zzhz();
        }
        return zzkk3;
    }

    private static void zzb(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zzup zzup2) {
        if (zzahw.zzae((int)2)) {
            zzahw.v(String.format(string2, zzup2));
        }
    }
}

