/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzabf;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzhm
extends Thread {
    private boolean mStarted = false;
    private boolean zzazd = false;
    private boolean zzbm = false;
    private final Object mLock;
    private final zzhh zzaze;
    private final zzabf zzazf;
    private final int zzazg;
    private final int zzayc;
    private final int zzazh;
    private final int zzaye;
    private final int zzazi;
    private final int zzazj;
    private final int zzazk;
    private final int zzazl;
    private final String zzazm;
    private final boolean zzazn;

    public zzhm(zzhh zzhh2, zzabf zzabf2) {
        this.zzaze = zzhh2;
        this.zzazf = zzabf2;
        this.mLock = new Object();
        zzny zzny2 = zzoi.zzbni;
        this.zzayc = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnj;
        this.zzazh = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnk;
        this.zzaye = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnl;
        this.zzazi = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbno;
        this.zzazj = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnq;
        this.zzazk = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnr;
        this.zzazl = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnm;
        this.zzazg = (Integer)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnt;
        this.zzazm = (String)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbnv;
        this.zzazn = (Boolean)zzlc.zzio().zzd(zzny2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgx() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzahw.zzby((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzhm.zzgy()) {
                    object = zzbt.zzeo().getActivity();
                    if (object == null) {
                        zzahw.zzby((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzha();
                    } else {
                        Activity activity = object;
                        zzhm zzhm2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbt.zzep().zza(exception, "ContentFetchTask.extractContent");
                                zzahw.zzby((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzhm zzhm3 = zzhm2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzhn(zzhm3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzahw.zzby((String)"ContentFetchTask: sleeping");
                    this.zzha();
                }
                Thread.sleep(this.zzazg * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzahw.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzazf.zza((Throwable)exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzazd) {
                    try {
                        zzahw.zzby((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzj(View view) {
        try {
            zzhg zzhg2 = new zzhg(this.zzayc, this.zzazh, this.zzaye, this.zzazi, this.zzazj, this.zzazk, this.zzazl);
            zzhq zzhq2 = this.zza(view, zzhg2);
            zzhg2.zzgu();
            if (zzhq2.zzazv == 0 && zzhq2.zzazw == 0) {
                return;
            }
            if (zzhq2.zzazw == 0 && zzhg2.zzgv() == 0) {
                return;
            }
            if (zzhq2.zzazw == 0 && this.zzaze.zza(zzhg2)) {
                return;
            }
            this.zzaze.zzc(zzhg2);
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzazf.zza((Throwable)exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzgy() {
        try {
            Context context = zzbt.zzeo().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbt.zzep().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzhq zza(@Nullable View view, zzhg zzhg2) {
        Object object;
        if (view == null) {
            return new zzhq(this, 0, 0);
        }
        Context context = zzbt.zzeo().getContext();
        if (context != null) {
            object = zzoi.zzbns;
            int n = context.getResources().getIdentifier((String)zzlc.zzio().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzazm) && string2 != null && string2.equals(this.zzazm)) {
                return new zzhq(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzhg2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzhq(this, 1, 0);
            }
            return new zzhq(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzaof)) {
            boolean bl2;
            zzhg2.zzgt();
            zzhg zzhg3 = zzhg2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzs.zzanv()) {
                bl2 = false;
            } else {
                zzhg3.zzgt();
                webView.post((Runnable)new zzho((zzhm)object, zzhg3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzhq(this, 0, 1);
            }
            return new zzhq(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzhq zzhq2 = this.zza(viewGroup.getChildAt(i), zzhg2);
                n += zzhq2.zzazv;
                n2 += zzhq2.zzazw;
            }
            return new zzhq(this, n, n2);
        }
        return new zzhq(this, 0, 0);
    }

    final void zza(zzhg zzhg2, WebView webView, String string2, boolean bl) {
        zzhg2.zzgs();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzazn && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzhg2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzhg2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzhg2.zzgn()) {
                this.zzaze.zzb(zzhg2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzahw.zzby((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzahw.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzazf.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzhg zzgz() {
        return this.zzaze.zzgw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzazd = false;
            this.mLock.notifyAll();
            zzahw.zzby((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzha() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzazd = true;
            zzahw.zzby((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzhb() {
        return this.zzazd;
    }
}

