/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdtf;
import com.google.android.gms.internal.zzdtj;
import com.google.android.gms.internal.zzdvy;
import com.google.android.gms.internal.zzdwa;
import com.google.android.gms.internal.zzdwc;
import com.google.android.gms.internal.zzdwe;
import com.google.android.gms.internal.zzdwg;
import com.google.android.gms.internal.zzdyj;
import com.google.android.gms.internal.zzdyl;
import com.google.android.gms.internal.zzdyp;
import com.google.android.gms.internal.zzfgs;
import com.google.android.gms.internal.zzfie;
import com.google.android.gms.internal.zzfjc;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzdui
implements zzdtf<zzdtj> {
    zzdui() {
    }

    private final zzdtj zzh(zzfgs zzfgs2) throws GeneralSecurityException {
        try {
            zzdyj zzdyj2;
            zzdwa zzdwa2;
            zzdwa zzdwa3;
            zzdwa zzdwa4 = zzdwa3 = zzdwa.zzae(zzfgs2);
            zzdwa zzdwa5 = zzdwa3;
            if (!(zzdwa3 instanceof zzdwa)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdwa zzdwa6 = zzdwa2 = zzdwa5;
            zzdyp.zzw(zzdwa2.getVersion(), 0);
            if (zzdwa6.zzbot().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdui.zza(zzdwa6.zzbqk());
            zzdvy zzdvy2 = zzdwa2.zzbqk().zzbqq();
            byte[] byArray = zzdwa2.zzbot().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzdwa2.zzbqk().zzbqr();
            switch (zzdvy2) {
                case zzmhr: {
                    zzdyj2 = new zzdyj("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzmht: {
                    zzdyj2 = new zzdyj("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzmhu: {
                    zzdyj2 = new zzdyj("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdyj2;
        }
        catch (zzfie zzfie2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzfie2);
        }
    }

    @Override
    public final zzfjc zzb(zzfgs zzfgs2) throws GeneralSecurityException {
        try {
            zzdwc zzdwc2 = zzdwc.zzag(zzfgs2);
            return this.zzb((zzfjc)zzdwc2);
        }
        catch (zzfie zzfie2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzfie2);
        }
    }

    @Override
    public final zzfjc zzb(zzfjc zzfjc2) throws GeneralSecurityException {
        zzdwc zzdwc2;
        if (!(zzfjc2 instanceof zzdwc)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdwc zzdwc3 = zzdwc2 = (zzdwc)zzfjc2;
        if (zzdwc2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdui.zza(zzdwc3.zzbqk());
        return zzdwa.zzbql().zzgm(0).zzc(zzdwc2.zzbqk()).zzaf(zzfgs.zzaz((byte[])zzdyl.zzgy(zzdwc2.getKeySize()))).zzczx();
    }

    @Override
    public final zzdwg zzc(zzfgs zzfgs2) throws GeneralSecurityException {
        zzdwa zzdwa2 = (zzdwa)this.zzb(zzfgs2);
        return (zzdwg)zzdwg.zzbqx().zzop("type.googleapis.com/google.crypto.tink.HmacKey").zzai(zzdwa2.toByteString()).zzb(zzdwg.zzb.zzmii).zzczx();
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    private static void zza(zzdwe zzdwe2) throws GeneralSecurityException {
        if (zzdwe2.zzbqr() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzdwe2.zzbqq()) {
            case zzmhr: {
                if (zzdwe2.zzbqr() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzmht: {
                if (zzdwe2.zzbqr() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzmhu: {
                if (zzdwe2.zzbqr() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzfjc zzfjc2) throws GeneralSecurityException {
        zzdwa zzdwa2;
        zzfjc zzfjc3 = zzfjc2;
        if (!(zzfjc3 instanceof zzdwa)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdwa zzdwa3 = zzdwa2 = (zzdwa)zzfjc3;
        zzdyp.zzw(zzdwa2.getVersion(), 0);
        if (zzdwa3.zzbot().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdui.zza(zzdwa3.zzbqk());
        zzdvy zzdvy2 = zzdwa2.zzbqk().zzbqq();
        byte[] byArray = zzdwa2.zzbot().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzdwa2.zzbqk().zzbqr();
        switch (zzdvy2) {
            case zzmhr: {
                return new zzdyj("HMACSHA1", secretKeySpec, n);
            }
            case zzmht: {
                return new zzdyj("HMACSHA256", secretKeySpec, n);
            }
            case zzmhu: {
                return new zzdyj("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzfgs zzfgs2) throws GeneralSecurityException {
        return this.zzh(zzfgs2);
    }
}

