/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdw;
import java.lang.ref.WeakReference;

public final class zzdu
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zzaju = new Handler(Looper.getMainLooper());
    private final Context zzajv;
    private Application zzaih;
    private final PowerManager zzajw;
    private final KeyguardManager zzajx;
    private final zzdm zzagq;
    private BroadcastReceiver zzajy;
    private WeakReference<ViewTreeObserver> zzajz;
    private WeakReference<View> zzaka;
    private zzda zzakb;
    private boolean zzakc = false;
    private int zzakd = -1;
    private long zzake = -3L;

    public zzdu(zzdm zzdm2, View view) {
        this.zzagq = zzdm2;
        this.zzajv = zzdm2.zzaiq;
        this.zzajw = (PowerManager)this.zzajv.getSystemService("power");
        this.zzajx = (KeyguardManager)this.zzajv.getSystemService("keyguard");
        if (this.zzajv instanceof Application) {
            this.zzaih = (Application)this.zzajv;
            this.zzakb = new zzda((Application)this.zzajv, this);
        }
        this.zzd(view);
    }

    final void zzd(View view) {
        View view2 = this.zzaka != null ? (View)this.zzaka.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzf(view2);
        }
        this.zzaka = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zze(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzake = -2L;
            return;
        }
        this.zzake = -3L;
    }

    private final void zzat() {
        zzaju.post((Runnable)new zzdv(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzakd = -1;
        this.zze(view);
        this.zzav();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzakd = -1;
        this.zzav();
        this.zzat();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzaka == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzaka.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzakd = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzav();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzav();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzav();
        this.zzat();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzav();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzav();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzav();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzav();
    }

    public final void onGlobalLayout() {
        this.zzav();
    }

    public final void onScrollChanged() {
        this.zzav();
    }

    public final long zzau() {
        if (this.zzake == -2L && this.zzaka.get() == null) {
            this.zzake = -3L;
        }
        return this.zzake;
    }

    private final void zzav() {
        boolean bl;
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        if (this.zzaka == null) {
            return;
        }
        View view2 = (View)this.zzaka.get();
        if (view2 == null) {
            this.zzake = -3L;
            this.zzakc = false;
            return;
        }
        boolean bl2 = view2.getGlobalVisibleRect(new Rect());
        boolean bl3 = view2.getLocalVisibleRect(new Rect());
        boolean bl4 = this.zzagq.zzal() || this.zzajx.inKeyguardRestrictedInputMode() && (activity = zzds.zzc(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0;
        int n = view2.getWindowVisibility();
        int n2 = this.zzakd != -1 ? this.zzakd : n;
        boolean bl5 = bl = view2.getVisibility() == 0 && view2.isShown() && this.zzajw.isScreenOn() && bl4 && bl3 && bl2 && n2 == 0;
        if (this.zzakc != bl) {
            this.zzake = bl ? SystemClock.elapsedRealtime() : -2L;
            this.zzakc = bl;
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzajz = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzdu zzdu2 = this;
        if (zzdu2.zzajy == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzdu2.zzajy = new zzdw(zzdu2);
            zzdu2.zzajv.registerReceiver(zzdu2.zzajy, intentFilter);
        }
        if (this.zzaih != null) {
            try {
                this.zzaih.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzakb);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzajz != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzajz.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzajz = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzdu zzdu2 = this;
        if (zzdu2.zzajy != null) {
            try {
                zzdu2.zzajv.unregisterReceiver(zzdu2.zzajy);
            }
            catch (Exception exception) {}
            zzdu2.zzajy = null;
        }
        if (this.zzaih != null) {
            try {
                this.zzaih.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzakb);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzdu zzdu2) {
        zzdu2.zzav();
    }
}

