/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzaid;
import com.google.android.gms.internal.zzaik;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaim;
import com.google.android.gms.internal.zzain;
import com.google.android.gms.internal.zzaio;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzakr;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzfxd;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzpf;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzaij {
    public static final Handler zzdfn = new zzahx(Looper.getMainLooper());
    private final Object mLock = new Object();
    private boolean zzdfo = true;
    private String zzddt;
    private boolean zzdfp = false;
    private boolean zzdfq = false;
    private Pattern zzdfr;
    private Pattern zzdfs;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzaij zzaij2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzaij2.zzl(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzag(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzahw.zzcz((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzahw.zzcz((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzahw.zzcz((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzahw.zzcz((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzahw.zzcz((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzahw.zzcz((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzahw.zzcz((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzahw.zzcz((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzd(Context context, String string2, String string3) {
        return zzbih.zzdd((Context)context).checkPermission(string3, string2) == 0;
    }

    public static void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzakd(context, string2, string3).zzns();
        }
    }

    public static void zze(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        zzaij.zza(context, string2, arrayList);
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzfxd.zzfk((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzahw.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzpf.zzh(context)) {
            zzahw.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zzpf zzpf2 = new zzpf();
        zzaik zzaik2 = new zzaik(this, list, zzpf2, context);
        zzpf2.zza(zzaik2);
        zzpf2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzah(Context context) {
        if (this.zzdfp) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzaio(this, null), intentFilter);
        this.zzdfp = true;
        return true;
    }

    public final boolean zzai(Context context) {
        if (this.zzdfq) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzain(this, null), intentFilter);
        this.zzdfq = true;
        return true;
    }

    public final void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzl(context, string2));
    }

    private static String zzrb() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzl(Context context, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzddt != null) {
                return this.zzddt;
            }
            if (string2 == null) {
                return zzaij.zzrb();
            }
            try {
                this.zzddt = zzbt.zzen().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzddt)) {
                zzlc.zzij();
                if (!zzako.zzsa()) {
                    this.zzddt = null;
                    zzdfn.post((Runnable)new zzail(this, context));
                    while (this.zzddt == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzddt = zzaij.zzrb();
                            String string3 = String.valueOf(this.zzddt);
                            zzahw.zzcz((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzddt = zzaij.zzaj(context);
                }
            }
            String string4 = String.valueOf(this.zzddt);
            this.zzddt = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (zzbih.zzdd((Context)context).zzaoe()) {
                    this.zzddt = String.valueOf(this.zzddt).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbt.zzep().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzddt = String.valueOf(this.zzddt).concat(")");
            return this.zzddt;
        }
    }

    protected static String zzaj(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzaij.zzrb();
        }
    }

    public static boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String zzci(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzq(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zzd(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zzd(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzq(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzaij zzaij2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzaij2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzq(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static Map<String, String> zzf(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : zzbt.zzen().zzg(uri)) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public static String zzrc() {
        return UUID.randomUUID().toString();
    }

    public static int zzcj(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzahw.zzcz((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzrd() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzre() {
        return new int[]{0, 0};
    }

    public static int[] zzf(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzaij.zzre();
    }

    public final int[] zzg(Activity activity) {
        int[] nArray = zzaij.zzf(activity);
        int[] nArray2 = new int[2];
        zzlc.zzij();
        nArray2[0] = zzako.zzb((Context)activity, (int)nArray[0]);
        zzlc.zzij();
        nArray2[1] = zzako.zzb((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzh(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzaij.zzre();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzlc.zzij();
        nArray4[0] = zzako.zzb((Context)activity, (int)nArray3[0]);
        zzlc.zzij();
        nArray4[1] = zzako.zzb((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzck(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzak(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zznu zzal(Context context) {
        return new zznu(context);
    }

    public static Bitmap zzr(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzam(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zzko zzko2) {
        zzny zzny2 = zzoi.zzbof;
        if (!((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzko2.width);
            jSONObject2.put("height", zzko2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzaij.zzam(context));
            if (!zzko2.zzbib) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzahw.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static boolean zzan(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            zzbt.zzel();
            bundle.putString("device", zzaij.zzrd());
            bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zzoi.zzjf()));
        }
        zzlc.zzij();
        zzako.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)bl, (zzakr)new zzaim(this, context, string2));
    }

    public final void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        zzny zzny2 = zzoi.zzbqq;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public static void zzc(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzaid.zzb(runnable);
    }

    public static Bitmap zzs(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzaij.zzu(view);
        if (bitmap == null) {
            bitmap = zzaij.zzt(view);
        }
        return bitmap;
    }

    private static Bitmap zzt(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzahw.zzcz((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzahw.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzu(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzahw.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzao(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            zzny zzny2 = zzoi.zzbsa;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    bitmap = zzaij.zzu(window.getDecorView().getRootView());
                }
            } else {
                bitmap = zzaij.zzt(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzahw.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static int zzap(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzaij.zzaq(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzaq(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean zza(View var1_1, PowerManager var2_2, KeyguardManager var3_3) {
        if (zzbt.zzel().zzdfo || !((var5_4 = var3_3) == null ? false : var5_4.inKeyguardRestrictedInputMode())) ** GOTO lbl-1000
        var5_4 = zzoi.zzbqn;
        if (((Boolean)zzlc.zzio().zzd((zzny)var5_4)).booleanValue() && zzaij.zzv(var1_1)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var4_5 = false;
        }
        if (var1_1.getVisibility() == 0 && var1_1.isShown() && ((var5_4 = var2_2) == null || var5_4.isScreenOn() != false) && var4_5) {
            var5_4 = zzoi.zzbql;
            if (!((Boolean)zzlc.zzio().zzd((zzny)var5_4)).booleanValue() || var1_1.getLocalVisibleRect(new Rect()) || var1_1.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzv(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzar(Context context) {
        if (context == null || !zzs.zzans()) {
            return false;
        }
        KeyguardManager keyguardManager = zzaij.zzaq(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzw(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzas(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzahw.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbt.zzep().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzrf() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            zzny zzny2 = zzoi.zzbmj;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            zzny2 = zzoi.zzbmk;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
            bundle.putInt("web_view_count", zzbt.zzep().zzqd());
        }
        catch (Exception exception) {
            zzahw.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzny zzny2 = zzoi.zzbuo;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                zzaij.zzb(context, intent);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzahw.zzby((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzahw.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (zzs.zzanu()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzf(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzm(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(zzp.zza((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzahw.zzby((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zzlc.zzij();
        int n = zzako.zza((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzako.zza((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzaij.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zzny zzny2 = zzoi.zzbuy;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * (Integer)zzlc.zzio().zzd(zzny2);
        return zzaij.zzb(n3, n + n5, n7) && zzaij.zzb(n4, n2, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcl(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzaij zzaij2 = this;
            synchronized (zzaij2) {
                block10: {
                    zzny zzny2;
                    block9: {
                        if (this.zzdfr == null) break block9;
                        zzny2 = zzoi.zzbol;
                        if (((String)zzlc.zzio().zzd(zzny2)).equals(this.zzdfr.pattern())) break block10;
                    }
                    zzny2 = zzoi.zzbol;
                    this.zzdfr = Pattern.compile((String)zzlc.zzio().zzd(zzny2));
                }
                return this.zzdfr.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcm(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzaij zzaij2 = this;
            synchronized (zzaij2) {
                block10: {
                    zzny zzny2;
                    block9: {
                        if (this.zzdfs == null) break block9;
                        zzny2 = zzoi.zzbom;
                        if (((String)zzlc.zzio().zzd(zzny2)).equals(this.zzdfs.pattern())) break block10;
                    }
                    zzny2 = zzoi.zzbom;
                    this.zzdfs = Pattern.compile((String)zzlc.zzio().zzd(zzny2));
                }
                return this.zzdfs.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    public static Bundle zza(zzhm zzhm2) {
        String string2;
        String string3;
        if (zzhm2 == null) {
            return null;
        }
        zzny zzny2 = zzoi.zzbnn;
        if (!((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            zzny2 = zzoi.zzbnp;
            if (!((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                return null;
            }
        }
        if (zzbt.zzep().zzqe().zzqp() && zzbt.zzep().zzqe().zzqr()) {
            return null;
        }
        if (zzhm2.zzhb()) {
            zzhm2.wakeup();
        }
        zzhg zzhg2 = zzhm2.zzgz();
        String string4 = null;
        if (zzhg2 != null) {
            string3 = zzhg2.zzgo();
            string4 = zzhg2.zzgp();
            string2 = zzhg2.zzgq();
            if (string3 != null) {
                zzbt.zzep().zzqe().zzcb(string3);
            }
            if (string2 != null) {
                zzbt.zzep().zzqe().zzcc(string2);
            }
        } else {
            string3 = zzbt.zzep().zzqe().zzqq();
            string2 = zzbt.zzep().zzqe().zzqs();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null) {
            zzny2 = zzoi.zzbnp;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && !zzbt.zzep().zzqe().zzqr()) {
                bundle.putString("v_fp_vertical", string2);
            }
        }
        if (string3 != null) {
            zzny2 = zzoi.zzbnn;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && !zzbt.zzep().zzqe().zzqp()) {
                bundle.putString("fingerprint", string3);
                if (!string3.equals(string4)) {
                    bundle.putString("v_fp", string4);
                }
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    public static String zzcn(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        return string2.split(";")[0].trim();
    }

    public static String zzco(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        String[] stringArray = string2.split(";");
        if (stringArray.length == 1) {
            return "";
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (!stringArray[i].trim().startsWith("charset") || (stringArray2 = stringArray[i].trim().split("=")).length <= 1) continue;
            return stringArray2[1].trim();
        }
        return "";
    }

    static /* synthetic */ boolean zza(zzaij zzaij2, boolean bl) {
        zzaij2.zzdfo = bl;
        return zzaij2.zzdfo;
    }

    static /* synthetic */ Object zza(zzaij zzaij2) {
        return zzaij2.mLock;
    }

    static /* synthetic */ String zza(zzaij zzaij2, String string2) {
        zzaij2.zzddt = string2;
        return zzaij2.zzddt;
    }
}

