/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaea;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzpf;
import java.util.Locale;

public final class zzaeb {
    private int zzcyb;
    private boolean zzcyi;
    private boolean zzcyj;
    private int zzcyn;
    private int zzcyr;
    private int zzcys;
    private String zzcye;
    private int zzcyo;
    private int zzcyp;
    private int zzcyq;
    private boolean zzcyv;
    private int zzcyw;
    private double zzcyt;
    private boolean zzcyu;
    private String zzcyx;
    private String zzcyy;
    private boolean zzcyc;
    private boolean zzcyd;
    private String zzcyf;
    private boolean zzcyg;
    private boolean zzcyh;
    private String zzcyk;
    private String zzcyl;
    private float zzaxz;
    private int zzcse;
    private int zzcsf;
    private String zzcym;
    private boolean zzcyz;

    public zzaeb(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Locale locale = Locale.getDefault();
        this.zzcyc = zzaeb.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcyd = zzaeb.zza(packageManager, "http://www.google.com") != null;
        this.zzcyf = locale.getCountry();
        zzlc.zzij();
        this.zzcyg = zzako.zzrz();
        this.zzcyh = zzj.zzcw((Context)context);
        this.zzcyk = locale.getLanguage();
        this.zzcyl = zzaeb.zzb(context, packageManager);
        this.zzcym = zzaeb.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzaxz = displayMetrics.density;
        this.zzcse = displayMetrics.widthPixels;
        this.zzcsf = displayMetrics.heightPixels;
    }

    public zzaeb(Context context, zzaea zzaea2) {
        context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Context context2 = context;
        zzaeb zzaeb2 = this;
        this.zzcyx = Build.FINGERPRINT;
        zzaeb2.zzcyy = Build.DEVICE;
        zzaeb2.zzcyz = zzs.zzanr() && zzpf.zzh(context2);
        this.zzcyc = zzaea2.zzcyc;
        this.zzcyd = zzaea2.zzcyd;
        this.zzcyf = zzaea2.zzcyf;
        this.zzcyg = zzaea2.zzcyg;
        this.zzcyh = zzaea2.zzcyh;
        this.zzcyk = zzaea2.zzcyk;
        this.zzcyl = zzaea2.zzcyl;
        this.zzcym = zzaea2.zzcym;
        this.zzaxz = zzaea2.zzaxz;
        this.zzcse = zzaea2.zzcse;
        this.zzcsf = zzaea2.zzcsf;
    }

    private final void zzl(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzcyb = audioManager.getMode();
                this.zzcyi = audioManager.isMusicActive();
                this.zzcyj = audioManager.isSpeakerphoneOn();
                this.zzcyn = audioManager.getStreamVolume(3);
                this.zzcyr = audioManager.getRingerMode();
                this.zzcys = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbt.zzep().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcyb = -2;
        this.zzcyi = false;
        this.zzcyj = false;
        this.zzcyn = 0;
        this.zzcyr = 0;
        this.zzcys = 0;
    }

    @TargetApi(value=16)
    private final void zzm(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcye = telephonyManager.getNetworkOperator();
        this.zzcyp = telephonyManager.getNetworkType();
        this.zzcyq = telephonyManager.getPhoneType();
        this.zzcyo = -2;
        this.zzcyv = false;
        this.zzcyw = -1;
        zzbt.zzel();
        if (zzaij.zzd(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcyo = networkInfo.getType();
                this.zzcyw = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcyo = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcyv = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzn(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcyt = (float)n2 / (float)n3;
            this.zzcyu = n == 2 || n == 5;
            return;
        }
        this.zzcyt = -1.0;
        this.zzcyu = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbih.zzdd((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzaeb.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbih.zzdd((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbt.zzep().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaea zzom() {
        return new zzaea(this.zzcyb, this.zzcyc, this.zzcyd, this.zzcye, this.zzcyf, this.zzcyg, this.zzcyh, this.zzcyi, this.zzcyj, this.zzcyk, this.zzcyl, this.zzcym, this.zzcyn, this.zzcyo, this.zzcyp, this.zzcyq, this.zzcyr, this.zzcys, this.zzaxz, this.zzcse, this.zzcsf, this.zzcyt, this.zzcyu, this.zzcyv, this.zzcyw, this.zzcyx, this.zzcyz, this.zzcyy);
    }
}

