/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzacw;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzabh
@Hide
public final class zzacv
extends zzbgl {
    public static final Parcelable.Creator<zzacv> CREATOR = new zzacx();
    private ParcelFileDescriptor zzcup;
    private Parcelable zzcuq;
    private boolean zzcur;

    public zzacv(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcup = parcelFileDescriptor;
        this.zzcuq = null;
        this.zzcur = true;
    }

    public zzacv(zzbgp zzbgp2) {
        this.zzcup = null;
        this.zzcuq = zzbgp2;
        this.zzcur = false;
    }

    public final <T extends zzbgp> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcur) {
            byte[] byArray;
            if (this.zzcup == null) {
                zzahw.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcup));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzahw.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                zzp.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcuq = (zzbgp)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcur = false;
        }
        return (T)((zzbgp)this.zzcuq);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzob();
        Parcel parcel2 = parcel;
        zzacv zzacv2 = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)zzacv2.zzcup, (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzob() {
        if (this.zzcup == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzcuq.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzcup = this.zze(byArray);
        }
        return this.zzcup;
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzacw zzacw2 = new zzacw(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzacw2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzahw.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbt.zzep().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzp.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

