/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.query.UpdateClickUrlCallback;
import com.google.android.gms.ads.query.UpdateImpressionUrlsCallback;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbtv;
import com.google.android.gms.internal.ads.zzbtw;
import com.google.android.gms.internal.ads.zzbtx;
import com.google.android.gms.internal.ads.zzbty;
import com.google.android.gms.internal.ads.zzbtz;
import com.google.android.gms.internal.ads.zzbua;
import com.google.android.gms.internal.ads.zzbuc;
import com.google.android.gms.internal.ads.zzbyu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class zzbub {
    @Nonnull
    private final View zza;
    @Nullable
    private final Map zzb;
    @Nullable
    private final zzbyu zzc;

    public zzbub(zzbua zzbua2) {
        this.zza = zzbua.zza(zzbua2);
        this.zzb = zzbua.zzd(zzbua2);
        this.zzc = zzbtv.zza(zzbua.zza(zzbua2).getContext());
        if (this.zzc == null || this.zzb.isEmpty()) {
            return;
        }
        try {
            this.zzc.zzg(new zzbuc(ObjectWrapper.wrap((Object)this.zza).asBinder(), ObjectWrapper.wrap((Object)this.zzb).asBinder()));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zza(List list) {
        if (list == null || list.isEmpty()) {
            zzo.zzj("No click urls were passed to recordClick");
            return;
        }
        if (this.zzc == null) {
            zzo.zzj("Failed to get internal reporting info generator in recordClick.");
        }
        try {
            zzbyu zzbyu2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbyu2.zzh(list, iObjectWrapper, new zzbtz(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("RemoteException recording click: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(List list) {
        if (list == null || list.isEmpty()) {
            zzo.zzj("No impression urls were passed to recordImpression");
            return;
        }
        zzbyu zzbyu2 = this.zzc;
        if (zzbyu2 == null) {
            zzo.zzj("Failed to get internal reporting info generator from recordImpression.");
            return;
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbyu2.zzi(list, iObjectWrapper, new zzbty(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("RemoteException recording impression urls: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(MotionEvent motionEvent) {
        zzbyu zzbyu2;
        zzbyu2 = ((zzbub)((Object)zzbyu2)).zzc;
        if (zzbyu2 == null) {
            zzo.zze("Failed to get internal reporting info generator.");
            return;
        }
        try {
            zzbyu2.zzk(ObjectWrapper.wrap((Object)motionEvent));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zzd(Uri uri, UpdateClickUrlCallback updateClickUrlCallback) {
        if (this.zzc == null) {
            updateClickUrlCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzbyu zzbyu2 = this.zzc;
            ArrayList<Uri> arrayList = new ArrayList<Uri>(Arrays.asList(uri));
            uri = ObjectWrapper.wrap((Object)this.zza);
            zzbyu2.zzl(arrayList, (IObjectWrapper)uri, new zzbtx(this, updateClickUrlCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateClickUrlCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    public final void zze(List list, UpdateImpressionUrlsCallback updateImpressionUrlsCallback) {
        if (this.zzc == null) {
            updateImpressionUrlsCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzbyu zzbyu2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbyu2.zzm(list, iObjectWrapper, new zzbtw(this, updateImpressionUrlsCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateImpressionUrlsCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }
}

