/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzel;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class SearchAdView
extends ViewGroup {
    @NotOnlyInitialized
    private final zzel zza;

    @NonNull
    public AdListener getAdListener() {
        return this.zza.zza();
    }

    @Nullable
    public AdSize getAdSize() {
        return this.zza.zzb();
    }

    @NonNull
    public String getAdUnitId() {
        return this.zza.zzj();
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@NonNull Context context) {
        super((Context)var1_1);
        void var1_1;
        this.zza = new zzel(this);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@NonNull Context context, @NonNull AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.zza = new zzel(this, (AttributeSet)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = new zzel(this, (AttributeSet)var2_2, false);
    }

    public void destroy() {
        this.zza.zzk();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        void var1_1;
        if (!AdSize.SEARCH.equals(this.getAdSize())) {
            throw new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
        }
        this.zza.zzm(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull SearchAdRequest searchAdRequest) {
        void var1_1;
        this.zza.zzm(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            void v0 = var4_5 - var2_3 - n;
            var2_3 = var5_6 - var3_4 - n2;
            void v1 = v0 / 2;
            void v2 = var2_3 /= 2;
            this.layout((int)v1, (int)v2, (int)(v1 + n), (int)(v2 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        void var2_3;
        void var1_2;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, (int)var1_2, (int)var2_3);
            n2 = view.getMeasuredWidth();
            n = view.getMeasuredHeight();
        } else {
            AdSize adSize;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzo.zzh("Unable to retrieve ad size.", nullPointerException);
                adSize = null;
            }
            if (adSize != null) {
                AdSize adSize2 = adSize;
                Context context = this.getContext();
                n2 = adSize2.getWidthInPixels(context);
                n = adSize2.getHeightInPixels(context);
            } else {
                n2 = 0;
                n = 0;
            }
        }
        SearchAdView searchAdView = this;
        int n3 = Math.max(n, searchAdView.getSuggestedMinimumHeight());
        searchAdView.setMeasuredDimension(View.resolveSize((int)Math.max(n2, this.getSuggestedMinimumWidth()), (int)var1_2), View.resolveSize((int)n3, (int)var2_3));
    }

    public void pause() {
        this.zza.zzn();
    }

    public void resume() {
        this.zza.zzp();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@NonNull AdListener adListener) {
        void var1_1;
        this.zza.zzr((AdListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        void var1_1;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this.zza.zzs(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@NonNull String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }
}

