/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.internal.client.zzbc;
import com.google.android.gms.ads.internal.client.zzdy;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.util.client.zzo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Nullable
    private final zzdy zza;
    private final List zzb;
    @Nullable
    private AdapterResponseInfo zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Bundle getResponseExtras() {
        try {
            zzdy this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return new Bundle();
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Could not forward getResponseExtras to ResponseInfo.", remoteException);
            return new Bundle();
        }
        return this_.zze();
    }

    @Nullable
    public AdapterResponseInfo getLoadedAdapterResponseInfo() {
        return this.zzc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getMediationAdapterClassName() {
        try {
            zzdy this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Could not forward getMediationAdapterClassName to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzg();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getResponseId() {
        try {
            zzdy this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Could not forward getResponseId to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzi();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        try {
            return ((ResponseInfo)this).zzd().toString(2);
        }
        catch (JSONException jSONException) {
            return "Error forming toString output.";
        }
    }

    @NonNull
    public List<AdapterResponseInfo> getAdapterResponses() {
        return this.zzb;
    }

    @Nullable
    public static ResponseInfo zza(@Nullable zzdy zzdy2) {
        if (zzdy2 != null) {
            return new ResponseInfo(zzdy2);
        }
        return null;
    }

    @NonNull
    public static ResponseInfo zzb(@Nullable zzdy zzdy2) {
        return new ResponseInfo(zzdy2);
    }

    @VisibleForTesting
    @Nullable
    public final zzdy zzc() {
        return this.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public final JSONObject zzd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object object = responseInfo.getResponseId();
        if (object == null) {
            jSONObject.put("Response ID", (Object)"null");
        } else {
            jSONObject.put("Response ID", object);
        }
        if ((object = responseInfo.getMediationAdapterClassName()) == null) {
            jSONObject.put("Mediation Adapter Class Name", (Object)"null");
        } else {
            jSONObject.put("Mediation Adapter Class Name", object);
        }
        object = new JSONArray();
        Iterator iterator = responseInfo.zzb.iterator();
        while (iterator.hasNext()) {
            object.put((Object)((AdapterResponseInfo)iterator.next()).zzb());
        }
        jSONObject.put("Adapter Responses", object);
        object = responseInfo.zzc;
        if (object != null) {
            jSONObject.put("Loaded Adapter Response", (Object)((AdapterResponseInfo)object).zzb());
        }
        if ((responseInfo = responseInfo.getResponseExtras()) != null) {
            ResponseInfo responseInfo = zzbc.zzb().zzi((Bundle)responseInfo);
            jSONObject.put("Response Extras", (Object)responseInfo);
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ResponseInfo(@Nullable zzdy iterator) {
        block7: {
            this.zza = iterator;
            this.zzb = new ArrayList();
            iterator = this.zza;
            if (iterator != null) {
                try {
                    if ((iterator = iterator.zzj()) == null) break block7;
                    iterator = iterator.iterator();
                }
                catch (RemoteException remoteException) {
                    zzo.zzh("Could not forward getAdapterResponseInfo to ResponseInfo.", remoteException);
                }
                while (iterator.hasNext()) {
                    AdapterResponseInfo adapterResponseInfo = AdapterResponseInfo.zza((zzw)((Object)iterator.next()));
                    if (adapterResponseInfo == null) continue;
                    this.zzb.add(adapterResponseInfo);
                }
            }
        }
        if ((iterator = this.zza) == null) {
            return;
        }
        try {
            if ((iterator = iterator.zzf()) == null) return;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Could not forward getLoadedAdapterResponse to ResponseInfo.", remoteException);
            return;
        }
        this.zzc = AdapterResponseInfo.zza(iterator);
    }
}

