/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.zzf;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.formats.zzi;
import com.google.android.gms.ads.internal.client.zzbc;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.client.zzbr;
import com.google.android.gms.ads.internal.client.zzbu;
import com.google.android.gms.ads.internal.client.zzei;
import com.google.android.gms.ads.internal.client.zzfi;
import com.google.android.gms.ads.internal.client.zzga;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbfl;
import com.google.android.gms.internal.ads.zzbia;
import com.google.android.gms.internal.ads.zzbic;
import com.google.android.gms.internal.ads.zzbid;
import com.google.android.gms.internal.ads.zzbpa;
import com.google.android.gms.internal.ads.zzbsr;
import com.google.android.gms.internal.ads.zzbst;

public class AdLoader {
    private final zzr zza;
    private final Context zzb;
    private final zzbr zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@NonNull AdRequest adRequest, int maxNumberOfAds) {
        zzei zzei2 = adRequest.zza;
        try {
            void var2_3;
            this.zzc.zzh(this.zza.zza(this.zzb, zzei2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzi();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzo.zzk("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbr zzbr2, zzr zzr2) {
        this.zzb = context;
        this.zzc = zzbr2;
        this.zza = zzr2;
    }

    final /* synthetic */ void zza(zzei zzei2) {
        try {
            this.zzc.zzg(this.zza.zza(this.zzb, zzei2));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("Failed to load ad.", remoteException);
            return;
        }
    }

    private final void zzb(zzei zzei2) {
        block5: {
            block4: {
                zzbcl.zza(this.zzb);
                if (!((Boolean)zzbej.zzc.zze()).booleanValue()) break block4;
                zzbcc zzbcc2 = zzbcl.zzla;
                if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) break block5;
            }
            try {
                this.zzc.zzg(this.zza.zza(this.zzb, zzei2));
                return;
            }
            catch (RemoteException remoteException) {
                zzo.zzh("Failed to load ad.", remoteException);
                return;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zza(this, zzei2));
    }

    public static class Builder {
        private final Context zza;
        private final zzbu zzb;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forAdManagerAdView(@NonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbu zzbu2;
            if (adSizes == null || ((void)zzbu2).length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                void var1_1;
                zzs zzs2 = new zzs(this.zza, (AdSize[])zzbu2);
                zzbu2 = this.zzb;
                zzbu2.zzj(new zzbic((OnAdManagerAdViewLoadedListener)var1_1), zzs2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to add Google Ad Manager banner ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forCustomFormatAd(@NonNull String customFormatId, @NonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbsr zzbsr2 = new zzbsr((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbsr2.zzb(), zzbsr2.zza());
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forNativeAd(@NonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbu zzbu2 = this.zzb;
                zzbu2.zzk(new zzbst((NativeAd.OnNativeAdLoadedListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdListener(@NonNull AdListener listener) {
            try {
                void var1_1;
                zzbu zzbu2 = this.zzb;
                zzbu2.zzl(new com.google.android.gms.ads.internal.client.zzg((AdListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdManagerAdViewOptions(@NonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzm((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Builder withNativeAdOptions(@NonNull NativeAdOptions options) {
            int n;
            boolean bl;
            int n2;
            int n3;
            boolean bl2;
            int n4;
            boolean bl3;
            boolean bl4;
            zzbu zzbu2;
            try {
                void var1_1;
                zzbu2 = this.zzb;
                bl4 = var1_1.shouldReturnUrlsForImageAssets();
                bl3 = var1_1.shouldRequestMultipleImages();
                n4 = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzga zzga2 = new zzga(var1_1.getVideoOptions());
                } else {
                    Object var2_12 = null;
                }
                bl2 = var1_1.zzc();
                n3 = var1_1.getMediaAspectRatio();
                n2 = var1_1.zza();
                bl = var1_1.zzb();
                n = var1_1.zzd();
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
            {
                void var2_11;
                zzbfl zzbfl2 = new zzbfl(4, bl4, -1, bl3, n4, (zzga)var2_11, bl2, n3, n2, bl, --n);
                zzbu2.zzo(zzbfl2);
                return this;
            }
        }

        @NonNull
        public AdLoader build() {
            try {
                Context context = builder.zza;
                zzbr zzbr2 = builder.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbr2, zzr.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzo.zzh("Failed to build AdLoader.", remoteException);
                zzfi zzfi2 = new zzfi();
                Builder builder = builder.zza;
                return new AdLoader((Context)builder, zzfi2.zzc(), zzr.zza);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Context context, @NonNull String adUnitID) {
            void var2_2;
            void var1_1;
            Context context2 = (Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            zzbu zzbu2 = zzbc.zza().zzd((Context)var1_1, (String)var2_2, new zzbpa());
            this.zza = context2;
            this.zzb = zzbu2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zza(String string, zzg zzg2, @Nullable zzf zzf2) {
            zzbia zzbia2 = new zzbia(zzg2, zzf2);
            try {
                this.zzb.zzh(string, zzbia2.zzd(), zzbia2.zzc());
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zzb(zzi zzi2) {
            try {
                zzbu zzbu2 = this.zzb;
                zzbu2.zzk(new zzbid(zzi2));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public final Builder zzc(@NonNull com.google.android.gms.ads.formats.NativeAdOptions nativeAdOptions) {
            try {
                this.zzb.zzo(new zzbfl(nativeAdOptions));
                return this;
            }
            catch (RemoteException remoteException) {
                zzo.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }
    }
}

