/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbfe;
import com.google.android.gms.internal.ads.zzcbd;
import com.google.android.gms.internal.ads.zzcbf;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzfqv;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzcbg {
    public static final Handler zza = new zzfqv(Looper.getMainLooper());
    private static final String zzb = AdView.class.getName();
    private static final String zzc = InterstitialAd.class.getName();
    private static final String zzd = AdManagerAdView.class.getName();
    private static final String zze = AdManagerInterstitialAd.class.getName();
    private static final String zzf = SearchAdView.class.getName();
    private static final String zzg = AdLoader.class.getName();
    private float zzh = -1.0f;

    /*
     * Enabled aggressive block sorting
     */
    public static int zza(Context context, int n) {
        DisplayMetrics displayMetrics;
        block7: {
            block6: {
                if (context == null) break block6;
                if (context.getApplicationContext() != null) {
                    context = context.getApplicationContext();
                }
                if ((context = context.getResources()) != null && (displayMetrics = context.getDisplayMetrics()) != null && (context = context.getConfiguration()) != null) break block7;
            }
            return -1;
        }
        int n2 = context.orientation;
        if (n == 0) {
            n = n2;
        }
        if (n == n2) {
            return Math.round((float)displayMetrics.heightPixels / displayMetrics.density);
        }
        return Math.round((float)displayMetrics.widthPixels / displayMetrics.density);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int zzb(Context context, int n) {
        if (!(this.zzh < 0.0f)) return Math.round((float)n / this.zzh);
        synchronized (this) {
            float f = this.zzh;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            if (!(f < 0.0f)) return Math.round((float)n / this.zzh);
            {
                context = (WindowManager)context.getSystemService("window");
                if (context == null) {
                    return 0;
                }
                DisplayMetrics displayMetrics = new DisplayMetrics();
                context.getDefaultDisplay().getMetrics(displayMetrics);
                this.zzh = displayMetrics.density;
            }
            return Math.round((float)n / this.zzh);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AdSize zzc(Context context, int n, int n2, int n3) {
        int n4 = zzcbg.zza(context, n3);
        if (n4 == -1) {
            return AdSize.INVALID;
        }
        n2 = Math.min(90, Math.round((float)n4 * 0.15f));
        n4 = n > 655 ? Math.round((float)n / 728.0f * 90.0f) : (n > 632 ? 81 : (n > 526 ? Math.round((float)n / 468.0f * 60.0f) : (n > 432 ? 68 : Math.round((float)n / 320.0f * 50.0f))));
        n4 = Math.max(Math.min(n4, n2), 50);
        return new AdSize(n, n4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String zzd() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return string;
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static String zzz(String string, String string2) {
        int n = 0;
        while (true) {
            if (n < 2) {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                messageDigest.update(string.getBytes());
                string = String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
                return string;
            }
            return null;
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
                continue;
            }
            break;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    @Nullable
    public static String zze(String string) {
        return zzcbg.zzz(string, "MD5");
    }

    @Nullable
    public static String zzf(String string) {
        return zzcbg.zzz(string, "SHA-256");
    }

    private final JSONArray zzA(Collection object) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            this.zzB(jSONArray, object.next());
        }
        return jSONArray;
    }

    @VisibleForTesting
    final JSONArray zzg(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.zzB(jSONArray, objectArray[i]);
        }
        return jSONArray;
    }

    public final JSONObject zzh(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zzC(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JSONObject zzi(Map map) throws JSONException {
        try {
            boolean bl;
            JSONObject jSONObject = new JSONObject();
            Iterator iterator = map.keySet().iterator();
            while (bl = iterator.hasNext()) {
                String string = (String)iterator.next();
                this.zzC(jSONObject, string, map.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            throw new JSONException("Could not convert map to JSON: ".concat(string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JSONObject zzj(@Nullable Bundle bundle, JSONObject jSONObject) {
        if (bundle == null) return null;
        try {
            return this.zzh(bundle);
        }
        catch (JSONException jSONException) {
            zzcbn.zzh("Error converting Bundle to JSON", jSONException);
            return null;
        }
    }

    private final void zzB(JSONArray jSONArray, @Nullable Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzh((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONArray.put((Object)this.zzi((Map)object));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zzA((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONArray.put((Object)this.zzg((Object[])object));
            return;
        }
        jSONArray.put(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzC(JSONObject jSONObject, String string, @Nullable Object serializableArray) throws JSONException {
        Object object = zzbdc.zzt;
        if (((Boolean)zzba.zzc().zza((zzbcu)object)).booleanValue()) {
            string = String.valueOf(string);
        }
        if (serializableArray instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzh((Bundle)serializableArray));
            return;
        }
        if (serializableArray instanceof Map) {
            jSONObject.put(string, (Object)this.zzi((Map)serializableArray));
            return;
        }
        if (serializableArray instanceof Collection) {
            jSONObject.put(String.valueOf(string), (Object)this.zzA((Collection)serializableArray));
            return;
        }
        if (serializableArray instanceof Object[]) {
            jSONObject.put(string, (Object)this.zzA(Arrays.asList((Object[])serializableArray)));
            return;
        }
        if (serializableArray instanceof int[]) {
            object = (int[])serializableArray;
            if (object == null) {
                serializableArray = new Integer[]{};
            } else {
                int n = ((Object)object).length;
                Integer[] integerArray = new Integer[n];
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    integerArray[n3] = (int)object[n3];
                }
                serializableArray = integerArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (serializableArray instanceof double[]) {
            object = (double[])serializableArray;
            if (object == null) {
                serializableArray = new Double[]{};
            } else {
                int n = ((Object)object).length;
                Double[] doubleArray = new Double[n];
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    doubleArray[n5] = (double)object[n5];
                }
                serializableArray = doubleArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (serializableArray instanceof long[]) {
            object = (long[])serializableArray;
            if (object == null) {
                serializableArray = new Long[]{};
            } else {
                int n = ((Object)object).length;
                Long[] longArray = new Long[n];
                int n6 = 0;
                while (n6 < n) {
                    int n7 = n6++;
                    longArray[n7] = (long)object[n7];
                }
                serializableArray = longArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (!(serializableArray instanceof boolean[])) {
            jSONObject.put(string, (Object)serializableArray);
            return;
        }
        object = (boolean[])serializableArray;
        if (object == null) {
            serializableArray = new Boolean[]{};
        } else {
            int n = ((Object)object).length;
            Boolean[] booleanArray = new Boolean[n];
            int n8 = 0;
            while (n8 < n) {
                int n9 = n8++;
                booleanArray[n9] = (boolean)object[n9];
            }
            serializableArray = booleanArray;
        }
        jSONObject.put(string, (Object)this.zzg(serializableArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzk(JSONObject jSONObject, JSONObject jSONObject2) throws JSONException {
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object2 = (String)iterator.next();
            Object object = jSONObject2.get((String)object2);
            try {
                if (!JSONObject.class.isInstance(object2 = jSONObject.get((String)object2)) || !JSONObject.class.isInstance(object)) continue;
            }
            catch (JSONException jSONException) {
                jSONObject.put((String)object2, object);
                continue;
            }
            this.zzk((JSONObject)object2, (JSONObject)object);
        }
    }

    public final void zzl(ViewGroup viewGroup, zzq zzq2, @Nullable String string, @Nullable String string2) {
        if (string2 != null) {
            zzcbn.zzj(string2);
        }
        zzcbg.zzD(viewGroup, zzq2, string, -65536, -16777216);
    }

    public final void zzm(ViewGroup viewGroup, zzq zzq2, @Nullable String string) {
        zzcbg.zzD(viewGroup, zzq2, "Ads by Google", -16777216, -1);
    }

    public final void zzn(Context context, @Nullable String string, String object, Bundle bundle, boolean bl) {
        object = new zzcbd(this);
        zzcbg.zzw(context, string, "gmob-apps", bundle, true, (zzcbf)object);
    }

    @VisibleForTesting
    public static boolean zzo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith((String)zzbfe.zzd.zze());
    }

    public static final int zzp(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    @VisibleForTesting
    public static final String zzq(StackTraceElement[] object, String string) {
        block8: {
            int n;
            int n2 = 0;
            while ((n = n2 + 1) < ((Object)object).length) {
                Object object2 = object[n2];
                String string2 = ((StackTraceElement)object2).getClassName();
                String string3 = ((StackTraceElement)object2).getMethodName();
                if ("loadAd".equalsIgnoreCase(string3)) {
                    if (zzb.equalsIgnoreCase(string2) || zzc.equalsIgnoreCase(string2) || zzd.equalsIgnoreCase(string2) || zze.equalsIgnoreCase(string2) || zzf.equalsIgnoreCase(string2) || zzg.equalsIgnoreCase(string2)) {
                        object = ((StackTraceElement)object[n]).getClassName();
                        break block8;
                    } else {
                        n2 = n;
                        continue;
                    }
                }
                n2 = n;
            }
            object = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringBuilder stringBuilder = new StringBuilder();
            if (stringTokenizer.hasMoreElements()) {
                stringBuilder.append(stringTokenizer.nextToken());
                for (int i = 2; i > 0 && stringTokenizer.hasMoreElements(); --i) {
                    stringBuilder.append(".");
                    stringBuilder.append(stringTokenizer.nextToken());
                }
                string = stringBuilder.toString();
            }
            if (object != null && !((String)object).contains(string)) {
                return object;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzr() {
        zzbcu zzbcu2 = zzbdc.zzkz;
        boolean bl = (Boolean)zzba.zzc().zza(zzbcu2);
        if (Build.VERSION.SDK_INT < 31) return Build.DEVICE.startsWith("generic");
        if (Build.FINGERPRINT.contains("generic")) return true;
        if (Build.FINGERPRINT.contains("emulator")) return true;
        if (!bl) return false;
        if (Build.HARDWARE.contains("ranchu")) return true;
        return false;
    }

    public static final boolean zzs(Context context, int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, n) == 0;
    }

    public static final boolean zzt(Context context) {
        int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
        return n == 0 || n == 2;
    }

    public static final boolean zzu() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static final int zzv(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public static final void zzw(Context context, @Nullable String object, String string, Bundle bundle, boolean bl, zzcbf zzcbf2) {
        string = context.getApplicationContext();
        if (string == null) {
            string = context;
        }
        bundle.putString("os", Build.VERSION.RELEASE);
        String string2 = String.valueOf(Build.VERSION.SDK_INT);
        bundle.putString("api", string2);
        bundle.putString("appid", string.getPackageName());
        if (object == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(GoogleApiAvailabilityLight.getInstance().getApkVersion(context));
            stringBuilder.append(".234310000");
            object = stringBuilder.toString();
        }
        bundle.putString("js", (String)object);
        context = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps");
        for (String string3 : bundle.keySet()) {
            context.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzcbf2.zza(context.toString());
    }

    public static final int zzx(Context context, int n) {
        return zzcbg.zzp(context.getResources().getDisplayMetrics(), n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final String zzy(Context object) {
        void var0_5;
        void var0_3;
        ContentResolver contentResolver = object.getContentResolver();
        if (contentResolver == null) {
            Object var0_2 = null;
        } else {
            String string = Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        }
        if (var0_3 == null || zzcbg.zzr()) {
            String string = "emulator";
        }
        return zzcbg.zzz((String)var0_5, "MD5");
    }

    private static final void zzD(ViewGroup viewGroup, zzq zzq2, @Nullable String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzcbg.zzx(context, 3);
        n = zzq2.zzf - n3;
        n3 = zzq2.zzc - n3;
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n3, 17));
        viewGroup.addView((View)frameLayout, zzq2.zzf, zzq2.zzc);
    }
}

