/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.query.UpdateClickUrlCallback;
import com.google.android.gms.ads.query.UpdateImpressionUrlsCallback;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbug;
import com.google.android.gms.internal.ads.zzbuh;
import com.google.android.gms.internal.ads.zzbui;
import com.google.android.gms.internal.ads.zzbuj;
import com.google.android.gms.internal.ads.zzbuk;
import com.google.android.gms.internal.ads.zzbul;
import com.google.android.gms.internal.ads.zzbun;
import com.google.android.gms.internal.ads.zzcae;
import com.google.android.gms.internal.ads.zzcbn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class zzbum {
    @Nonnull
    private final View zza;
    @Nullable
    private final Map zzb;
    @Nullable
    private final zzcae zzc;

    public zzbum(zzbul zzbul2) {
        this.zza = zzbul.zza(zzbul2);
        this.zzb = zzbul.zzd(zzbul2);
        this.zzc = zzbug.zza(zzbul.zza(zzbul2).getContext());
        if (this.zzc == null || this.zzb.isEmpty()) {
            return;
        }
        try {
            this.zzc.zzf(new zzbun(ObjectWrapper.wrap((Object)this.zza).asBinder(), ObjectWrapper.wrap((Object)this.zzb).asBinder()));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zza(List list) {
        if (list == null || list.isEmpty()) {
            zzcbn.zzj("No click urls were passed to recordClick");
            return;
        }
        if (this.zzc == null) {
            zzcbn.zzj("Failed to get internal reporting info generator in recordClick.");
        }
        try {
            zzcae zzcae2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcae2.zzg(list, iObjectWrapper, new zzbuk(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzg("RemoteException recording click: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(List list) {
        if (list == null || list.isEmpty()) {
            zzcbn.zzj("No impression urls were passed to recordImpression");
            return;
        }
        zzcae zzcae2 = this.zzc;
        if (zzcae2 == null) {
            zzcbn.zzj("Failed to get internal reporting info generator from recordImpression.");
            return;
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcae2.zzh(list, iObjectWrapper, new zzbuj(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzg("RemoteException recording impression urls: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(MotionEvent motionEvent) {
        zzcae zzcae2;
        zzcae2 = ((zzbum)((Object)zzcae2)).zzc;
        if (zzcae2 == null) {
            zzcbn.zze("Failed to get internal reporting info generator.");
            return;
        }
        try {
            zzcae2.zzj(ObjectWrapper.wrap((Object)motionEvent));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zzd(Uri uri, UpdateClickUrlCallback updateClickUrlCallback) {
        if (this.zzc == null) {
            updateClickUrlCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzcae zzcae2 = this.zzc;
            ArrayList<Uri> arrayList = new ArrayList<Uri>(Arrays.asList(uri));
            uri = ObjectWrapper.wrap((Object)this.zza);
            zzcae2.zzk(arrayList, (IObjectWrapper)uri, new zzbui(this, updateClickUrlCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateClickUrlCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    public final void zze(List list, UpdateImpressionUrlsCallback updateImpressionUrlsCallback) {
        if (this.zzc == null) {
            updateImpressionUrlsCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzcae zzcae2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcae2.zzl(list, iObjectWrapper, new zzbuh(this, updateImpressionUrlsCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateImpressionUrlsCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }
}

