/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzble;
import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzcbn;

@RequiresApi(api=21)
public final class zzbli {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzble zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzbli(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
        zzbdc.zza(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        block5: {
            block4: {
                zzbcu zzbcu2 = zzbdc.zzjv;
                if (!((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) break block4;
                ((zzbli)((Object)zzble2)).zzd();
                zzble zzble2 = ((zzbli)((Object)zzble2)).zzc;
                if (zzble2 != null) break block5;
            }
            return;
        }
        try {
            zzble2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        Context context = this.zza;
        this.zzc = zzay.zza().zzl(context, new zzbpo(), this.zzb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzb(String string) {
        if (!zzbli.zzc(string)) {
            return false;
        }
        ((zzbli)((Object)zzble2)).zzd();
        zzble zzble2 = ((zzbli)((Object)zzble2)).zzc;
        if (zzble2 == null) return false;
        try {
            zzble2.zzf(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    public static final boolean zzc(String string) {
        Object object = zzbdc.zzjv;
        if (!((Boolean)zzba.zzc().zza((zzbcu)object)).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        object = zzbdc.zzjx;
        if (string.length() > (Integer)zzba.zzc().zza((zzbcu)object)) {
            zzcbn.zze("H5 GMSG exceeds max length");
            return false;
        }
        object = (string = Uri.parse((String)string)).getScheme();
        return "gmsg".equals(object) && "mobileads.google.com".equals(object = string.getHost()) && "/h5ads".equals(string = string.getPath());
    }
}

