/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.os.RemoteException;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbgs;
import com.google.android.gms.internal.ads.zzcbn;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class NativeAdViewHolder {
    @NonNull
    public static final WeakHashMap zza = new WeakHashMap();
    @NotOnlyInitialized
    private zzbgs zzb;
    private WeakReference zzc;

    /*
     * WARNING - void declaration
     */
    public NativeAdViewHolder(@NonNull View containerView, @NonNull Map<String, View> clickableAssetViews, @NonNull Map<String, View> nonclickableAssetViews) {
        HashMap hashMap;
        HashMap hashMap2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"ContainerView must not be null");
        if (var1_1 instanceof NativeAdView) {
            zzcbn.zzg("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zza.get(var1_1) != null) {
            zzcbn.zzg("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zza.put(var1_1, this);
        this.zzc = new WeakReference<void>(var1_1);
        hashMap2 = NativeAdViewHolder.zza(hashMap2);
        hashMap = NativeAdViewHolder.zza(hashMap);
        this.zzb = zzay.zza().zzi((View)var1_1, hashMap2, hashMap);
    }

    /*
     * WARNING - void declaration
     */
    public final void setClickConfirmingView(@NonNull View view) {
        try {
            void var1_2;
            this.zzb.zzb(ObjectWrapper.wrap((Object)var1_2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setNativeAd(@NonNull NativeAd ad) {
        Object object = ad.zza();
        WeakReference weakReference = ((NativeAdViewHolder)this).zzc;
        weakReference = weakReference != null ? (View)weakReference.get() : null;
        if (weakReference == null) {
            zzcbn.zzj("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zza.containsKey(weakReference)) {
            zza.put(weakReference, this);
        }
        if ((this = ((NativeAdViewHolder)this).zzb) == null) return;
        try {
            this.zzc((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterNativeAd() {
        zzbgs zzbgs2 = ((NativeAdViewHolder)this_).zzb;
        if (zzbgs2 != null) {
            try {
                zzbgs2.zzd();
            }
            catch (RemoteException remoteException) {
                zzcbn.zzh("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((this_ = ((NativeAdViewHolder)this_).zzc) == null) return;
        Object this_ = (View)((Reference)this_).get();
        if (this_ == null) return;
        zza.remove(this_);
    }

    private static final HashMap zza(Map map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap(map);
    }
}

