/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.internal.client.zzej;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbug;
import com.google.android.gms.internal.ads.zzcae;
import com.google.android.gms.internal.ads.zzcbn;

public class MobileAds {
    @NonNull
    public static final String ERROR_DOMAIN = "com.google.android.gms.ads";

    @NonNull
    public static RequestConfiguration getRequestConfiguration() {
        return zzej.zzf().zzc();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static VersionInfo getVersion() {
        void var0_2;
        zzej.zzf();
        String[] stringArray = TextUtils.split((String)"22.6.0", (String)"\\.");
        if (stringArray.length != 3) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
        try {
            VersionInfo versionInfo;
            VersionInfo versionInfo2 = versionInfo = new VersionInfo(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            return var0_2;
        }
        catch (NumberFormatException numberFormatException) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
    }

    @Nullable
    public static InitializationStatus getInitializationStatus() {
        return zzej.zzf().zze();
    }

    @KeepForSdk
    private static String getInternalVersion() {
        return zzej.zzf().zzh();
    }

    private MobileAds() {
    }

    public static void disableMediationAdapterInitialization(@NonNull Context context) {
        Context context2;
        zzej.zzf().zzl(context2);
    }

    @Deprecated
    public static void enableSameAppKey(boolean enabled) {
        boolean bl;
        zzej.zzf().zzr(bl);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void initialize(@NonNull Context context) {
        Context context2;
        zzej.zzf().zzm(context2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(@NonNull Context context, @NonNull OnInitializationCompleteListener listener) {
        void var1_1;
        Context context2;
        zzej.zzf().zzm(context2, null, (OnInitializationCompleteListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openAdInspector(@NonNull Context context, @NonNull OnAdInspectorClosedListener listener) {
        void var1_1;
        Context context2;
        zzej.zzf().zzp(context2, (OnAdInspectorClosedListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openDebugMenu(@NonNull Context context, @NonNull String adUnitId) {
        void var1_1;
        Context context2;
        zzej.zzf().zzq(context2, (String)var1_1);
    }

    public static void putPublisherFirstPartyIdEnabled(boolean enabled) {
        boolean bl;
        zzej.zzf().zzr(bl);
    }

    @KeepForSdk
    public static void registerRtbAdapter(@NonNull Class<? extends RtbAdapter> adapterClass) {
        Class<? extends RtbAdapter> clazz;
        zzej.zzf().zzs(clazz);
    }

    @RequiresApi(api=21)
    public static void registerWebView(@NonNull WebView webview) {
        WebView webView;
        zzej.zzf();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (webView == null) {
            zzcbn.zzg("The webview to be registered cannot be null.");
            return;
        }
        zzcae zzcae2 = zzbug.zza(webView.getContext());
        if (zzcae2 == null) {
            zzcbn.zzj("Internal error, query info generator is null.");
            return;
        }
        try {
            zzcae2.zzi(ObjectWrapper.wrap((Object)webView));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh("", remoteException);
            return;
        }
    }

    public static void setAppMuted(boolean muted) {
        boolean bl;
        zzej.zzf().zzt(bl);
    }

    public static void setAppVolume(float volume) {
        float f;
        zzej.zzf().zzu(f);
    }

    @KeepForSdk
    private static void setPlugin(String plugin) {
        String string;
        zzej.zzf().zzv(string);
    }

    public static void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        RequestConfiguration requestConfiguration2;
        zzej.zzf().zzw(requestConfiguration2);
    }
}

