/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzdw;
import com.google.android.gms.ads.internal.client.zzdx;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzcbn;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int ERROR_CODE_APP_ID_MISSING = 8;
    public static final int ERROR_CODE_REQUEST_ID_MISMATCH = 10;
    public static final int ERROR_CODE_INVALID_AD_STRING = 11;
    public static final int ERROR_CODE_MEDIATION_NO_FILL = 9;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    @NonNull
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    protected final zzdx zza;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(@NonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzd((Class)var1_1);
    }

    @NonNull
    public Bundle getCustomTargeting() {
        return this.zza.zze();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(@NonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzf((Class)var1_1);
    }

    @Nullable
    public String getAdString() {
        return this.zza.zzj();
    }

    @NonNull
    public String getContentUrl() {
        return this.zza.zzk();
    }

    @NonNull
    public String getRequestAgent() {
        return this.zza.zzm();
    }

    @NonNull
    public List<String> getNeighboringContentUrls() {
        return this.zza.zzo();
    }

    @NonNull
    public Set<String> getKeywords() {
        return this.zza.zzq();
    }

    protected AdRequest(@NonNull Builder builder) {
        this.zza = new zzdx(builder.zza, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTestDevice(@NonNull Context context) {
        void var1_1;
        return this.zza.zzs((Context)var1_1);
    }

    public final zzdx zza() {
        return this.zza;
    }

    public static class Builder {
        protected final zzdw zza = new zzdw();

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder addCustomEventExtrasBundle(@NonNull Class<? extends CustomEvent> adapterClass, @NonNull Bundle customEventExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzq((Class)var1_1, (Bundle)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addKeyword(@NonNull String keyword) {
            void var1_1;
            this.zza.zzs((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addNetworkExtrasBundle(@NonNull Class<? extends MediationExtrasReceiver> adapterClass, @NonNull Bundle networkExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzt((Class)var1_1, (Bundle)var2_2);
            if (var1_1.equals(AdMobAdapter.class) && var2_2.getBoolean("_emulatorLiveAds")) {
                this.zza.zzw(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdString(@NonNull String adString) {
            void var1_1;
            this.zza.zzx((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setContentUrl(@NonNull String contentUrl) {
            void var1_1;
            Preconditions.checkNotNull((Object)contentUrl, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)var1_1, (Object)"Content URL must be non-empty.");
            Object[] objectArray = new Object[]{512, var1_1.length()};
            boolean bl = var1_1.length() <= 512;
            Preconditions.checkArgument((boolean)bl, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])objectArray);
            this.zza.zzz((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHttpTimeoutMillis(int httpTimeoutMillis) {
            void var1_1;
            this.zza.zzB((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNeighboringContentUrls(@NonNull List<String> neighboringContentUrls) {
            void var1_1;
            if (neighboringContentUrls == null) {
                zzcbn.zzj("neighboring content URLs list should not be null");
                return this;
            }
            this.zza.zzD((List)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestAgent(@NonNull String requestAgent) {
            void var1_1;
            this.zza.zzF((String)var1_1);
            return this;
        }

        @NonNull
        public AdRequest build() {
            return new AdRequest(this);
        }

        public Builder() {
            this.zza.zzv(AdRequest.DEVICE_ID_EMULATOR);
        }

        @Deprecated
        @NonNull
        public final Builder zza(@NonNull String string) {
            this.zza.zzv(string);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzb(@NonNull Date date) {
            this.zza.zzy(date);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzc(int n) {
            this.zza.zzA(n);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzd(boolean bl) {
            this.zza.zzC(bl);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zze(boolean bl) {
            this.zza.zzG(bl);
            return this;
        }
    }
}

