/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzbn;
import com.google.android.gms.ads.internal.client.zzbq;
import com.google.android.gms.ads.internal.client.zzdx;
import com.google.android.gms.ads.internal.client.zzeu;
import com.google.android.gms.ads.internal.client.zzfl;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbet;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzbip;
import com.google.android.gms.internal.ads.zzbiq;
import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzbtc;
import com.google.android.gms.internal.ads.zzbte;
import com.google.android.gms.internal.ads.zzcbc;
import com.google.android.gms.internal.ads.zzcbn;

public class AdLoader {
    private final zzp zza;
    private final Context zzb;
    private final zzbn zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@NonNull AdRequest adRequest, int maxNumberOfAds) {
        zzdx zzdx2 = adRequest.zza;
        try {
            void var2_3;
            this.zzc.zzh(this.zza.zza(this.zzb, zzdx2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzi();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzk("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbn zzbn2, zzp zzp2) {
        this.zzb = context;
        this.zzc = zzbn2;
        this.zza = zzp2;
    }

    final /* synthetic */ void zza(zzdx zzdx2) {
        try {
            this.zzc.zzg(this.zza.zza(this.zzb, zzdx2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh("Failed to load ad.", remoteException);
            return;
        }
    }

    private final void zzb(zzdx zzdx2) {
        block5: {
            block4: {
                zzbdc.zza(this.zzb);
                if (!((Boolean)zzbet.zzc.zze()).booleanValue()) break block4;
                zzbcu zzbcu2 = zzbdc.zzkt;
                if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) break block5;
            }
            try {
                this.zzc.zzg(this.zza.zza(this.zzb, zzdx2));
                return;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzh("Failed to load ad.", remoteException);
                return;
            }
        }
        zzcbc.zzb.execute(new zza(this, zzdx2));
    }

    public static class Builder {
        private final Context zza;
        private final zzbq zzb;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forAdManagerAdView(@NonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbq zzbq2;
            if (adSizes == null || ((void)zzbq2).length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                void var1_1;
                zzq zzq2 = new zzq(this.zza, (AdSize[])zzbq2);
                zzbq2 = this.zzb;
                zzbq2.zzj(new zzbip((OnAdManagerAdViewLoadedListener)var1_1), zzq2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to add Google Ad Manager banner ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forCustomFormatAd(@NonNull String customFormatId, @NonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbtc zzbtc2 = new zzbtc((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbtc2.zzb(), zzbtc2.zza());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder forCustomTemplateAd(@NonNull String templateId, @NonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, @Nullable NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbin zzbin2 = new zzbin((NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener)var2_3, (NativeCustomTemplateAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbin2.zze(), zzbin2.zzd());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forNativeAd(@NonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbq zzbq2 = this.zzb;
                zzbq2.zzk(new zzbte((NativeAd.OnNativeAdLoadedListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder forUnifiedNativeAd(@NonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbq zzbq2 = this.zzb;
                zzbq2.zzk(new zzbiq((UnifiedNativeAd.OnUnifiedNativeAdLoadedListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdListener(@NonNull AdListener listener) {
            try {
                void var1_1;
                zzbq zzbq2 = this.zzb;
                zzbq2.zzl(new zzg((AdListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdManagerAdViewOptions(@NonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzm((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder withNativeAdOptions(@NonNull com.google.android.gms.ads.formats.NativeAdOptions options) {
            try {
                void var1_1;
                this.zzb.zzo(new zzbfw((com.google.android.gms.ads.formats.NativeAdOptions)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Builder withNativeAdOptions(@NonNull NativeAdOptions options) {
            int n;
            boolean bl;
            int n2;
            int n3;
            boolean bl2;
            int n4;
            boolean bl3;
            boolean bl4;
            zzbq zzbq2;
            try {
                void var1_1;
                zzbq2 = this.zzb;
                bl4 = var1_1.shouldReturnUrlsForImageAssets();
                bl3 = var1_1.shouldRequestMultipleImages();
                n4 = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzfl zzfl2 = new zzfl(var1_1.getVideoOptions());
                } else {
                    Object var2_12 = null;
                }
                bl2 = var1_1.zzc();
                n3 = var1_1.getMediaAspectRatio();
                n2 = var1_1.zza();
                bl = var1_1.zzb();
                n = var1_1.zzd();
            }
            catch (RemoteException remoteException) {
                zzcbn.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
            {
                void var2_11;
                zzbfw zzbfw2 = new zzbfw(4, bl4, -1, bl3, n4, (zzfl)var2_11, bl2, n3, n2, bl, --n);
                zzbq2.zzo(zzbfw2);
                return this;
            }
        }

        @NonNull
        public AdLoader build() {
            try {
                Context context = builder.zza;
                zzbn zzbn2 = builder.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbn2, zzp.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzcbn.zzh("Failed to build AdLoader.", remoteException);
                zzeu zzeu2 = new zzeu();
                Builder builder = builder.zza;
                return new AdLoader((Context)builder, zzeu2.zzc(), zzp.zza);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Context context, @NonNull String adUnitID) {
            void var2_2;
            void var1_1;
            Context context2 = (Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            zzbq zzbq2 = zzay.zza().zzc((Context)var1_1, (String)var2_2, new zzbpo());
            this.zza = context2;
            this.zzb = zzbq2;
        }
    }
}

