/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.JsonWriter;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzbko;
import com.google.android.gms.internal.ads.zzcgj;
import com.google.android.gms.internal.ads.zzcgk;
import com.google.android.gms.internal.ads.zzcgl;
import com.google.android.gms.internal.ads.zzcgm;
import com.google.android.gms.internal.ads.zzcgn;
import com.google.android.gms.internal.ads.zzcgp;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class zzcgo {
    private static final Object zzb;
    @GuardedBy(value="lock")
    private static boolean zzc;
    @GuardedBy(value="lock")
    private static boolean zzd;
    private static final Clock zze;
    private static final Set zzf;
    private final List zzg;
    public static final /* synthetic */ int zza;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        zzb = hashSet;
        zzc = false;
        zzd = false;
        zze = DefaultClock.getInstance();
        zzf = hashSet = new HashSet<String>(Arrays.asList(new String[0]));
    }

    public zzcgo() {
        this(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzcgo(@Nullable String list) {
        if (!zzcgo.zzl()) {
            list = new List<String>();
        } else {
            list = UUID.randomUUID();
            list = ((UUID)((Object)list)).toString();
            String[] stringArray = new String[]{"network_request_".concat(String.valueOf(list))};
            list = Arrays.asList(stringArray);
        }
        this.zzg = list;
    }

    static /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzcgo.zzs(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }

    static /* synthetic */ void zzb(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzcgo.zzs(jsonWriter, map);
        jsonWriter.endObject();
    }

    private static synchronized void zzn(String string) {
        zzcgp.zzi("GMA Debug BEGIN");
        int n = 0;
        while (n < string.length()) {
            int n2 = n + 4000;
            zzcgp.zzi("GMA Debug CONTENT ".concat(String.valueOf(string.substring(n, Math.min(n2, string.length())))));
            n = n2;
        }
        zzcgp.zzi("GMA Debug FINISH");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzo(String string, zzcgn zzcgn2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            boolean bl;
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zze.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            Iterator iterator = ((zzcgo)((Object)iterator)).zzg.iterator();
            while (bl = iterator.hasNext()) {
                jsonWriter.value((String)iterator.next());
            }
            jsonWriter.endArray();
            zzcgn2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzcgp.zzh("unable to log", iOException);
        }
        zzcgo.zzn(stringWriter.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzc(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzcgo.zzl()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzq(string, string2, hashMap, byArray);
    }

    public final void zzd(String string, String string2, @Nullable Map map, @Nullable byte[] byArray) {
        if (!zzcgo.zzl()) {
            return;
        }
        this.zzq(string, "GET", map, byArray);
    }

    private final void zzp(@Nullable String string) {
        zzcgk zzcgk2 = new zzcgk(string);
        this.zzo("onNetworkRequestError", zzcgk2);
    }

    private final void zzq(String string, String string2, @Nullable Map map, @Nullable byte[] byArray) {
        zzcgl zzcgl2 = new zzcgl(string, string2, map, byArray);
        this.zzo("onNetworkRequest", zzcgl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(HttpURLConnection object, int n) {
        if (!zzcgo.zzl()) {
            return;
        }
        HashMap<String, List<String>> hashMap = ((URLConnection)object).getHeaderFields() == null ? null : new HashMap<String, List<String>>(((URLConnection)object).getHeaderFields());
        this.zzr(hashMap, n);
        if (n >= 200 && n < 300) {
            return;
        }
        try {
            object = ((HttpURLConnection)object).getResponseMessage();
        }
        catch (IOException iOException) {
            zzcgp.zzj("Can not get error message from error HttpURLConnection\n".concat(String.valueOf(iOException.getMessage())));
            object = null;
        }
        this.zzp((String)object);
    }

    public final void zzf(@Nullable Map map, int n) {
        if (!zzcgo.zzl()) {
            return;
        }
        this.zzr(map, n);
        if (n < 200 || n >= 300) {
            this.zzp(null);
            return;
        }
    }

    public final void zzg(@Nullable String string) {
        if (!zzcgo.zzl()) {
            return;
        }
        if (string == null) {
            return;
        }
        this.zzh(string.getBytes());
    }

    public final void zzh(byte[] byArray) {
        zzcgm zzcgm2 = new zzcgm(byArray);
        this.zzo("onNetworkResponseBody", zzcgm2);
    }

    private final void zzr(@Nullable Map map, int n) {
        zzcgj zzcgj2 = new zzcgj(n, map);
        this.zzo("onNetworkResponse", zzcgj2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzi() {
        Object object = zzb;
        synchronized (object) {
            zzc = false;
            zzd = false;
            String string = "Ad debug logging enablement is out of date.";
            zzcgp.zzj(string);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzj(boolean bl) {
        Object object = zzb;
        synchronized (object) {
            zzc = true;
            zzd = bl;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private static void zzs(JsonWriter jsonWriter, @Nullable Map object) throws IOException {
        if (object == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            if (zzf.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (Object object2 : (List)entry.getValue()) {
                    object2 = (String)object2;
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(object2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzcgp.zzg("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    public static boolean zzk(Context context) {
        if (!((Boolean)zzbko.zza.zze()).booleanValue()) {
            return false;
        }
        try {
            int n = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0);
            return n != 0;
        }
        catch (Exception exception) {
            zzcgp.zzk("Fail to determine debug setting.", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzl() {
        Object object = zzb;
        synchronized (object) {
            boolean bl = zzc;
            if (!bl) return false;
            bl = zzd;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzm() {
        Object object = zzb;
        synchronized (object) {
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

