/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbla;
import com.google.android.gms.internal.ads.zzcgf;
import com.google.android.gms.internal.ads.zzcgh;
import com.google.android.gms.internal.ads.zzcgp;
import com.google.android.gms.internal.ads.zzfpz;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzcgi {
    public static final Handler zza;
    private static final String zzb;
    private static final String zzc;
    private static final String zzd;
    private static final String zze;
    private static final String zzf;
    private static final String zzg;
    private float zzh = -1.0f;

    /*
     * Enabled aggressive block sorting
     */
    public static int zza(Context context, int n) {
        int n2;
        if (context == null) {
            return -1;
        }
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        if ((context = context.getResources()) == null) {
            return -1;
        }
        DisplayMetrics displayMetrics = context.getDisplayMetrics();
        if (displayMetrics == null) {
            return -1;
        }
        if ((context = context.getConfiguration()) == null) {
            return -1;
        }
        int n3 = n == 0 ? n2 : n;
        if (n3 == (n2 = context.orientation)) {
            return Math.round((float)displayMetrics.heightPixels / displayMetrics.density);
        }
        return Math.round((float)displayMetrics.widthPixels / displayMetrics.density);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int zzb(Context context, int n) {
        if (!(this.zzh < 0.0f)) return Math.round((float)n / this.zzh);
        synchronized (this) {
            float f = this.zzh;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            if (!(f < 0.0f)) return Math.round((float)n / this.zzh);
            {
                context = (WindowManager)context.getSystemService("window");
                if (context == null) {
                    return 0;
                }
                context = context.getDefaultDisplay();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                context.getMetrics(displayMetrics);
                this.zzh = displayMetrics.density;
            }
            return Math.round((float)n / this.zzh);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AdSize zzc(Context context, int n, int n2, int n3) {
        int n4 = zzcgi.zza(context, n3);
        if (n4 == -1) {
            return AdSize.INVALID;
        }
        n2 = Math.min(90, Math.round((float)n4 * 0.15f));
        n4 = n > 655 ? Math.round((float)n / 728.0f * 90.0f) : (n > 632 ? 81 : (n > 526 ? Math.round((float)n / 468.0f * 60.0f) : (n > 432 ? 68 : Math.round((float)n / 320.0f * 50.0f))));
        n4 = Math.min(n4, n2);
        n4 = Math.max(n4, 50);
        return new AdSize(n, n4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String zzd() {
        Object object = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(((UUID)object).getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(((UUID)object).getMostSignificantBits()).toByteArray();
        object = new BigInteger(1, byArray);
        object = ((BigInteger)object).toString();
        int n = 0;
        while (n < 2) {
            try {
                Object object2 = MessageDigest.getInstance("MD5");
                ((MessageDigest)object2).update(byArray);
                ((MessageDigest)object2).update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(((MessageDigest)object2).digest(), 0, byArray3, 0, 8);
                object2 = new BigInteger(1, byArray3);
                object = object2 = ((BigInteger)object2).toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return object;
    }

    /*
     * Loose catch block
     */
    @Nullable
    public static String zze(String string) {
        int n = 0;
        while (true) {
            if (n < 2) {
                Object object = MessageDigest.getInstance("MD5");
                ((MessageDigest)object).update(string.getBytes());
                Locale locale = Locale.US;
                Object[] objectArray = new Object[1];
                BigInteger bigInteger = new BigInteger(1, ((MessageDigest)object).digest());
                objectArray[0] = bigInteger;
                object = String.format(locale, "%032X", objectArray);
                return object;
            }
            return null;
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
                continue;
            }
            break;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static Throwable zzf(Throwable throwable) {
        if (((Boolean)zzbla.zzf.zze()).booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        while (throwable != null) {
            linkedList.push(throwable);
            throwable = throwable.getCause();
        }
        throwable = null;
        while (!linkedList.isEmpty()) {
            Throwable throwable2;
            Throwable throwable3 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable3.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            StackTraceElement stackTraceElement = new StackTraceElement(throwable3.getClass().getName(), "<filtered>", "<filtered>", 1);
            arrayList.add(stackTraceElement);
            int n = stackTraceElementArray.length;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement2 = stackTraceElementArray[i];
                if (zzcgi.zzn(stackTraceElement2.getClassName())) {
                    arrayList.add(stackTraceElement2);
                    bl = true;
                    continue;
                }
                String string = stackTraceElement2.getClassName();
                if (!TextUtils.isEmpty((CharSequence)string) && (string.startsWith("android.") || string.startsWith("java."))) {
                    arrayList.add(stackTraceElement2);
                    continue;
                }
                stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable = throwable == null ? new Throwable(throwable3.getMessage()) : (throwable2 = new Throwable(throwable3.getMessage(), throwable));
            throwable.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable;
    }

    private final JSONArray zzy(Collection object) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            this.zzz(jSONArray, object.next());
        }
        return jSONArray;
    }

    @VisibleForTesting
    final JSONArray zzg(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.zzz(jSONArray, objectArray[i]);
        }
        return jSONArray;
    }

    public final JSONObject zzh(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zzA(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JSONObject zzi(Map object) throws JSONException {
        try {
            boolean bl;
            JSONObject jSONObject = new JSONObject();
            Iterator iterator = object.keySet().iterator();
            while (bl = iterator.hasNext()) {
                String string = (String)iterator.next();
                this.zzA(jSONObject, string, object.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            object = new JSONException("Could not convert map to JSON: ".concat(String.valueOf(classCastException.getMessage())));
            throw object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JSONObject zzj(@Nullable Bundle bundle, JSONObject jSONObject) {
        if (bundle == null) return null;
        try {
            return this.zzh(bundle);
        }
        catch (JSONException jSONException) {
            zzcgp.zzh("Error converting Bundle to JSON", jSONException);
            return null;
        }
    }

    static {
        zzfpz zzfpz2 = new zzfpz(Looper.getMainLooper());
        zza = zzfpz2;
        zzb = AdView.class.getName();
        zzc = InterstitialAd.class.getName();
        zzd = AdManagerAdView.class.getName();
        zze = AdManagerInterstitialAd.class.getName();
        zzf = SearchAdView.class.getName();
        zzg = AdLoader.class.getName();
    }

    private final void zzz(JSONArray jSONArray, @Nullable Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzh((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONArray.put((Object)this.zzi((Map)object));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zzy((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONArray.put((Object)this.zzg((Object[])object));
            return;
        }
        jSONArray.put(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzA(JSONObject jSONObject, String string, @Nullable Object serializableArray) throws JSONException {
        Object object = zzbjc.zzr;
        if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
            string = String.valueOf(string);
        }
        if (serializableArray instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzh((Bundle)serializableArray));
            return;
        }
        if (serializableArray instanceof Map) {
            jSONObject.put(string, (Object)this.zzi((Map)serializableArray));
            return;
        }
        if (serializableArray instanceof Collection) {
            jSONObject.put(String.valueOf(string), (Object)this.zzy((Collection)serializableArray));
            return;
        }
        if (serializableArray instanceof Object[]) {
            jSONObject.put(string, (Object)this.zzy(Arrays.asList((Object[])serializableArray)));
            return;
        }
        if (serializableArray instanceof int[]) {
            object = (int[])serializableArray;
            if (object == null) {
                serializableArray = new Integer[]{};
            } else {
                int n = ((Object)object).length;
                Integer[] integerArray = new Integer[n];
                for (int i = 0; i < n; ++i) {
                    integerArray[i] = (int)object[i];
                }
                serializableArray = integerArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (serializableArray instanceof double[]) {
            object = (double[])serializableArray;
            if (object == null) {
                serializableArray = new Double[]{};
            } else {
                int n = ((Object)object).length;
                Double[] doubleArray = new Double[n];
                for (int i = 0; i < n; ++i) {
                    doubleArray[i] = (double)object[i];
                }
                serializableArray = doubleArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (serializableArray instanceof long[]) {
            object = (long[])serializableArray;
            if (object == null) {
                serializableArray = new Long[]{};
            } else {
                int n = ((Object)object).length;
                Long[] longArray = new Long[n];
                for (int i = 0; i < n; ++i) {
                    longArray[i] = (long)object[i];
                }
                serializableArray = longArray;
            }
            jSONObject.put(string, (Object)this.zzg(serializableArray));
            return;
        }
        if (!(serializableArray instanceof boolean[])) {
            jSONObject.put(string, (Object)serializableArray);
            return;
        }
        object = (boolean[])serializableArray;
        if (object == null) {
            serializableArray = new Boolean[]{};
        } else {
            int n = ((Object)object).length;
            Boolean[] booleanArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                booleanArray[i] = (boolean)object[i];
            }
            serializableArray = booleanArray;
        }
        jSONObject.put(string, (Object)this.zzg(serializableArray));
    }

    public final void zzk(ViewGroup viewGroup, zzq zzq2, @Nullable String string, @Nullable String string2) {
        if (string2 != null) {
            zzcgp.zzj(string2);
        }
        zzcgi.zzB(viewGroup, zzq2, string, -65536, -16777216);
    }

    public final void zzl(ViewGroup viewGroup, zzq zzq2, @Nullable String string) {
        zzcgi.zzB(viewGroup, zzq2, "Ads by Google", -16777216, -1);
    }

    public final void zzm(Context context, @Nullable String string, String object, Bundle bundle, boolean bl) {
        object = new zzcgf(this);
        zzcgi.zzv(context, string, "gmob-apps", bundle, true, (zzcgh)object);
    }

    @VisibleForTesting
    public static boolean zzn(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith((String)zzbla.zzd.zze());
    }

    public static final int zzo(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    @VisibleForTesting
    public static final String zzp(StackTraceElement[] object, String string) {
        block8: {
            int n;
            int n2 = 0;
            while ((n = n2 + 1) < ((Object)object).length) {
                Object object2 = object[n2];
                String string2 = ((StackTraceElement)object2).getClassName();
                if ("loadAd".equalsIgnoreCase(((StackTraceElement)object2).getMethodName())) {
                    if (zzb.equalsIgnoreCase(string2) || zzc.equalsIgnoreCase(string2) || zzd.equalsIgnoreCase(string2) || zze.equalsIgnoreCase(string2) || zzf.equalsIgnoreCase(string2) || zzg.equalsIgnoreCase(string2)) {
                        object = ((StackTraceElement)object[n]).getClassName();
                        break block8;
                    } else {
                        n2 = n;
                        continue;
                    }
                }
                n2 = n;
            }
            object = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringBuilder stringBuilder = new StringBuilder();
            if (stringTokenizer.hasMoreElements()) {
                stringBuilder.append(stringTokenizer.nextToken());
                int n = 2;
                while (true) {
                    int n3 = n + -1;
                    if (n <= 0 || !stringTokenizer.hasMoreElements()) break;
                    stringBuilder.append(".");
                    stringBuilder.append(stringTokenizer.nextToken());
                    n = n3;
                }
                string = stringBuilder.toString();
            }
            if (object != null && !((String)object).contains(string)) {
                return object;
            }
        }
        return null;
    }

    public static final boolean zzq() {
        if (Build.VERSION.SDK_INT >= 31) {
            return Build.FINGERPRINT.contains("generic") || Build.FINGERPRINT.contains("emulator");
        }
        return Build.DEVICE.startsWith("generic");
    }

    public static final boolean zzr(Context context, int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, n) == 0;
    }

    public static final boolean zzs(Context context) {
        int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
        return n == 0 || n == 2;
    }

    public static final boolean zzt() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static final int zzu(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final void zzv(Context object, @Nullable String object2, String string, Bundle bundle, boolean bl, zzcgh zzcgh2) {
        void var0_3;
        Object object3;
        void var3_9;
        Object object4 = object.getApplicationContext();
        if (object4 == null) {
            object4 = object;
        }
        var3_9.putString("os", Build.VERSION.RELEASE);
        var3_9.putString("api", String.valueOf(Build.VERSION.SDK_INT));
        var3_9.putString("appid", object4.getPackageName());
        if (object3 == null) {
            object3 = GoogleApiAvailabilityLight.getInstance();
            int n = object3.getApkVersion(object);
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(n);
            ((StringBuilder)object3).append(".223104000");
            String string2 = ((StringBuilder)object3).toString();
        } else {
            void var0_6 = object3;
        }
        var3_9.putString("js", (String)var0_3);
        Uri.Builder builder2 = new Uri.Builder();
        builder2 = builder2.scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps");
        object3 = var3_9.keySet().iterator();
        while (true) {
            if (!object3.hasNext()) {
                void var5_11;
                var5_11.zza(builder2.toString());
                return;
            }
            object4 = (String)object3.next();
            builder2.appendQueryParameter((String)object4, var3_9.getString((String)object4));
        }
    }

    public static final int zzw(Context context, int n) {
        return zzcgi.zzo(context.getResources().getDisplayMetrics(), n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final String zzx(Context object) {
        void var0_5;
        void var0_3;
        ContentResolver contentResolver = object.getContentResolver();
        if (contentResolver == null) {
            Object var0_2 = null;
        } else {
            String string = Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        }
        if (var0_3 == null || zzcgi.zzq()) {
            String string = "emulator";
        }
        return zzcgi.zze((String)var0_5);
    }

    private static final void zzB(ViewGroup viewGroup, zzq zzq2, @Nullable String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        string = new FrameLayout(context);
        string.setBackgroundColor(n);
        n = zzcgi.zzw(context, 3);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(zzq2.zzf - n, zzq2.zzc - n, 17);
        string.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        viewGroup.addView((View)string, zzq2.zzf, zzq2.zzc);
    }
}

