/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.ads.internal.client.zzau;
import com.google.android.gms.ads.internal.client.zzaw;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbqu;
import com.google.android.gms.internal.ads.zzbvh;
import com.google.android.gms.internal.ads.zzcgp;

@RequiresApi(api=21)
public final class zzbqy {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzbqu zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzbqy(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
        zzbjc.zzc(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza() {
        zzbiu zzbiu2 = zzbjc.zzif;
        if (!((Boolean)zzay.zzc().zzb(zzbiu2)).booleanValue()) {
            return;
        }
        ((zzbqy)((Object)zzbqu2)).zzd();
        zzbqu zzbqu2 = ((zzbqy)((Object)zzbqu2)).zzc;
        if (zzbqu2 == null) return;
        try {
            zzbqu2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzau zzau2 = zzaw.zza();
        Context context = this.zza;
        zzbvh zzbvh2 = new zzbvh();
        this.zzc = zzau2.zzk(context, zzbvh2, this.zzb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzb(String string) {
        if (!zzbqy.zzc(string)) {
            return false;
        }
        ((zzbqy)((Object)zzbqu2)).zzd();
        zzbqu zzbqu2 = ((zzbqy)((Object)zzbqu2)).zzc;
        if (zzbqu2 == null) return false;
        try {
            zzbqu2.zzf(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    public static final boolean zzc(String string) {
        zzbiu zzbiu2 = zzbjc.zzif;
        if (!((Boolean)zzay.zzc().zzb(zzbiu2)).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzbiu zzbiu3 = zzbjc.zzih;
        if (n > (Integer)zzay.zzc().zzb(zzbiu3)) {
            zzcgp.zze("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

