/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.zzff;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzblt;

@SafeParcelable.Class(creator="NativeAdOptionsParcelCreator")
public final class zzbls
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzbls> CREATOR;
    @SafeParcelable.Field(id=1)
    public final int zza;
    @SafeParcelable.Field(id=2)
    public final boolean zzb;
    @SafeParcelable.Field(id=3)
    public final int zzc;
    @SafeParcelable.Field(id=4)
    public final boolean zzd;
    @SafeParcelable.Field(id=5)
    public final int zze;
    @SafeParcelable.Field(id=6)
    @Nullable
    public final zzff zzf;
    @SafeParcelable.Field(id=7)
    public final boolean zzg;
    @SafeParcelable.Field(id=8)
    public final int zzh;

    @NonNull
    public static com.google.android.gms.ads.nativead.NativeAdOptions zza(@Nullable zzbls zzbls2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (zzbls2 == null) {
            return builder.build();
        }
        switch (zzbls2.zza) {
            case 4: {
                builder.setRequestCustomMuteThisAd(zzbls2.zzg);
                builder.setMediaAspectRatio(zzbls2.zzh);
            }
            case 3: {
                zzff zzff2 = zzbls2.zzf;
                if (zzff2 != null) {
                    VideoOptions videoOptions = new VideoOptions(zzff2);
                    builder.setVideoOptions(videoOptions);
                }
            }
            case 2: {
                builder.setAdChoicesPlacement(zzbls2.zze);
            }
        }
        builder.setReturnUrlsForImageAssets(zzbls2.zzb);
        builder.setRequestMultipleImages(zzbls2.zzd);
        return builder.build();
    }

    static {
        zzblt zzblt2;
        CREATOR = zzblt2 = new zzblt();
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzbls(NativeAdOptions nativeAdOptions) {
        boolean bl = nativeAdOptions.shouldReturnUrlsForImageAssets();
        int n = nativeAdOptions.getImageOrientation();
        boolean bl2 = nativeAdOptions.shouldRequestMultipleImages();
        int n2 = nativeAdOptions.getAdChoicesPlacement();
        zzff zzff2 = nativeAdOptions.getVideoOptions() != null ? new zzff(nativeAdOptions.getVideoOptions()) : null;
        this(4, bl, n, bl2, n2, zzff2, nativeAdOptions.zza(), nativeAdOptions.getMediaAspectRatio());
    }

    @SafeParcelable.Constructor
    public zzbls(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) zzff zzff2, @SafeParcelable.Param(id=7) boolean bl3, @SafeParcelable.Param(id=8) int n4) {
        this.zza = n;
        this.zzb = bl;
        this.zzc = n2;
        this.zzd = bl2;
        this.zze = n3;
        this.zzf = zzff2;
        this.zzg = bl3;
        this.zzh = n4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zza);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)2, (boolean)this.zzb);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.zzd);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)5, (int)this.zze);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)6, (Parcelable)this.zzf, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)7, (boolean)this.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)8, (int)this.zzh);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }
}

