/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzdu;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.ads.zzcgp;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class SearchAdView
extends ViewGroup {
    @NotOnlyInitialized
    private final zzdu zza;

    @NonNull
    public AdListener getAdListener() {
        return this.zza.zza();
    }

    @Nullable
    public AdSize getAdSize() {
        return this.zza.zzb();
    }

    @NonNull
    public String getAdUnitId() {
        return this.zza.zzj();
    }

    public SearchAdView(@NonNull Context context) {
        super((Context)zzdu2);
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@NonNull Context context, @NonNull AttributeSet attrs) {
        super((Context)zzdu2, (AttributeSet)var2_2);
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle) {
        super((Context)zzdu2, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, false);
    }

    public void destroy() {
        this.zza.zzk();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        void var1_1;
        if (!AdSize.SEARCH.equals(object.getAdSize())) {
            Object object = new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
            throw object;
        }
        object.zza.zzm(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull SearchAdRequest searchAdRequest) {
        void var1_1;
        this.zza.zzm(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n) / 2;
            var3_4 = (var5_6 - var3_4 - n2) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n), (int)(var3_4 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        void var2_2;
        void var1_1;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, (int)var1_1, (int)var2_2);
            n3 = object.getMeasuredWidth();
            n2 = object.getMeasuredHeight();
            n = n3;
            n3 = n2;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgp.zzh("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n2 = ((AdSize)object).getWidthInPixels(context);
                n3 = ((AdSize)object).getHeightInPixels(context);
                n = n2;
            } else {
                n = 0;
                n3 = 0;
            }
        }
        n2 = this.getSuggestedMinimumWidth();
        n = Math.max(n, n2);
        n2 = this.getSuggestedMinimumHeight();
        n3 = Math.max(n3, n2);
        this.setMeasuredDimension(View.resolveSize((int)n, (int)var1_1), View.resolveSize((int)n3, (int)var2_2));
    }

    public void pause() {
        this.zza.zzn();
    }

    public void resume() {
        this.zza.zzp();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@NonNull AdListener adListener) {
        void var1_1;
        this.zza.zzr((AdListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        void var1_1;
        zzdu this_ = ((SearchAdView)((Object)this_)).zza;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this_.zzs(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@NonNull String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }
}

