/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzaw;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzcgi;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zzq
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzq> CREATOR;
    @SafeParcelable.Field(id=2)
    public final String zza;
    @SafeParcelable.Field(id=3)
    public final int zzb;
    @SafeParcelable.Field(id=4)
    public final int zzc;
    @SafeParcelable.Field(id=5)
    public final boolean zzd;
    @SafeParcelable.Field(id=6)
    public final int zze;
    @SafeParcelable.Field(id=7)
    public final int zzf;
    @SafeParcelable.Field(id=8)
    public final zzq[] zzg;
    @SafeParcelable.Field(id=9)
    public final boolean zzh;
    @SafeParcelable.Field(id=10)
    public final boolean zzi;
    @SafeParcelable.Field(id=11)
    public boolean zzj;
    @SafeParcelable.Field(id=12)
    public boolean zzk;
    @SafeParcelable.Field(id=13)
    public boolean zzl;
    @SafeParcelable.Field(id=14)
    public boolean zzm;
    @SafeParcelable.Field(id=15)
    public boolean zzn;
    @SafeParcelable.Field(id=16)
    public boolean zzo;

    private static int zzf(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static int zza(DisplayMetrics displayMetrics) {
        return (int)((float)zzq.zzf(displayMetrics) * displayMetrics.density);
    }

    public static zzq zzb() {
        zzq zzq2 = new zzq("interstitial_mb", 0, 0, false, 0, 0, null, false, false, false, false, true, false, false, false);
        return zzq2;
    }

    public static zzq zzc() {
        zzq zzq2 = new zzq("320x50_mb", 0, 0, false, 0, 0, null, true, false, false, false, false, false, false, false);
        return zzq2;
    }

    public static zzq zzd() {
        zzq zzq2 = new zzq("reward_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false, false);
        return zzq2;
    }

    public static zzq zze() {
        zzq zzq2 = new zzq("invalid", 0, 0, false, 0, 0, null, false, false, false, true, false, false, false, false);
        return zzq2;
    }

    static {
        zzr zzr2;
        CREATOR = zzr2 = new zzr();
    }

    public zzq() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false, false);
    }

    public zzq(Context context, AdSize adSize) {
        AdSize[] adSizeArray = new AdSize[]{adSize};
        this(context, adSizeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzq(Context context, AdSize[] adSizeArray) {
        int n;
        int n2;
        DisplayMetrics displayMetrics;
        int n3;
        int n4;
        AdSize adSize;
        block20: {
            block18: {
                double d;
                block19: {
                    int n5;
                    adSize = adSizeArray[0];
                    this.zzd = false;
                    this.zzi = adSize.isFluid();
                    this.zzm = com.google.android.gms.ads.zzb.zzf(adSize);
                    this.zzn = com.google.android.gms.ads.zzb.zzg(adSize);
                    this.zzo = n4 = com.google.android.gms.ads.zzb.zzh(adSize);
                    if (this.zzi) {
                        this.zze = AdSize.BANNER.getWidth();
                        this.zzb = n4 = AdSize.BANNER.getHeight();
                    } else if (this.zzn) {
                        this.zze = adSize.getWidth();
                        this.zzb = n4 = com.google.android.gms.ads.zzb.zza(adSize);
                    } else if (n4 != 0) {
                        this.zze = adSize.getWidth();
                        this.zzb = n4 = com.google.android.gms.ads.zzb.zzb(adSize);
                    } else {
                        this.zze = adSize.getWidth();
                        this.zzb = n4 = adSize.getHeight();
                    }
                    n3 = this.zze;
                    displayMetrics = context.getResources().getDisplayMetrics();
                    if (n3 != -1) break block18;
                    zzaw.zzb();
                    if (context.getResources().getConfiguration().orientation == 2) {
                        DisplayMetrics displayMetrics2 = context.getResources().getDisplayMetrics();
                        if ((int)((float)displayMetrics2.heightPixels / displayMetrics2.density) < 600) {
                            zzaw.zzb();
                            displayMetrics2 = context.getResources().getDisplayMetrics();
                            WindowManager windowManager = (WindowManager)context.getSystemService("window");
                            if (windowManager != null) {
                                windowManager = windowManager.getDefaultDisplay();
                                windowManager.getRealMetrics(displayMetrics2);
                                int n6 = displayMetrics2.heightPixels;
                                int n7 = displayMetrics2.widthPixels;
                                windowManager.getMetrics(displayMetrics2);
                                n5 = displayMetrics2.heightPixels;
                                n2 = displayMetrics2.widthPixels;
                                if (n5 == n6 && n2 == n7) {
                                    n5 = displayMetrics.widthPixels;
                                    zzaw.zzb();
                                    n2 = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
                                    n2 = n2 > 0 ? context.getResources().getDimensionPixelSize(n2) : 0;
                                }
                            }
                        }
                    }
                    this.zzf = n2 = displayMetrics.widthPixels;
                    break block19;
                    this.zzf = n2 = n5 - n2;
                }
                if ((d = (double)((float)n2 / displayMetrics.density)) - (double)(n2 = (int)d) >= 0.01) {
                    ++n2;
                }
                break block20;
            }
            n2 = this.zze;
            zzaw.zzb();
            this.zzf = zzcgi.zzo(displayMetrics, this.zze);
        }
        int n8 = n4 == -2 ? zzq.zzf(displayMetrics) : this.zzb;
        zzaw.zzb();
        this.zzc = zzcgi.zzo(displayMetrics, n8);
        if (n3 == -1 || n4 == -2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n2);
            stringBuilder.append("x");
            stringBuilder.append(n8);
            stringBuilder.append("_as");
            this.zza = stringBuilder.toString();
        } else if (this.zzn || this.zzo) {
            n4 = this.zze;
            n2 = this.zzb;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n4);
            stringBuilder.append("x");
            stringBuilder.append(n2);
            stringBuilder.append("_as");
            this.zza = stringBuilder.toString();
        } else {
            this.zza = this.zzi ? "320x50_mb" : adSize.toString();
        }
        if ((n = adSizeArray.length) > 1) {
            this.zzg = new zzq[n];
            for (n = 0; n < adSizeArray.length; ++n) {
                zzq zzq2;
                zzq[] zzqArray = this.zzg;
                zzqArray[n] = zzq2 = new zzq(context, adSizeArray[n]);
            }
        } else {
            this.zzg = null;
        }
        this.zzh = false;
        this.zzj = false;
    }

    @SafeParcelable.Constructor
    zzq(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzq[] zzqArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) boolean bl8, @SafeParcelable.Param(id=16) boolean bl9) {
        this.zza = string;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = bl;
        this.zze = n3;
        this.zzf = n4;
        this.zzg = zzqArray;
        this.zzh = bl2;
        this.zzi = bl3;
        this.zzj = bl4;
        this.zzk = bl5;
        this.zzl = bl6;
        this.zzm = bl7;
        this.zzn = bl8;
        this.zzo = bl9;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zzb);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.zzd);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)6, (int)this.zze);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.zzf);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)8, (Parcelable[])this.zzg, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)9, (boolean)this.zzh);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)12, (boolean)this.zzk);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)13, (boolean)this.zzl);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)14, (boolean)this.zzm);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)15, (boolean)this.zzn);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)16, (boolean)this.zzo);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }
}

