/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbvd;
import com.google.android.gms.internal.ads.zzcgp;

public final class zzee
extends ContentProvider {
    public final int delete(@NonNull Uri uri, String string, String[] stringArray) {
        return 0;
    }

    public final int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        return 0;
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        return null;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return null;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void attachInfo(Context object, ProviderInfo providerInfo) {
        void var2_12;
        Bundle bundle;
        void var1_7;
        try {
            bundle = Wrappers.packageManager((Context)var1_7).getApplicationInfo((String)var1_7.getPackageName(), (int)128).metaData;
        }
        catch (NullPointerException nullPointerException) {
            zzcgp.zzh("Failed to load metadata: Null pointer exception.", nullPointerException);
            bundle = null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzcgp.zzh("Failed to load metadata: Package name not found.", nameNotFoundException);
            bundle = null;
        }
        zzbvd zzbvd2 = zzbvd.zza();
        if (bundle == null) {
            zzcgp.zzg("Metadata was null.");
        } else {
            String string = (String)bundle.get("com.google.android.gms.ads.APPLICATION_ID");
            Boolean bl = (Boolean)bundle.get("com.google.android.gms.ads.AD_MANAGER_APP");
            Boolean bl2 = (Boolean)bundle.get("com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT");
            String string2 = (String)bundle.get("com.google.android.gms.ads.INTEGRATION_MANAGER");
            if (string != null && !string.matches("^/\\d+~.+$")) {
                if (!string.matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$")) {
                    IllegalStateException illegalStateException = new IllegalStateException("\n\n******************************************************************************\n* Invalid application ID. Follow instructions here:                          *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to find your app ID.                                                       *\n******************************************************************************\n\n");
                    throw illegalStateException;
                }
                zzcgp.zze("Publisher provided Google AdMob App ID in manifest: ".concat(string));
                if (bl2 == null || !bl2.booleanValue()) {
                    zzbvd2.zzb((Context)var1_7, string);
                }
            } else if (bl == null || !bl.booleanValue()) {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    IllegalStateException illegalStateException = new IllegalStateException("\n\n******************************************************************************\n* The Google Mobile Ads SDK was initialized incorrectly. AdMob publishers    *\n* should follow the instructions here:                                       *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to add a valid App ID inside the AndroidManifest.                          *\n* Google Ad Manager publishers should follow instructions here:              *\n* https://googlemobileadssdk.page.link/ad-manager-android-update-manifest.   *\n******************************************************************************\n\n");
                    throw illegalStateException;
                }
                zzcgp.zze("The Google Mobile Ads SDK is integrated by ".concat(String.valueOf(string2)));
            }
        }
        if (bundle != null) {
            boolean bl = bundle.getBoolean("com.google.android.gms.ads.flag.OPTIMIZE_INITIALIZATION", false);
            boolean bl3 = bundle.getBoolean("com.google.android.gms.ads.flag.OPTIMIZE_AD_LOADING", false);
            if (bl) {
                zzcgp.zze("com.google.android.gms.ads.flag.OPTIMIZE_INITIALIZATION is enabled");
            }
            if (bl3) {
                zzcgp.zze("com.google.android.gms.ads.flag.OPTIMIZE_AD_LOADING is enabled");
            }
        }
        super.attachInfo((Context)var1_7, (ProviderInfo)var2_12);
        return;
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.APPLICATION_ID metadata must have a String value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.AD_MANAGER_APP metadata must have a boolean value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT metadata must have a boolean value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.INTEGRATION_MANAGER metadata must have a String value.", classCastException);
            throw illegalStateException;
        }
    }

    public final boolean onCreate() {
        return false;
    }
}

