/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.admanager;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.BaseAdView;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.ads.admanager.zzb;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzbs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbkq;
import com.google.android.gms.internal.ads.zzcaf;
import com.google.android.gms.internal.ads.zzcge;

public final class AdManagerAdView
extends BaseAdView {
    @NonNull
    public VideoController getVideoController() {
        return this.zza.zzf();
    }

    @Nullable
    public VideoOptions getVideoOptions() {
        return this.zza.zzg();
    }

    @Nullable
    public AppEventListener getAppEventListener() {
        return this.zza.zzh();
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context) {
        super((Context)var1_1, 0);
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context, @NonNull AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2, true);
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, 0, true);
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbjc.zzc(this.getContext());
        if (((Boolean)zzbkq.zzf.zze()).booleanValue()) {
            Object object = zzbjc.zziM;
            if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
                object = zzcge.zzb;
                zzb zzb2 = new zzb(this, (AdManagerAdRequest)var1_1);
                object.execute(zzb2);
                return;
            }
        }
        this.zza.zzm(var1_1.zza());
    }

    public void recordManualImpression() {
        this.zza.zzo();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSizes(AdSize ... adSizes) {
        void var1_1;
        if (adSizes == null || ((void)var1_1).length <= 0) {
            Object object = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            throw object;
        }
        object.zza.zzt((AdSize[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppEventListener(@Nullable AppEventListener appEventListener) {
        void var1_1;
        this.zza.zzv((AppEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        void var1_1;
        this.zza.zzw((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setVideoOptions(@NonNull VideoOptions videoOptions) {
        void var1_1;
        this.zza.zzy((VideoOptions)var1_1);
    }

    @Nullable
    public AdSize[] getAdSizes() {
        return this.zza.zzB();
    }

    final /* synthetic */ void zza(AdManagerAdRequest adManagerAdRequest) {
        try {
            this.zza.zzm(((AdRequest)adManagerAdRequest).zza());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzcaf.zza(this.getContext()).zzd(illegalStateException, "AdManagerAdView.loadAd");
            return;
        }
    }

    public final boolean zzb(zzbs zzbs2) {
        return this.zza.zzz(zzbs2);
    }
}

