/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.internal.client.zzaw;
import com.google.android.gms.ads.internal.client.zzdh;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzcgp;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Nullable
    private final zzdh zza;
    private final List zzb;
    @Nullable
    private AdapterResponseInfo zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Bundle getResponseExtras() {
        try {
            zzdh this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return new Bundle();
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Could not forward getResponseExtras to ResponseInfo.", remoteException);
            return new Bundle();
        }
        return this_.zze();
    }

    @Nullable
    public AdapterResponseInfo getLoadedAdapterResponseInfo() {
        return this.zzc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getMediationAdapterClassName() {
        try {
            zzdh this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Could not forward getMediationAdapterClassName to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzg();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getResponseId() {
        try {
            zzdh this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Could not forward getResponseId to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzi();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        try {
            return ((ResponseInfo)this).zzd().toString(2);
        }
        catch (JSONException jSONException) {
            return "Error forming toString output.";
        }
    }

    @NonNull
    public List<AdapterResponseInfo> getAdapterResponses() {
        return this.zzb;
    }

    @Nullable
    public static ResponseInfo zza(@Nullable zzdh zzdh2) {
        if (zzdh2 != null) {
            ResponseInfo responseInfo = new ResponseInfo(zzdh2);
            return responseInfo;
        }
        return null;
    }

    @NonNull
    public static ResponseInfo zzb(@Nullable zzdh zzdh2) {
        ResponseInfo responseInfo = new ResponseInfo(zzdh2);
        return responseInfo;
    }

    @VisibleForTesting
    @Nullable
    public final zzdh zzc() {
        return this.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public final JSONObject zzd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Object object = this.getResponseId();
        if (object == null) {
            jSONObject.put("Response ID", (Object)"null");
        } else {
            jSONObject.put("Response ID", object);
        }
        if ((object = this.getMediationAdapterClassName()) == null) {
            jSONObject.put("Mediation Adapter Class Name", (Object)"null");
        } else {
            jSONObject.put("Mediation Adapter Class Name", object);
        }
        object = new JSONArray();
        Iterator iterator = this.zzb.iterator();
        while (iterator.hasNext()) {
            object.put((Object)((AdapterResponseInfo)iterator.next()).zzb());
        }
        jSONObject.put("Adapter Responses", object);
        object = this.zzc;
        if (object != null) {
            jSONObject.put("Loaded Adapter Response", (Object)((AdapterResponseInfo)object).zzb());
        }
        if ((this = this.getResponseExtras()) != null) {
            jSONObject.put("Response Extras", (Object)zzaw.zzb().zzh((Bundle)this));
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ResponseInfo(@Nullable zzdh iterator) {
        block7: {
            this.zza = iterator;
            iterator = new Iterator();
            this.zzb = iterator;
            iterator = this.zza;
            if (iterator != null) {
                try {
                    if ((iterator = iterator.zzj()) == null) break block7;
                    iterator = iterator.iterator();
                }
                catch (RemoteException remoteException) {
                    zzcgp.zzh("Could not forward getAdapterResponseInfo to ResponseInfo.", remoteException);
                }
                while (iterator.hasNext()) {
                    AdapterResponseInfo adapterResponseInfo = AdapterResponseInfo.zza((zzu)((Object)iterator.next()));
                    if (adapterResponseInfo == null) continue;
                    this.zzb.add(adapterResponseInfo);
                }
            }
        }
        if ((iterator = this.zza) == null) {
            return;
        }
        try {
            if ((iterator = iterator.zzf()) == null) return;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Could not forward getLoadedAdapterResponse to ResponseInfo.", remoteException);
            return;
        }
        this.zzc = AdapterResponseInfo.zza(iterator);
    }
}

