/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.internal.client.zzed;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbzt;
import com.google.android.gms.internal.ads.zzcfg;
import com.google.android.gms.internal.ads.zzcgp;

public class MobileAds {
    @NonNull
    public static final String ERROR_DOMAIN = "com.google.android.gms.ads";

    @NonNull
    public static RequestConfiguration getRequestConfiguration() {
        return zzed.zzf().zzc();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static VersionInfo getVersion() {
        void var0_2;
        zzed.zzf();
        String[] stringArray = TextUtils.split((String)"21.3.0", (String)"\\.");
        if (stringArray.length != 3) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
        try {
            VersionInfo versionInfo;
            VersionInfo versionInfo2 = versionInfo = new VersionInfo(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            return var0_2;
        }
        catch (NumberFormatException numberFormatException) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
    }

    @Nullable
    public static InitializationStatus getInitializationStatus() {
        return zzed.zzf().zze();
    }

    @Deprecated
    @NonNull
    public static String getVersionString() {
        return zzed.zzf().zzh();
    }

    private MobileAds() {
    }

    public static void disableMediationAdapterInitialization(@NonNull Context context) {
        Context context2;
        zzed.zzf().zzl(context2);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void initialize(@NonNull Context context) {
        Context context2;
        zzed.zzf().zzm(context2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(@NonNull Context context, @NonNull OnInitializationCompleteListener listener) {
        void var1_1;
        Context context2;
        zzed.zzf().zzm(context2, null, (OnInitializationCompleteListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openAdInspector(@NonNull Context context, @NonNull OnAdInspectorClosedListener listener) {
        void var1_1;
        Context context2;
        zzed.zzf().zzp(context2, (OnAdInspectorClosedListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openDebugMenu(@NonNull Context context, @NonNull String adUnitId) {
        void var1_1;
        Context context2;
        zzed.zzf().zzq(context2, (String)var1_1);
    }

    @KeepForSdk
    public static void registerRtbAdapter(@NonNull Class<? extends RtbAdapter> adapterClass) {
        Class<? extends RtbAdapter> clazz;
        zzed.zzf().zzr(clazz);
    }

    @RequiresApi(api=21)
    public static void registerWebView(@NonNull WebView webview) {
        WebView webView;
        zzed.zzf();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (webView == null) {
            zzcgp.zzg("The webview to be registered cannot be null.");
            return;
        }
        zzcfg zzcfg2 = zzbzt.zza(webView.getContext());
        if (zzcfg2 == null) {
            zzcgp.zzj("Internal error, query info generator is null.");
            return;
        }
        try {
            zzcfg2.zzi(ObjectWrapper.wrap((Object)webView));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("", remoteException);
            return;
        }
    }

    public static void setAppMuted(boolean muted) {
        boolean bl;
        zzed.zzf().zzs(bl);
    }

    public static void setAppVolume(float volume) {
        float f;
        zzed.zzf().zzt(f);
    }

    public static void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        RequestConfiguration requestConfiguration2;
        zzed.zzf().zzu(requestConfiguration2);
    }
}

